/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.ProductionData;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import java.util.ArrayList;
import java.util.Hashtable;

public class Production {
    private int tag;
    private static int nextTag = 0;
    private static ArrayList<ProductionData> data = new ArrayList(64);
    private static Hashtable<ProductionData, Integer> tags = new Hashtable();

    public static Production production(Symbol name, Terminal operator, NonTerminal leftSide, ArrayList<GrammarSymbol> rightSide) {
        ArrayList<GrammarSymbol> rightSideCopy = new ArrayList<GrammarSymbol>(rightSide);
        return new Production(name, operator, leftSide, rightSideCopy);
    }

    public static Production production(Symbol name, NonTerminal leftSide, GrammarSymbol ... rightSide) {
        return Production.production(name, null, leftSide, rightSide);
    }

    public static Production production(Symbol name, Terminal operator, NonTerminal leftSide, GrammarSymbol ... rightSide) {
        ArrayList<GrammarSymbol> rightSideCopy = new ArrayList<GrammarSymbol>();
        for (GrammarSymbol gs : rightSide) {
            rightSideCopy.add(gs);
        }
        return new Production(name, operator, leftSide, rightSideCopy);
    }

    private Production(Symbol name, Terminal operator, NonTerminal leftSide, ArrayList<GrammarSymbol> rightSide) {
        ProductionData newData = new ProductionData(name, operator, leftSide, rightSide);
        if (tags.containsKey(newData)) {
            this.tag = tags.get(newData);
        } else {
            this.tag = nextTag++;
            data.add(newData);
            tags.put(newData, this.tag);
        }
    }

    public int length() {
        return data.get(this.tag).length();
    }

    public Symbol getName() {
        return data.get(this.tag).getName();
    }

    public NonTerminal getLeft() {
        return data.get(this.tag).getLeft();
    }

    public Iterable<GrammarSymbol> getRight() {
        return data.get(this.tag).getRight();
    }

    public Terminal getPrecedenceSymbol() {
        return data.get(this.tag).getPrecedenceSymbol();
    }

    public GrammarSymbol getSymbol(int index) {
        return data.get(this.tag).getSymbol(index);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Production) {
            return this.tag == ((Production)rhs).tag;
        }
        return false;
    }

    public String toString() {
        return data.get(this.tag).toString();
    }

    public int hashCode() {
        return this.tag;
    }
}

