/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ContextStack;
import common.DecoratedNode;
import common.FileContextVisualization;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.SimplifiedContextStack;
import common.Thunk;
import common.TopNode;
import common.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;
import silver.core.Init;
import silver.core.NLocation;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    private FileContextVisualization cStack;
    private ContextStack contextStack;
    private SimplifiedContextStack sStack;
    private int currentLine;
    private int currentColumn;
    private boolean toggleNameDisplay;
    private boolean toggleCStackDisplay;
    private boolean toggleHeadlessAttributes;
    private String[] toggleChoices;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    public void runingDebug(DecoratedNode tree) {
        Scanner inp = new Scanner(System.in);
        this.toggleNameDisplay = false;
        this.toggleCStackDisplay = true;
        this.toggleHeadlessAttributes = false;
        this.toggleChoices = new String[]{"nameDisplay", "cStackDisplay", "fullAttributeNames"};
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack();
        this.cStack = new FileContextVisualization("context.txt", "********************************");
        this.cStack.push(this.currentNode);
        this.contextStack = this.cStack.getContextStack();
        this.sStack = new SimplifiedContextStack(this.contextStack);
        this.sStack.generateHTMLFile();
        System.out.println("Enter characters, and 'q' to quit.");
        if (this.toggleCStackDisplay) {
            this.cStack.show();
        }
        if (this.toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        block46: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            String userInput = inp.nextLine();
            String[] userInputList = userInput.split(" ");
            switch (userInputList[0]) {
                case "up": 
                case "u": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up");
                        break;
                    }
                    if (this.up() == -1) continue block46;
                    this.updateDisplay();
                    break;
                }
                case "down": 
                case "d": {
                    String childName = "";
                    if (userInputList.length == 1) {
                        String currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
                        String[] listCurrentProduction = currentProduction.split("\\s+");
                        String[] childNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
                        System.out.println("Which child?");
                        Debug.displayArray(childNames);
                        System.out.print(">DEBUGGER-PROMPT$");
                        childName = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        childName = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: down <node name>");
                        break;
                    }
                    try {
                        if (this.down(childName) == -1) {
                            System.out.println("invalid child");
                        }
                    }
                    catch (NullPointerException e) {
                        System.out.println("Null pointer");
                        break;
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bound");
                        break;
                    }
                    this.updateDisplay();
                    break;
                }
                case "undo": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo");
                        break;
                    }
                    if (this.undo() == -1) continue block46;
                    this.updateDisplay();
                    break;
                }
                case "forwards": 
                case "f": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    if (this.forwards() == -1) continue block46;
                    this.updateDisplay();
                    break;
                }
                case "backtrack": 
                case "backwards": 
                case "b": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    if (this.backtrack() == -1) continue block46;
                    this.updateDisplay();
                    break;
                }
                case "toggle": {
                    String toggleInput = "";
                    if (userInputList.length == 1) {
                        System.out.println("Which toggle?");
                        Debug.displayArray(this.toggleChoices);
                        System.out.print(">DEBUGGER-PROMPT$");
                        toggleInput = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        toggleInput = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: toggle <toggle name>");
                        break;
                    }
                    this.toggle(toggleInput);
                    break;
                }
                case "name": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: name");
                        break;
                    }
                    this.printName(this.currentNode);
                    break;
                }
                case "equation": 
                case "eq": {
                    String attributeNameInput = "";
                    if (userInputList.length == 1) {
                        List<String> attributeListView = Debug.allAttributesList(this.currentNode);
                        String[] attributeArrayView = attributeListView.toArray(new String[attributeListView.size()]);
                        System.out.println("Which attribute?");
                        Debug.displayArray(attributeArrayView);
                        System.out.print(">DEBUGGER-PROMPT$");
                        attributeNameInput = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        attributeNameInput = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: eq <node name>");
                        break;
                    }
                    try {
                        if (this.equationHelper(attributeNameInput) != -1) continue block46;
                        System.out.println("invalid attribute");
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("Index out of bounds");
                    }
                    continue block46;
                }
                case "update": 
                case "l": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: list");
                        break;
                    }
                    this.updateDisplay();
                    break;
                }
                case "view": 
                case "v": {
                    String attributeInput = "";
                    if (userInputList.length == 1) {
                        List<String> attributeList = Debug.allAttributesList(this.currentNode);
                        String[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
                        System.out.println("Which attribute?");
                        Debug.displayArray(attributeArray);
                        System.out.print(">DEBUGGER-PROMPT$");
                        attributeInput = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        attributeInput = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: view <attribute name>");
                        break;
                    }
                    if (this.attributeDataHTML(this.currentNode, attributeInput) != -1) continue block46;
                    System.out.println("invalid input");
                    break;
                }
                case "algoDebug": 
                case "a": {
                    String attributeName = "";
                    if (userInputList.length == 1) {
                        List<String> attributeList = Debug.allAttributesList(this.currentNode);
                        String[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
                        System.out.println("Which attribute?");
                        Debug.displayArray(attributeArray);
                        System.out.print(">DEBUGGER-PROMPT$");
                        attributeName = inp.nextLine();
                    } else if (userInputList.length == 2) {
                        attributeName = userInputList[1];
                    } else {
                        System.out.println("invalid, correct usage: view <node #>");
                        break;
                    }
                    this.algorithmicDebug(this.currentNode, attributeName, inp);
                    break;
                }
                case "help": {
                    if (userInputList.length != 2) {
                        System.out.println("call help with one of these keywords to see its functionality:");
                        System.out.println("toggle <feature>");
                        System.out.println("up");
                        System.out.println("down <node>");
                        System.out.println("view <attr>");
                        System.out.println("forwards");
                        System.out.println("backtrack");
                        System.out.println("prod");
                        System.out.println("eq");
                        System.out.println("update");
                        System.out.println("exit");
                        break;
                    }
                    if (userInputList.length != 2) continue block46;
                    if (userInputList[1].equals("up")) {
                        System.out.println("The current node changes to its the parent");
                        break;
                    }
                    if (userInputList[1].equals("down")) {
                        System.out.println("The current node changes to its child");
                        System.out.println("One optional input is the child number you want to travel to");
                        System.out.println("If no input is provided you will be prompted with a choice of child");
                        System.out.println("You cn call this function with \"d\"");
                        break;
                    }
                    if (userInputList[1].equals("view")) {
                        System.out.println("look at the value of an attribute in the current node");
                        System.out.println("One optional input is the attribute number you want to view");
                        System.out.println("If no input is provided you will be prompted with a choice of attribute");
                        System.out.println("You can call this function with \"v\"");
                        break;
                    }
                    if (userInputList[1].equals("forwards")) {
                        System.out.println("The current node changes to its forward");
                        break;
                    }
                    if (userInputList[1].equals("backtrack")) {
                        System.out.println("The current node changes to its backtrack");
                        break;
                    }
                    if (userInputList[1].equals("prod")) {
                        System.out.println("prints the production of the current node");
                        break;
                    }
                    if (userInputList[1].equals("eq")) {
                        System.out.println("prints the equation of the current node");
                        break;
                    }
                    if (userInputList[1].equals("update")) {
                        System.out.println("prints the attributes of the current node");
                        break;
                    }
                    if (userInputList[1].equals("local")) {
                        System.out.println("prints the local attributes of the current node");
                        break;
                    }
                    if (userInputList[1].equals("into")) {
                        System.out.println("The current node changes to its higer order attribute");
                        System.out.println("One optional input is the attribute number you want to go into");
                        System.out.println("If no input is provided you will be prompted with a choice of attribute");
                        break;
                    }
                    if (userInputList[1].equals("toggle")) {
                        System.out.println("Activate or disactivate a feature");
                        System.out.println("One input is the feature number you want to toggle");
                        System.out.println("If no input is provided you will be prompted with a choice of toggles");
                        break;
                    }
                    System.out.println("try just calling help");
                    break;
                }
                case "exit": 
                case "q": 
                case "quit": {
                    System.out.println("debugger out");
                    break block46;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                }
            }
        }
    }

    private boolean isRoot(DecoratedNode dn) {
        return dn.getParent() == null || dn.getParent() instanceof TopNode || dn.getParent().getParent() == null || dn.getParent().getParent() instanceof TopNode;
    }

    public Integer up() {
        if (this.isRoot(this.currentNode)) {
            System.out.println("Root Node has no parent");
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = this.currentNode.getParent();
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public void updateDisplay() {
        block23: {
            try {
                List<String> attributeList = Debug.allAttributesList(this.currentNode);
                Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(this.currentNode);
                Lazy attributeLazy = lazyMap.get(attributeList.get(0));
                NLocation loc = attributeLazy.getSourceLocation();
                if (loc == null) break block23;
                String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
                int attributeLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
                int currentLineNumber = 1;
                int productionLineNum = 0;
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains("::=")) {
                            productionLineNum = currentLineNumber;
                        }
                        if (currentLineNumber >= attributeLine) break;
                        ++currentLineNumber;
                    }
                    this.writeToJson(file, productionLineNum, productionLineNum);
                    this.sendMessageToExtension("1");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (NullPointerException e) {
                System.out.println("Failed to update json");
            }
        }
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(this.currentNode);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("attribute_values.html"));){
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            writer.write("<pre>\n");
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Thunk) {
                    writer.write(key + ": THUNKING...");
                } else {
                    writer.write(key + ": " + Util.genericShow(value));
                }
                writer.newLine();
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            System.err.println("Error writing to file: " + e.getMessage());
        }
        if (this.toggleNameDisplay) {
            this.printName(this.currentNode);
        }
        if (this.toggleCStackDisplay) {
            this.cStack.show();
        }
    }

    public Integer down(String childName) {
        String[] childProductions;
        String currentProduction = this.currentNode.undecorate().getProdleton().getTypeUnparse();
        String[] listCurrentProduction = currentProduction.split("\\s+");
        Object[] childNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
        int childNum = Arrays.binarySearch(childNames, childName);
        if (childNum < 0) {
            childNum = this.prefixSearch((String[])childNames, childName);
        }
        if ((childProductions = this.currentNode.undecorate().getProdleton().getChildTypes())[childNum].equals("null")) {
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = this.currentNode.childDecorated(childNum);
        this.cStack.push(this.currentNode);
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer prefixSearch(String[] array, String prefix) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].startsWith(prefix)) continue;
            return i;
        }
        return -1;
    }

    public Integer undo() {
        DecoratedNode newNode;
        if (this.nodeStack.empty()) {
            System.out.println("invalid no node to undo");
            return -1;
        }
        this.currentNode = newNode = this.nodeStack.pop();
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer forwards() {
        if (this.isContractum(this.currentNode)) {
            this.nodeStack.push(this.currentNode);
            this.currentNode = this.currentNode.forward();
            this.cStack.push(this.currentNode);
            this.sStack.generateHTMLFile();
            return 1;
        }
        System.out.println("invalid no node to forward");
        return -1;
    }

    public Integer backtrack() {
        DecoratedNode nextNode = this.currentNode.getForwardParent();
        if (nextNode == null) {
            System.out.println("invalid no node to backtrack to");
            return -1;
        }
        this.nodeStack.push(this.currentNode);
        this.currentNode = nextNode;
        this.cStack.pop();
        this.sStack.generateHTMLFile();
        return 1;
    }

    public Integer toggle(String toggleInput) {
        String toggleChoice = "";
        if (Arrays.asList(this.toggleChoices).contains(toggleInput)) {
            toggleChoice = toggleInput;
        } else {
            int toggleNum = this.prefixSearch(this.toggleChoices, toggleInput);
            if (toggleNum > -1) {
                toggleChoice = this.toggleChoices[toggleNum];
            } else {
                System.out.println("No such toggle");
                return -1;
            }
        }
        if (toggleChoice.equals("nameDisplay")) {
            if (this.toggleNameDisplay) {
                System.out.println("Production Display off");
                this.toggleNameDisplay = false;
            } else {
                System.out.println("Production Display on");
                this.toggleNameDisplay = true;
            }
        } else if (toggleChoice.equals("fullAttributeNames")) {
            if (this.toggleHeadlessAttributes) {
                System.out.println("Headless Attributes off");
                this.toggleHeadlessAttributes = false;
            } else {
                System.out.println("Headless Attributes on");
                this.toggleHeadlessAttributes = true;
            }
        } else if (toggleChoice.equals("cStackDisplay")) {
            if (this.toggleCStackDisplay) {
                System.out.println("cStack Display off");
                this.toggleCStackDisplay = false;
            } else {
                System.out.println("cStack Display on");
                this.toggleCStackDisplay = true;
            }
        } else {
            System.out.println("legal toggles: nameDisplay, fullAttributeNames, cStackDisplay");
        }
        return 1;
    }

    public void printName(DecoratedNode node) {
        String parentProduction = node.undecorate().getProdleton().getTypeUnparse();
        System.out.println(parentProduction);
    }

    public Integer equationHelper(String attributeInput) {
        List<String> attributeList = Debug.allAttributesList(this.currentNode);
        String[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
        String attributeName = this.inputArrayFinder(attributeArray, attributeInput);
        if (attributeName.equals("")) {
            return -1;
        }
        this.displayEquation(this.currentNode, attributeName);
        this.attributeDataHTML(this.currentNode, "");
        return 1;
    }

    public static Integer suffixSearch(String[] array, String suffix) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].endsWith(suffix)) continue;
            return i;
        }
        return -1;
    }

    private void sendMessageToExtension(String message) {
        String host = "127.0.0.1";
        int port = 19387;
        try (Socket socket = new Socket(host, port);
             PrintWriter out = new PrintWriter(socket.getOutputStream(), true);){
            out.println(message);
            System.out.println("Message sent to extension: " + message);
        }
        catch (IOException e) {
            System.err.println("Couldn't connect to the extension server at " + host + ":" + port);
            System.err.println(e.getMessage());
        }
    }

    public void displayEquation(DecoratedNode node, String attributeName) {
        Lazy attributeLazy;
        NLocation loc;
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attributeName) && (loc = (attributeLazy = lazyMap.get(attributeName)).getSourceLocation()) != null) {
            String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int endline = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
            this.writeToJson(file, line, endline);
            this.sendMessageToExtension("1");
        }
    }

    public void writeToJson(String filename, int lineNumber, int endline) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(".debugger_communicator.json"));){
            String currentDirectory = System.getProperty("user.dir");
            int lastIndex = filename.lastIndexOf("/");
            String fileEnd = filename.substring(lastIndex + 1);
            writer.write("{\"file_path\": \"" + currentDirectory + "/" + fileEnd + "\", \"line_begin\": " + lineNumber + ", \"line_end\": " + endline + "}");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public Integer attributeDataHTML(DecoratedNode node, String attributeName) {
        List<String> attributeList = Debug.allAttributesList(this.currentNode);
        String[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
        String highlightAttribute = this.inputArrayFinder(attributeArray, attributeName);
        if (attributeName.equals("")) {
            return -1;
        }
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter("attribute_values.html"));){
            writer.write("<!DOCTYPE html>\n");
            writer.write("<html>\n");
            writer.write("<body>\n");
            writer.write("<pre>\n");
            for (Map.Entry<String, Object> entry : attributeMap.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals(highlightAttribute)) {
                    writer.write("<mark>");
                    writer.write(key + ": " + Util.genericShow(Util.demand(value)));
                    writer.write("</mark>");
                } else if (value instanceof Thunk) {
                    writer.write(key + ": THUNKING...");
                } else {
                    writer.write(key + ": " + Util.genericShow(value));
                }
                writer.newLine();
            }
            writer.write("</pre>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
        }
        catch (IOException e) {
            System.err.println("Error writing to file: " + e.getMessage());
        }
        return 0;
    }

    public String inputArrayFinder(String[] array, String input) {
        int index = Arrays.binarySearch(array, input);
        String returnString = "";
        if (index < 0) {
            index = this.prefixSearch(array, input);
        }
        if (index < 0) {
            index = Debug.suffixSearch(array, ":" + input);
        }
        if (index < 0) {
            return "";
        }
        return array[index];
    }

    public int algorithmicDebug(DecoratedNode node, String attributeInput, Scanner inp) {
        Lazy attributeLazy;
        NLocation loc;
        List<String> attributeList = Debug.allAttributesList(this.currentNode);
        String[] attributeArray = attributeList.toArray(new String[attributeList.size()]);
        String attributeName = this.inputArrayFinder(attributeArray, attributeInput);
        if (attributeName.equals("")) {
            System.out.print("invalid input");
            return -1;
        }
        String equationString = "";
        Map<String, Lazy> lazyMap = Debug.allAttributesLazyMap(node);
        if (lazyMap.containsKey(attributeName) && (loc = (attributeLazy = lazyMap.get(attributeName)).getSourceLocation()) != null) {
            String filePath = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int startLine = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int endLine = (Integer)loc.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
            System.out.println("Equation:");
            try {
                equationString = Debug.getLines(filePath, startLine, endLine);
                System.out.println();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Data:");
        Map<String, Object> attributeMap = Debug.allAttributesThunkMap(node);
        String partentProduction = node.undecorate().getProdleton().getTypeUnparse();
        int index1 = partentProduction.indexOf("::");
        int index2 = attributeName.indexOf(":");
        String parentNameInEquation = partentProduction.substring(0, index1) + "." + attributeName.substring(index2 + 1);
        System.out.println(parentNameInEquation + ": " + Util.genericShow(Util.demand(attributeMap.get(attributeName))));
        String currentProduction = node.undecorate().getProdleton().getTypeUnparse();
        String[] listCurrentProduction = currentProduction.split("\\s+");
        String[] childFullNames = Arrays.copyOfRange(listCurrentProduction, 2, listCurrentProduction.length);
        String[] childFrontNames = new String[childFullNames.length];
        String[] childBackNames = new String[childFullNames.length];
        for (int i = 0; i < childFullNames.length; ++i) {
            index1 = childFullNames[i].indexOf("::");
            childFrontNames[i] = childFullNames[i].substring(0, index1) + ".";
            index2 = childFullNames[i].indexOf(":");
            childBackNames[i] = childFullNames[i].substring(index2 + 2);
        }
        ArrayList<String> dependentAttributes = new ArrayList<String>();
        String[] equationComponents = equationString.split("\\s+");
        block3: for (String component : equationComponents) {
            for (String childFront : childFrontNames) {
                if (!component.startsWith(childFront)) continue;
                dependentAttributes.add(component);
                continue block3;
            }
        }
        for (String attribute : dependentAttributes) {
            String[] attributeComponents = attribute.split("\\.");
            String childName = "";
            for (int i = 0; i < childFullNames.length; ++i) {
                if (!childFullNames[i].startsWith(attributeComponents[0] + "::")) continue;
                DecoratedNode childNode = this.currentNode.childDecorated(i);
                Map<String, Object> childMap = Debug.allAttributesThunkMap(childNode);
                for (Map.Entry<String, Object> entry : childMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!key.endsWith(":" + attributeComponents[1])) continue;
                    System.out.println(attribute + ": " + Util.genericShow(Util.demand(value)));
                }
            }
        }
        String[] dependentAttributesArray = dependentAttributes.toArray(new String[0]);
        int inputInt = -1;
        String chosenAttributeInput = "";
        if (dependentAttributesArray.length <= 0) {
            return 0;
        }
        System.out.println();
        System.out.println("Pick the next node to investigate");
        Debug.displayArray(dependentAttributesArray);
        System.out.print(">DEBUGGER-PROMPT$");
        chosenAttributeInput = inp.nextLine();
        String chosenAttribute = this.inputArrayFinder(dependentAttributesArray, chosenAttributeInput);
        if (chosenAttribute.equals("")) {
            System.out.print("invalid input");
            return -1;
        }
        String[] chosenAttributeComponents = chosenAttribute.split("\\.");
        String nextChildName = "";
        for (String fullName : childFullNames) {
            if (!fullName.startsWith(chosenAttributeComponents[0] + "::")) continue;
            nextChildName = fullName;
        }
        System.out.println(nextChildName);
        if (this.down(nextChildName) == -1) {
            System.out.println("invalid child");
        }
        String nextAttributeName = "";
        for (String element : attributeList) {
            String[] parts = element.split(":");
            if (parts.length != 2 || !chosenAttributeComponents[1].startsWith(parts[1])) continue;
            nextAttributeName = element;
        }
        System.out.println(nextAttributeName);
        if (nextChildName != "") {
            this.algorithmicDebug(this.currentNode, nextAttributeName, inp);
        }
        return -1;
    }

    public static String getLines(String filePath, int startLine, int endLine) throws IOException {
        String returnString = "";
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            int currentLine;
            for (currentLine = 1; (line = reader.readLine()) != null && currentLine < startLine; ++currentLine) {
            }
            while (line != null && currentLine <= endLine) {
                System.out.println(line);
                returnString = returnString + line;
                line = reader.readLine();
                ++currentLine;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return returnString;
    }

    public static List<String> getLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.getLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesThunkMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Object o;
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                o = node.contextSynthesizedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                o = node.contextInheritedLazy(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Object o2 = node.localLazy(index2);
            attributeMap.put(attribute, o2);
        }
        return attributeMap;
    }

    public static Map<String, Lazy> allAttributesLazyMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Lazy> attributeMap = new HashMap<String, Lazy>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                attributeMap.put(attribute, synthAttribute);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Lazy inheritedAttribute = node.getInheritedAttribute(index);
                attributeMap.put(attribute, inheritedAttribute);
                continue;
            }
            List<String> listLocals = Debug.getLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            attributeMap.put(attribute, localAttribute);
        }
        return attributeMap;
    }

    public static void displayArray(String[] array) {
        for (String element : array) {
            System.out.println(element);
        }
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }
}

