/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.LexicalAmbiguityMessage;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.LexicalAmbiguities;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;

public class LexicalAmbiguityChecker {
    private CompilerLogger logger;
    private SymbolTable<CopperASTBean> symbolTable;
    private LexicalAmbiguities ambiguities;
    private GrammarStatistics stats;

    private LexicalAmbiguityChecker(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, LexicalAmbiguities ambiguities, GrammarStatistics stats) {
        this.logger = logger;
        this.symbolTable = symbolTable;
        this.ambiguities = ambiguities;
        this.stats = stats;
    }

    public static boolean check(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, LexicalAmbiguities ambiguities, GrammarStatistics stats) {
        return new LexicalAmbiguityChecker(logger, symbolTable, ambiguities, stats).checkLexicalAmbiguities();
    }

    private boolean checkLexicalAmbiguities() {
        boolean passed = true;
        this.stats.lexicalAmbiguityCount = this.ambiguities.size();
        for (int i = 0; i < this.ambiguities.size(); ++i) {
            boolean logConflict;
            if (this.ambiguities.isUnresolved(i)) {
                passed = false;
                logConflict = this.logger.isLoggable(CompilerLevel.QUIET);
            } else {
                logConflict = this.logger.isLoggable(CompilerLevel.VERBOSE);
            }
            if (logConflict) {
                this.logger.log(new LexicalAmbiguityMessage(this.symbolTable, this.ambiguities, i));
            }
            if (this.ambiguities.isUnresolved(i)) {
                passed = false;
                continue;
            }
            if (this.ambiguities.getResolution(i) == -1) {
                ++this.stats.contextResolvedLexicalAmbiguityCount;
                continue;
            }
            ++this.stats.disambiguationFunctionResolvedLexicalAmbiguityCount;
        }
        return passed;
    }
}

