/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.runtime.io;

import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import edu.umn.cs.melt.copper.runtime.io.internal.CircleBuffer;
import java.io.IOException;
import java.io.Reader;

class QScannerBuffer
extends ScannerBuffer {
    private Reader reader;
    private CircleBuffer buffer;
    private long bufferBegin;
    private long bufferEnd;

    protected QScannerBuffer(Reader reader) {
        this.reader = reader;
        this.buffer = new CircleBuffer();
        this.bufferBegin = 0L;
        this.bufferEnd = 0L;
    }

    private char readChar() throws IOException {
        int charRead = this.reader.read();
        if (charRead == -1) {
            return EOFIndicator;
        }
        return (char)charRead;
    }

    private void addChar() throws IOException {
        if (this.buffer.isEmpty() || this.buffer.get(this.buffer.size() - 1) != EOFIndicator) {
            char charRead = this.readChar();
            this.buffer.offer(charRead);
            ++this.bufferEnd;
        }
    }

    @Override
    public char charAt(long pos) throws IOException {
        if (pos < this.bufferBegin) {
            throw new IOException("Buffer has passed position " + pos);
        }
        if (pos >= this.bufferEnd) {
            this.readUpTo(pos);
        }
        if (pos >= this.bufferEnd) {
            return EOFIndicator;
        }
        return this.buffer.get((int)(pos - this.bufferBegin));
    }

    @Override
    public void advanceBufferTo(long newBufferBegin) {
        if (this.bufferBegin < newBufferBegin && newBufferBegin - this.bufferBegin <= (long)this.buffer.size()) {
            this.buffer.poll((int)(newBufferBegin - this.bufferBegin));
            this.bufferBegin = newBufferBegin;
        }
    }

    private void readUpTo(long newBufferEnd) throws IOException {
        while (this.bufferEnd <= newBufferEnd) {
            this.addChar();
        }
    }

    @Override
    public String readStringFromBuffer(long begin, long end) throws IOException {
        if (begin < this.bufferBegin || end > this.bufferEnd) {
            return null;
        }
        char[] arrayRep = new char[(int)(end - begin)];
        for (long pos = begin; pos < end; ++pos) {
            arrayRep[(int)(pos - begin)] = this.charAt(pos);
        }
        return new String(arrayRep);
    }
}

