/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import java.util.HashSet;
import java.util.Set;

public class CharacterSetRegex
extends Regex {
    private static final long serialVersionUID = -966161834565953355L;
    private SetOfCharsSyntax chars = new SetOfCharsSyntax();

    public static CharacterSetRegex union(CharacterSetRegex left, CharacterSetRegex right) {
        CharacterSetRegex rv = new CharacterSetRegex();
        rv.chars = SetOfCharsSyntax.union(left.chars, right.chars);
        return rv;
    }

    public char getOnlyChar() {
        if (this.cardinality() == 1) {
            return this.chars.getMembers()[0][0];
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public CharacterSetRegex addRange(char lowerBound, char upperBound) throws IllegalArgumentException {
        SetOfCharsSyntax rhs = new SetOfCharsSyntax(lowerBound, upperBound);
        if (rhs.size() == 0) {
            throw new IllegalArgumentException(PrettyPrinter.charPrettyPrint(lowerBound) + "-" + PrettyPrinter.charPrettyPrint(upperBound) + " is an invalid character range");
        }
        this.chars = SetOfCharsSyntax.union(this.chars, rhs);
        return this;
    }

    public CharacterSetRegex addLooseChar(char c) {
        SetOfCharsSyntax rhs = new SetOfCharsSyntax(c, c);
        this.chars = SetOfCharsSyntax.union(this.chars, rhs);
        return this;
    }

    public CharacterSetRegex invert() {
        this.chars = this.chars.invert();
        return this;
    }

    @Override
    public boolean isComplete() {
        return !this.chars.isEmpty();
    }

    public int cardinality() {
        return this.chars.size();
    }

    @Override
    public Set<String> whatIsMissing() {
        HashSet<String> rv = new HashSet<String>();
        if (this.chars.isEmpty()) {
            rv.add("characters");
        }
        return rv;
    }

    @Override
    public <RT, E extends Exception> RT acceptVisitor(RegexBeanVisitor<RT, E> visitor) throws E {
        return visitor.visitCharacterSetRegex(this, this.chars);
    }
}

