/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;

public class LR0DFABuilder {
    private ParserSpec spec;
    private int transitionArraySize;
    private Hashtable<LR0ItemSet, Integer> memoizedClosures = new Hashtable();
    private ArrayList<LR0ItemSet> itemSets = new ArrayList();
    private ArrayList<BitSet> transitionLabels = new ArrayList();
    private ArrayList<int[]> transitions = new ArrayList();
    private ArrayList<BitSet[]> gotoItems = new ArrayList();
    private BitSet closureProductions = new BitSet();
    private BitSet closure_newItems0 = new BitSet();
    private BitSet closure_newItems1 = new BitSet();

    private LR0DFABuilder(ParserSpec spec) {
        this.spec = spec;
        this.transitionArraySize = Math.max(spec.terminals.length(), spec.nonterminals.length());
    }

    public static LR0DFA build(ParserSpec spec) {
        return new LR0DFABuilder(spec).buildDFA();
    }

    private LR0DFA buildDFA() {
        this.itemSets.add(new LR0ItemSet(new int[0]));
        this.transitionLabels.add(new BitSet());
        this.transitions.add(new int[this.transitionArraySize]);
        this.gotoItems.add(new BitSet[this.transitionArraySize]);
        BitSet fringe1 = new BitSet();
        BitSet fringe2 = new BitSet();
        int[] primeSeedItems = new int[]{this.spec.getStartProduction(), 0};
        int J = this.closure(new LR0ItemSet(primeSeedItems));
        fringe1.set(J);
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int i = fringe1.nextSetBit(0);
            while (i >= 0) {
                this.calculateGotos(i, fringe2);
                i = fringe1.nextSetBit(i + 1);
            }
            if (fringe2.isEmpty()) continue;
            fringe1.clear();
            fringe1.or(fringe2);
            fringe2.clear();
            setsChanged = true;
        }
        BitSet[] initNTs = new BitSet[this.itemSets.size()];
        for (int i = 0; i < this.itemSets.size(); ++i) {
            LR0ItemSet itemSet = this.itemSets.get(i);
            initNTs[i] = new BitSet();
            for (int j = 0; j < itemSet.size(); ++j) {
                int production;
                int position = itemSet.getPosition(j);
                if (position >= this.spec.pr.getRHSLength(production = itemSet.getProduction(j))) continue;
                initNTs[i].set(this.spec.pr.getRHSSym(production, position));
            }
        }
        LR0ItemSet[] statesA = new LR0ItemSet[this.itemSets.size()];
        this.itemSets.toArray(statesA);
        BitSet[] transitionLabelsA = new BitSet[this.transitionLabels.size()];
        this.transitionLabels.toArray(transitionLabelsA);
        int[][] transitionsA = new int[this.transitions.size()][this.transitionArraySize];
        this.transitions.toArray((T[])transitionsA);
        BitSet[][] gotoItemsA = new BitSet[this.gotoItems.size()][this.transitionArraySize];
        this.gotoItems.toArray((T[])gotoItemsA);
        return new LR0DFA(statesA, transitionLabelsA, transitionsA, gotoItemsA, initNTs);
    }

    public int closure(LR0ItemSet seed) {
        if (this.memoizedClosures.containsKey(seed)) {
            return this.memoizedClosures.get(seed);
        }
        this.closureProductions.clear();
        this.closure_newItems0.clear();
        this.closure_newItems1.clear();
        for (int i = 0; i < seed.size(); ++i) {
            int sym;
            if (seed.getPosition(i) >= this.spec.pr.getRHSLength(seed.getProduction(i)) || !this.spec.nonterminals.get(sym = this.spec.pr.getRHSSym(seed.getProduction(i), seed.getPosition(i)))) continue;
            this.closure_newItems1.or(this.spec.nt.getProductions(sym));
        }
        this.closureProductions.or(this.closure_newItems1);
        boolean iChanged = true;
        while (iChanged) {
            iChanged = false;
            this.closure_newItems0.clear();
            this.closure_newItems0.or(this.closure_newItems1);
            this.closure_newItems1.clear();
            int p = this.closure_newItems0.nextSetBit(0);
            while (p >= 0) {
                if (this.spec.pr.getRHSLength(p) > 0 && this.spec.nonterminals.get(this.spec.pr.getRHSSym(p, 0))) {
                    this.closure_newItems1.or(this.spec.nt.getProductions(this.spec.pr.getRHSSym(p, 0)));
                }
                iChanged |= ParserSpec.union(this.closureProductions, this.closure_newItems1);
                p = this.closure_newItems0.nextSetBit(p + 1);
            }
        }
        int[] newItems = new int[2 * (seed.size() + this.closureProductions.cardinality())];
        seed.copyItems(newItems);
        int i = seed.size();
        int p = this.closureProductions.nextSetBit(0);
        while (p >= 0) {
            newItems[2 * i++] = p;
            p = this.closureProductions.nextSetBit(p + 1);
        }
        LR0ItemSet newClosure = new LR0ItemSet(newItems);
        this.itemSets.add(newClosure);
        this.transitionLabels.add(new BitSet());
        this.transitions.add(new int[this.transitionArraySize]);
        this.gotoItems.add(new BitSet[this.transitionArraySize]);
        this.memoizedClosures.put(seed, this.itemSets.size() - 1);
        this.memoizedClosures.put(newClosure, this.itemSets.size() - 1);
        return this.itemSets.size() - 1;
    }

    public void calculateGotos(int state, BitSet gotos) {
        int startingSize = this.itemSets.size();
        LR0ItemSet I = this.itemSets.get(state);
        for (int i = 0; i < I.size(); ++i) {
            int X;
            if (I.getPosition(i) >= this.spec.pr.getRHSLength(I.getProduction(i)) || (X = this.spec.pr.getRHSSym(I.getProduction(i), I.getPosition(i))) == this.spec.getEOFTerminal()) continue;
            if (!this.transitionLabels.get(state).get(X)) {
                this.gotoItems.get((int)state)[X] = new BitSet();
            }
            this.transitionLabels.get(state).set(X);
            this.gotoItems.get(state)[X].set(i);
        }
        int X = this.transitionLabels.get(state).nextSetBit(0);
        while (X >= 0) {
            int J;
            int[] jItems = new int[2 * this.gotoItems.get(state)[X].cardinality()];
            int i = 0;
            int item = this.gotoItems.get(state)[X].nextSetBit(0);
            while (item >= 0) {
                jItems[2 * i] = I.getProduction(item);
                jItems[2 * i + 1] = I.getPosition(item) + 1;
                ++i;
                item = this.gotoItems.get(state)[X].nextSetBit(item + 1);
            }
            this.transitions.get((int)state)[X] = J = this.closure(new LR0ItemSet(jItems));
            if (J == this.itemSets.size() - 1 && this.itemSets.size() > startingSize) {
                gotos.set(J);
            }
            X = this.transitionLabels.get(state).nextSetBit(X + 1);
        }
    }
}

