/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.GrammarConsistencyChecker;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.GrammarError;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.GrammarNormalizer;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.GrammarSemanticErrorMessage;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;

public class ParserSpecProcessor {
    public static boolean normalizeParser(ParserBean spec, CompilerLogger logger) throws CopperException {
        boolean hasError = false;
        GrammarConsistencyChecker checker = new GrammarConsistencyChecker();
        hasError = spec != null ? (hasError |= spec.acceptVisitor(checker).booleanValue()) : true;
        if (hasError && logger.isLoggable(GrammarSemanticErrorMessage.getGrammarSemanticErrorMessageLevel())) {
            for (GrammarError e : checker.getErrors()) {
                logger.log(new GrammarSemanticErrorMessage(e));
            }
            logger.flush();
            return true;
        }
        GrammarNormalizer normalizer = new GrammarNormalizer();
        if (spec != null) {
            spec.acceptVisitor(normalizer);
        }
        return hasError;
    }
}

