/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.ParseEngine;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.ParserState;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScanner;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatchData;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.AcceptAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.FullReduceAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseActionVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ShiftAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTree;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeNode;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetree.plain.ParseTreeProdNode;
import edu.umn.cs.melt.copper.legacy.compiletime.statistics.ParserStatistics;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.engines.semantics.SpecialParserAttributes;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public abstract class LALREngine
extends ParseEngine
implements ParseActionVisitor<Boolean, CopperException> {
    protected Stack<Pair<ParserState, Object>> parseStack;
    protected VirtualLocation virtualLocation;
    protected int startStatenum;
    protected QScanner scanner;
    protected CompilerLogger logger;
    private ParserState currentState;
    private ParserStatistics statistics;
    private boolean gatherStatistics;
    private QScannerMatchData lookahead;
    private ParseAction action;
    private ParseTree parseTree;
    private boolean accepted;

    public abstract Object runSemanticAction(InputPosition var1, Object[] var2, Production var3) throws IOException, CopperException;

    public abstract Object runSemanticAction(InputPosition var1, QScannerMatchData var2) throws IOException, CopperException;

    public abstract QScannerMatchData runDisambiguationAction(InputPosition var1, HashSet<QScannerMatchData> var2) throws IOException, CopperException;

    public abstract SpecialParserAttributes getSpecialAttributes();

    @Override
    public void setupEngine() {
    }

    public void startStatisticGathering() {
        this.statistics = new ParserStatistics(this.scanner.retrieveStatistics());
        this.statistics.totalParserStates = 0;
        for (int statenum = 0; statenum <= this.getParseTable().getLastState(); ++statenum) {
            this.statistics.totalParserStates = Math.max(statenum, this.statistics.totalParserStates);
        }
        this.gatherStatistics = true;
    }

    @Override
    public void startEngine(InputPosition initialPos) throws IOException, CopperException {
        if (this.logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
            this.startStatisticGathering();
        } else {
            this.statistics = new ParserStatistics(this.scanner.retrieveStatistics());
            this.gatherStatistics = false;
        }
        this.accepted = false;
        this.parseTree = new ParseTree();
        this.parseStack = new Stack();
        this.parseStack.push(Pair.cons(new ParserState(this.startStatenum, initialPos), null));
        this.virtualLocation = new VirtualLocation(initialPos.getFileName(), 1, 0);
    }

    private void reportError(String error) throws CopperException {
        if (this.logger.isLoggable(CompilerLogMessageSort.ERROR)) {
            this.logger.logParsingErrorMessage(this.virtualLocation, this.currentState.getStatenum(), this.currentState.getPos().getPos(), error);
        }
    }

    public ParserStatistics retrieveStatistics() {
        return this.statistics;
    }

    @Override
    public Object runEngine() throws IOException, CopperException {
        do {
            this.currentState = this.parseStack.peek().first();
            if (this.gatherStatistics) {
                if (!this.statistics.parserStatesVisited.containsKey(this.currentState.getStatenum())) {
                    this.statistics.parserStatesVisited.put(this.currentState.getStatenum(), 0);
                }
                this.statistics.parserStatesVisited.put(this.currentState.getStatenum(), this.statistics.parserStatesVisited.get(this.currentState.getStatenum()) + 1);
            }
            if (!this.getParseTable().hasShiftable(this.currentState.getStatenum())) {
                if (this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) {
                    this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, null, "No actions whatsoever listed for state " + this.currentState);
                }
                return null;
            }
            HashSet<QScannerMatchData> possibleShifts = this.scanner.runLayoutScan(this.currentState, this.getParseTable());
            if (possibleShifts.size() == 0) {
                String errorString = "Expected a token of one of the following types:\n";
                Collection<Terminal> shiftable = this.getParseTable().getShiftable(this.currentState.getStatenum());
                errorString = errorString + PrettyPrinter.iterablePrettyPrint(shiftable, "   ", 1);
                errorString = errorString + "\n  Input currently matches:\n";
                HashSet<QScannerMatchData> universalMatches = this.scanner.runDisjointScan(this.currentState, this.getParseTable());
                HashSet<Terminal> universalMatchesS = new HashSet<Terminal>();
                for (QScannerMatchData match : universalMatches) {
                    universalMatchesS.add(match.getToken());
                }
                errorString = errorString + PrettyPrinter.iterablePrettyPrint(universalMatchesS, "   ", 1);
                this.reportError(errorString);
                return null;
            }
            if (possibleShifts.size() == 1) {
                this.lookahead = possibleShifts.iterator().next();
            } else {
                this.lookahead = this.runDisambiguationAction(this.currentState.getPos(), possibleShifts);
                if (this.lookahead == null) {
                    HashSet<ParseAction> actions = new HashSet<ParseAction>();
                    for (QScannerMatchData data : possibleShifts) {
                        for (ParseAction a : this.getParseTable().getParseActions(this.currentState.getStatenum(), data.getToken())) {
                            actions.add(a);
                            if (actions.size() <= 1) continue;
                            break;
                        }
                        if (actions.size() <= 1) continue;
                        break;
                    }
                    if (actions.size() == 1 && actions.iterator().next() instanceof FullReduceAction) {
                        this.lookahead = possibleShifts.iterator().next();
                    }
                }
                if (this.lookahead == null) {
                    if (this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) {
                        this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, this.currentState.getPos(), "Lexical ambiguity between tokens: " + possibleShifts);
                    }
                    return null;
                }
            }
            if (!this.getParseTable().hasAction(this.currentState.getStatenum(), this.lookahead.getToken())) {
                if (this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) {
                    this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, this.currentState.getPos(), "Unexpected token " + this.lookahead);
                }
                return null;
            }
            this.action = this.getParseTable().getParseAction(this.currentState.getStatenum(), this.lookahead.getToken());
            this.action.acceptVisitor(this);
        } while (!this.accepted);
        if (this.parseStack.peek().second() instanceof ParseTreeNode) {
            return this.parseTree;
        }
        return this.parseStack.peek().second();
    }

    @Override
    public Boolean visitAcceptAction(AcceptAction action) throws CopperException {
        this.accepted = true;
        return true;
    }

    @Override
    public Boolean visitFullReduceAction(FullReduceAction action) throws CopperException {
        if (action.getProd().length() >= this.parseStack.size()) {
            if (this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) {
                this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, this.currentState.getPos(), "Unable to perform reduction: stack too short");
            }
            return false;
        }
        Object[] children = new Object[action.getProd().length()];
        for (int i = action.getProd().length() - 1; i >= 0; --i) {
            children[i] = this.parseStack.pop().second();
        }
        if (!this.getParseTable().hasGotoAction(this.parseStack.peek().first().getStatenum(), action.getProd().getLeft())) {
            if (this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) {
                this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, this.currentState.getPos(), "Unable to perform reduction: no goto action available in parse table cell (" + this.parseStack.peek().first().getStatenum() + "," + action.getProd().getLeft());
            }
            return false;
        }
        ShiftAction gotoAction = this.getParseTable().getGotoAction(this.parseStack.peek().first().getStatenum(), action.getProd().getLeft());
        Object newNode = null;
        try {
            newNode = this.runSemanticAction(this.currentState.getPos(), children, action.getProd());
        }
        catch (IOException ex) {
            this.reportError("I/O error in semantic action: " + ex.getMessage());
        }
        if (newNode != null && newNode.equals("PARSETREE")) {
            ParseTreeNode[] newChildren = new ParseTreeNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                newChildren[i] = (ParseTreeNode)children[i];
            }
            ParseTreeProdNode newNodePTPN = this.parseTree.prodNode(action.getProd(), newChildren);
            newNode = newNodePTPN;
            this.parseTree.setRoot(newNodePTPN);
        }
        this.parseStack.push(Pair.cons(new ParserState(gotoAction.getDestState(), this.currentState.getPos()), newNode));
        return true;
    }

    @Override
    public Boolean visitShiftAction(ShiftAction action) throws CopperException {
        for (QScannerMatchData layout : this.lookahead.getLayouts()) {
            try {
                this.runSemanticAction(layout.getPositionPreceding(), layout);
            }
            catch (IOException ex) {
                this.reportError("I/O error in semantic action: " + ex.getMessage());
            }
            this.virtualLocation.defaultUpdateAutomatic(layout.getToken().getLexeme());
        }
        Object newNode = null;
        try {
            newNode = this.runSemanticAction(this.lookahead.getPositionPreceding(), this.lookahead);
        }
        catch (IOException ex) {
            this.reportError("I/O error in semantic action: " + ex.getMessage());
        }
        Terminal lookaheadTok = this.getSpecialAttributes().latchLocation ? this.lookahead.getToken().newLexeme("") : this.lookahead.getToken();
        InputPosition positionPreceding = this.currentState.getPos();
        InputPosition positionFollowing = this.getSpecialAttributes().latchLocation ? InputPosition.copy(this.currentState.getPos()) : this.lookahead.getPositionFollowing();
        this.virtualLocation.defaultUpdateAutomatic(lookaheadTok.getLexeme());
        if (newNode != null && newNode.equals("PARSETREE")) {
            newNode = this.parseTree.termNode(lookaheadTok, positionPreceding, new VirtualLocation(this.virtualLocation));
            this.parseTree.setRoot((ParseTreeNode)newNode);
        }
        this.parseStack.push(Pair.cons(new ParserState(action.getDestState(), positionFollowing), newNode));
        return true;
    }
}

