/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.CounterexampleMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.ParseTableConflictMessage;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ParseTableConflictChecker {
    private LRLookaheadSets lookaheadSets;
    private CompilerLogger logger;
    private PSSymbolTable symbolTable;
    private ParserSpec spec;
    private LRParseTable parseTable;
    private GrammarStatistics stats;
    private LR0DFA dfa;
    private ContextSets contextSets;
    private File dotOut;
    private boolean colorExample;

    public static boolean check(CompilerLogger logger, File dotOut, PSSymbolTable symbolTable, ParserSpec spec, LRParseTable parseTable, LR0DFA dfa, ContextSets contextSets, LRLookaheadSets lookaheadSets, GrammarStatistics stats, boolean colorExample) {
        return new ParseTableConflictChecker(logger, dotOut, symbolTable, spec, parseTable, dfa, contextSets, lookaheadSets, stats, colorExample).checkConflicts();
    }

    private ParseTableConflictChecker(CompilerLogger logger, File dotOut, PSSymbolTable symbolTable, ParserSpec spec, LRParseTable parseTable, LR0DFA dfa, ContextSets contextSets, LRLookaheadSets lookaheadSets, GrammarStatistics stats, boolean colorExample) {
        this.logger = logger;
        this.dotOut = dotOut;
        this.symbolTable = symbolTable;
        this.spec = spec;
        this.parseTable = parseTable;
        this.stats = stats;
        this.dfa = dfa;
        this.contextSets = contextSets;
        this.lookaheadSets = lookaheadSets;
        this.colorExample = colorExample;
    }

    private boolean checkConflicts() {
        boolean passed = true;
        LRParseTableConflict firstUnresolvedConflict = null;
        this.stats.parseTableConflictCount = this.parseTable.getConflictCount();
        this.stats.shiftReduceParseTableConflictCount = 0;
        this.stats.reduceReduceParseTableConflictCount = 0;
        this.stats.unresolvedParseTableConflictCount = 0;
        for (int i = 0; i < this.parseTable.getConflictCount(); ++i) {
            boolean logConflict = this.logger.isLoggable(CompilerLevel.VERBOSE);
            LRParseTableConflict conflict = this.parseTable.getConflict(i);
            if (conflict.shift != -1) {
                ++this.stats.shiftReduceParseTableConflictCount;
            }
            if (conflict.reduce.cardinality() > 1) {
                ++this.stats.reduceReduceParseTableConflictCount;
            }
            if (this.parseTable.getActionType(conflict.getState(), conflict.getSymbol()) == 3) {
                ++this.stats.unresolvedParseTableConflictCount;
                logConflict = this.logger.isLoggable(CompilerLevel.QUIET);
                passed = false;
                if (firstUnresolvedConflict == null) {
                    firstUnresolvedConflict = conflict;
                }
            }
            if (!logConflict) continue;
            this.logger.log(new ParseTableConflictMessage(this.symbolTable, this.spec, this.parseTable, conflict));
        }
        if (firstUnresolvedConflict != null) {
            CounterexampleMessage counterexample = new CounterexampleMessage(this.symbolTable, this.dfa, firstUnresolvedConflict, this.contextSets, this.spec, this.lookaheadSets, this.colorExample);
            this.logger.log(counterexample);
            if (this.dotOut != null) {
                try {
                    FileWriter writer = new FileWriter(this.dotOut, false);
                    writer.write(counterexample.toDot());
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.log(new GenericMessage(CompilerLevel.QUIET, "Failed to write dot mark-up representation of counterexample due to IOException " + e));
                }
            }
        }
        return passed;
    }
}

