/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.NodeFactory;
import common.OriginContext;
import common.exceptions.SilverError;
import java.util.Random;
import java.util.function.Function;
import silver.core.NRandomGen;
import silver.core.PapRandomGen;
import silver.core.PbindRandomGen;
import silver.core.PmapRandomGen;
import silver.core.Ppair;
import silver.core.PpureRandomGen;
import silver.core.PrandomBoolean;
import silver.core.PrandomFloat;
import silver.core.PrandomInteger;
import silver.core.PrandomRangeInteger;
import silver.core.PrandomToken_;

public final class RandomGen {
    public static Object runRandomGen(OriginContext ctx, int seed, NRandomGen r) {
        return RandomGen.runRandomGen(ctx, new Random(seed), r);
    }

    public static Object runRandomGen(OriginContext ctx, NRandomGen r) {
        return RandomGen.runRandomGen(ctx, new Random(), r);
    }

    public static Object runRandomGen(OriginContext ctx, Random rng, NRandomGen r) {
        if (r instanceof PmapRandomGen) {
            Object val = RandomGen.runRandomGen(ctx, rng, (NRandomGen)r.getChild(1));
            return ((NodeFactory)r.getChild(0)).invoke(ctx, new Object[]{val}, null);
        }
        if (r instanceof PapRandomGen) {
            NodeFactory fn = (NodeFactory)RandomGen.runRandomGen(ctx, rng, (NRandomGen)r.getChild(0));
            Object val = RandomGen.runRandomGen(ctx, rng, (NRandomGen)r.getChild(1));
            return fn.invoke(ctx, new Object[]{val}, null);
        }
        if (r instanceof PpureRandomGen) {
            return r.getChild(0);
        }
        if (r instanceof PbindRandomGen) {
            Object val = RandomGen.runRandomGen(ctx, rng, (NRandomGen)r.getChild(0));
            return RandomGen.runRandomGen(ctx, rng, (NRandomGen)((NodeFactory)r.getChild(1)).invoke(ctx, new Object[]{val}, null));
        }
        if (r instanceof PrandomInteger) {
            return rng.nextInt();
        }
        if (r instanceof PrandomRangeInteger) {
            return RandomGen.randomRangeInteger((Integer)r.getChild(0), (Integer)r.getChild(1), rng);
        }
        if (r instanceof PrandomFloat) {
            return Float.valueOf(rng.nextFloat());
        }
        if (r instanceof PrandomBoolean) {
            return rng.nextBoolean();
        }
        if (r instanceof PrandomToken_) {
            return rng.nextLong();
        }
        throw new SilverError("Unsupported RandomGen constructor: " + r.getName());
    }

    public static int randomRangeInteger(int lower, int upper, Random rng) {
        if (lower > upper) {
            throw new SilverError("Empty Integer range [" + lower + ", " + upper + "]");
        }
        return rng.nextInt(upper - lower + 1) + lower;
    }

    public static Ppair evalRandomTokenOp(long token, Function<Random, Object> op) {
        Random rng = new Random(token);
        Object result = op.apply(rng);
        return new Ppair(result, (Object)rng.nextLong());
    }
}

