/*
 * Decompiled with CFR 0.152.
 */
package common.rawlib;

import common.ConsCell;
import common.NodeFactory;
import common.javainterop.ConsCellCollection;
import common.javainterop.SilverComparator;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import silver.core.NPair;
import silver.core.Ppair;

public final class RawGraph {
    public static TreeMap<Object, TreeSet<Object>> empty(NodeFactory<Integer> cmp) {
        return new TreeMap<Object, TreeSet<Object>>(new SilverComparator(cmp));
    }

    public static TreeMap<Object, TreeSet<Object>> add(ConsCell l, TreeMap<Object, TreeSet<Object>> g) {
        if (l.nil()) {
            return g;
        }
        TreeMap ret = (TreeMap)g.clone();
        for (NPair elem : new ConsCellCollection(l)) {
            assert (elem instanceof Ppair);
            Object src = elem.getAnno_silver_core_fst();
            Object dst = elem.getAnno_silver_core_snd();
            TreeSet target = (TreeSet)ret.get(src);
            if (target == null) {
                target = new TreeSet(g.comparator());
                ret.put(src, target);
            } else if (target == g.get(src)) {
                target = (TreeSet)target.clone();
                ret.put(src, target);
            }
            target.add((Object)dst);
        }
        return ret;
    }

    public static TreeSet<Object> edgesFrom(Object key, TreeMap<Object, TreeSet<Object>> g) {
        TreeSet<Object> set = g.get(key);
        if (set == null) {
            return new TreeSet<Object>(g.comparator());
        }
        return set;
    }

    public static boolean contains(NPair p, TreeMap<Object, TreeSet<Object>> g) {
        assert (p instanceof Ppair);
        TreeSet<Object> set = g.get(p.getAnno_silver_core_fst());
        if (set == null) {
            return false;
        }
        return set.contains(p.getAnno_silver_core_snd());
    }

    public static ConsCell toList(TreeMap<Object, TreeSet<Object>> g) {
        ConsCell ret = ConsCell.nil;
        for (Map.Entry<Object, TreeSet<Object>> e : g.entrySet()) {
            Object key = e.getKey();
            for (Object value : e.getValue()) {
                ret = new ConsCell(new Ppair(key, value), ret);
            }
        }
        return ret;
    }

    public static TreeMap<Object, TreeSet<Object>> transitiveClosure(TreeMap<Object, TreeSet<Object>> g) {
        TreeMap ret = (TreeMap)g.clone();
        for (Map.Entry entry : ret.entrySet()) {
            TreeSet set = (TreeSet)((TreeSet)entry.getValue()).clone();
            entry.setValue(set);
            ArrayDeque need = new ArrayDeque(set);
            while (!need.isEmpty()) {
                Object focus = need.pop();
                TreeSet diff = (TreeSet)ret.get(focus);
                if (diff == null) continue;
                diff = (TreeSet)diff.clone();
                diff.removeAll(set);
                need.addAll(diff);
                set.addAll(diff);
            }
        }
        return ret;
    }

    public static TreeMap<Object, TreeSet<Object>> repairClosure(ConsCell l, TreeMap<Object, TreeSet<Object>> g) {
        if (l.nil()) {
            return g;
        }
        TreeMap ret = (TreeMap)g.clone();
        for (Map.Entry entry : ret.entrySet()) {
            entry.setValue((TreeSet)((TreeSet)entry.getValue()).clone());
        }
        for (NPair nPair : new ConsCellCollection(l)) {
            assert (nPair instanceof Ppair);
            Object src = nPair.getAnno_silver_core_fst();
            Object dst = nPair.getAnno_silver_core_snd();
            TreeSet<Object> srcSet = (TreeSet<Object>)ret.get(src);
            if (srcSet == null) {
                srcSet = new TreeSet<Object>(g.comparator());
                ret.put(src, srcSet);
            } else if (srcSet.contains(dst)) continue;
            TreeSet dstSet = (TreeSet)ret.get(dst);
            srcSet.add(dst);
            if (dstSet != null) {
                srcSet.addAll(dstSet);
            }
            for (Map.Entry entry : ret.entrySet()) {
                TreeSet target = (TreeSet)entry.getValue();
                if (!target.contains(src)) continue;
                target.addAll(srcSet);
            }
        }
        return ret;
    }
}

