/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.TopNode;
import common.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    public void runingDebug(DecoratedNode tree) {
        Scanner inp = new Scanner(System.in);
        System.out.println("Enter characters,  and 'q' to quit.");
        this.root = tree;
        this.currentNode = tree;
        block30: while (true) {
            String userInput = inp.nextLine();
            String[] userInputList = userInput.split(" ");
            switch (userInputList[0]) {
                case "up": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        break;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        break;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        break;
                    }
                    this.currentNode = this.currentNode.getParent();
                    System.out.println("going to parent");
                    break;
                }
                case "down": {
                    if (userInputList.length != 2) {
                        System.out.println("invalid, correct usage: down<node>");
                        break;
                    }
                    DecoratedNode childNode = this.down(Integer.parseInt(userInputList[1]));
                    if (childNode == null) {
                        System.out.println("invalid child number");
                        break;
                    }
                    System.out.println("going down");
                    this.currentNode = childNode;
                    break;
                }
                case "forwards": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    DecoratedNode childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        break;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    break;
                }
                case "backtrack": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    DecoratedNode childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        break;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    break;
                }
                case "prod": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    String partent_type = this.currentNode.undecorate().getProdleton().getName();
                    String[] child_types = this.currentNode.undecorate().getProdleton().getChildTypes();
                    System.out.println(partent_type);
                    int i = 0;
                    while (true) {
                        if (i >= child_types.length) continue block30;
                        System.out.println(child_types[i]);
                        ++i;
                    }
                }
                case "eq": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: eq<attr?>");
                        break;
                    }
                    System.out.println("do the eq stuff");
                    break;
                }
                case "listSynth": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block30;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case "listInher": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher<node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block30;
                    System.out.println("no inherited attributes");
                    break;
                }
                case "list": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) + this.listInher(this.currentNode) != 0) continue block30;
                    System.out.println("no attributes");
                    break;
                }
                case "view": {
                    if (userInputList.length != 2) {
                        System.out.println("invalid, correct usage: view<attr>");
                        break;
                    }
                    this.viewAttr(this.currentNode, userInputList[1]);
                    break;
                }
                case "help": {
                    System.out.println("up<>");
                    System.out.println("down<node>");
                    System.out.println("view<attr>");
                    System.out.println("forwards<>");
                    System.out.println("backtrack<>");
                    System.out.println("prod<>");
                    System.out.println("eq<attr?>");
                    System.out.println("listSynth<node?>");
                    System.out.println("listInher<node?>");
                    System.out.println("list<node?>");
                    System.out.println("exit");
                    break;
                }
                case "exit": 
                case "q": 
                case "quit": {
                    System.out.println("debugger out");
                    break block30;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        if (this.currentNode.getNode().getNumberOfChildren() > child) {
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        return null;
    }

    public DecoratedNode forwards(DecoratedNode Node2) {
        if (Node2.getNode().hasForward()) {
            this.currentNode = Node2.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode Node2) {
        this.currentNode = Node2.getForwardParent();
        return this.currentNode;
    }

    public void printProduction() {
        this.currentNode.getNode().getProdleton().getName();
    }

    public void eqSynth(int attribute) {
    }

    public void eqInher(int attribute) {
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int num_attr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int num_attr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int viewSynth(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        if (!nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
            System.out.println("Bad input, legal inputs:");
            Set<String> synAttrSet = nonterminalton.getAllSynth();
            System.out.println("Keys: " + synAttrSet);
            return -1;
        }
        index = nonterminalton.getSynOccursIndex(attribute);
        Lazy synthAttribute = node.getNode().getSynthesized(index);
        Object o = synthAttribute.eval(node);
        System.out.println(Util.genericShow(o));
        return 1;
    }

    public int viewInher(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        if (!nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
            System.out.println("Bad input, legal inputs:");
            Set<String> inhAttrSet = nonterminalton.getAllInh();
            System.out.println("Keys: " + inhAttrSet);
            return -1;
        }
        index = nonterminalton.getInhOccursIndex(attribute);
        Object o = node.evalInhSomehowButPublic(index);
        System.out.println(Util.genericShow(o));
        return 1;
    }

    public int viewAttr(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        boolean isSynth = false;
        if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
            index = nonterminalton.getSynOccursIndex(attribute);
            isSynth = true;
        } else if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
            index = nonterminalton.getInhOccursIndex(attribute);
        } else {
            System.out.println("Bad input, legal inputs:");
            HashSet<String> allInputs = new HashSet<String>();
            Set<String> synAttrSet = nonterminalton.getAllSynth();
            Set<String> inhAttrSet = nonterminalton.getAllInh();
            allInputs.addAll(synAttrSet);
            allInputs.addAll(inhAttrSet);
            System.out.println("Keys: " + allInputs);
            return -1;
        }
        if (isSynth) {
            Lazy synthAttribute = node.getNode().getSynthesized(index);
            Object o = synthAttribute.eval(node);
            System.out.println(Util.genericShow(o));
        } else {
            Object o = node.evalInhSomehowButPublic(index);
            System.out.println(Util.genericShow(o));
        }
        return 1;
    }

    public void viewLocals(DecoratedNode node, int attribute) {
    }

    public boolean isContractum() {
        return false;
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

