/*
 * Decompiled with CFR 0.152.
 */
package silver.core;

import common.Decorator;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.exceptions.SilverInternalError;
import java.util.LinkedList;
import silver.core.Init;

public abstract class NPair
extends Node {
    public static final int num_inh_attrs = Init.count_inh__ON__Pair;
    public static final int num_syn_attrs = Init.count_syn__ON__Pair;
    public static final String[] occurs_inh = new String[num_inh_attrs];
    public static final String[] occurs_syn = new String[num_syn_attrs];
    public static final LinkedList<Decorator> decorators = new LinkedList();
    public static final Lazy[] defaultSynthesizedAttributes = new Lazy[num_syn_attrs];
    public static final RTTIManager.Nonterminalton<NPair> nonterminalton = new Nonterminalton();

    protected NPair() {
    }

    public final int getNumberOfInhAttrs() {
        return num_inh_attrs;
    }

    public final int getNumberOfSynAttrs() {
        return num_syn_attrs;
    }

    public final Lazy getDefaultSynthesized(int index) {
        return defaultSynthesizedAttributes[index];
    }

    public final String getNameOfInhAttr(int index) {
        return occurs_inh[index];
    }

    public final String getNameOfSynAttr(int index) {
        return occurs_syn[index];
    }

    public final String[] getAnnoNames() {
        return new String[0];
    }

    public final Object getAnno(String name) {
        throw new SilverInternalError("Invalid annotation " + name);
    }

    public static final class Nonterminalton
    extends RTTIManager.Nonterminalton<NPair> {
        public String getName() {
            return "silver:core:Pair";
        }

        public String[] getOccursInh() {
            return occurs_inh;
        }
    }
}

