/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.builders.ExtensionFragmentData;
import edu.umn.cs.melt.copper.compiletime.builders.ExtensionMappingSpec;
import edu.umn.cs.melt.copper.compiletime.builders.SingleScannerDFAAnnotationBuilder;
import edu.umn.cs.melt.copper.compiletime.builders.SingleScannerDFABuilder;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.MutableLRParseTable;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PrecedenceGraph;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ExtensionFragmentDataBuilder {
    private ParserSpec fullSpec;
    private LR0DFA fullDFA;
    private LRParseTable fullParseTable;
    private LRLookaheadAndLayoutSets fullLookaheadAndLayoutSets;
    private TransparentPrefixes fullPrefixes;
    private int extensionStateCount;
    private ExtensionMappingSpec mappingSpec;

    public static ExtensionFragmentData build(ParserSpec fullSpec, LR0DFA fullDFA, LRParseTable fullParseTable, PSSymbolTable fullSymbolTable, ParserSpec hostSpec, Map<Integer, Integer> hostPartitionMap, BitSet extensionStatePartition, LRLookaheadAndLayoutSets fullLookaheadAndLayoutSets, TransparentPrefixes fullPrefixes, CompilerLogger logger) {
        ExtensionFragmentDataBuilder builder = new ExtensionFragmentDataBuilder(fullSpec, fullDFA, fullParseTable, fullSymbolTable, hostSpec, hostPartitionMap, extensionStatePartition, fullLookaheadAndLayoutSets, fullPrefixes);
        ExtensionFragmentData data = builder.build();
        if (logger.getLevel() == CompilerLevel.VERBOSE) {
            System.out.println("== BEGIN ExtensionLRParseTableBuilder ==");
            System.out.println("Indices:");
            System.out.println("  host terminals: " + builder.bitSetIndicesToString(builder.mappingSpec.hostTerminalIndices));
            System.out.println("  host nonterminals: " + builder.bitSetIndicesToString(builder.mappingSpec.hostNonterminalIndices));
            System.out.println("  host productions: " + builder.bitSetIndicesToString(builder.mappingSpec.hostProductionIndices));
            System.out.println("  extension terminals: " + builder.bitSetIndicesToString(builder.mappingSpec.extensionTerminalIndices));
            System.out.println("  extension nonterminals: " + builder.bitSetIndicesToString(builder.mappingSpec.extensionNonterminalIndices));
            System.out.println("  extension productions: " + builder.bitSetIndicesToString(builder.mappingSpec.extensionProductionIndices));
            System.out.println("Maps:");
            System.out.println("  composed to decomposed symbols:");
            builder.printPartitionMap(builder.mappingSpec.composedToDecomposedSymbols);
            System.out.println("  extension state num to composed state num:");
            builder.printPartitionMap(builder.mappingSpec.extensionToComposedStates);
            System.out.println("  composed to decomposed state map:");
            builder.printPartitionMap(builder.mappingSpec.composedToDecomposedStates);
            System.out.println("Appended Extension Parse Table");
            data.appendedExtensionTable.print();
            System.out.println("== END ExtensionLRParseTableBuilder ==");
        }
        return data;
    }

    private String bitSetIndicesToString(BitSet bitSet) {
        String ret = "";
        int i = bitSet.nextSetBit(0);
        while (i != -1) {
            ret = ret + i + ", ";
            i = bitSet.nextSetBit(i + 1);
        }
        return ret;
    }

    private void printPartitionMap(Map<Integer, Integer> map) {
        for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
            System.out.println("    " + entry.getKey() + " -> " + entry.getValue());
        }
    }

    private ExtensionFragmentDataBuilder(ParserSpec fullSpec, LR0DFA fullDFA, LRParseTable fullParseTable, PSSymbolTable fullSymbolTable, ParserSpec hostSpec, Map<Integer, Integer> hostPartitionMap, BitSet extensionStatePartition, LRLookaheadAndLayoutSets fullLookaheadAndLayoutSets, TransparentPrefixes fullPrefixes) {
        this.fullSpec = fullSpec;
        this.fullDFA = fullDFA;
        this.fullParseTable = fullParseTable;
        this.fullLookaheadAndLayoutSets = fullLookaheadAndLayoutSets;
        this.fullPrefixes = fullPrefixes;
        this.extensionStateCount = extensionStatePartition.cardinality();
        this.mappingSpec = new ExtensionMappingSpec(fullSpec, fullSymbolTable, hostSpec, hostPartitionMap, extensionStatePartition);
    }

    private ExtensionFragmentData build() {
        ExtensionFragmentData data = new ExtensionFragmentData();
        data.extensionMappingSpec = this.mappingSpec;
        this.generateExtensionLookaheadAndLayout(data, this.mappingSpec);
        this.generateExtensionParseTables(data, this.mappingSpec);
        this.generateExtensionTransparentPrefixes(data, this.mappingSpec);
        this.generateScannerDFA(data, this.mappingSpec);
        this.generateScannerDFAAnnotations(data, this.mappingSpec);
        this.generateMarkingTerminalMetadata(data, this.mappingSpec);
        return data;
    }

    private void generateExtensionLookaheadAndLayout(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        int maxItemCount = this.fullLookaheadAndLayoutSets.getMaxItemCount();
        LRLookaheadAndLayoutSets extensionSets = new LRLookaheadAndLayoutSets(this.extensionStateCount, maxItemCount);
        for (int extState = 0; extState < this.extensionStateCount; ++extState) {
            int composedState = mappingSpec.extensionToComposedStates.get(extState);
            mappingSpec.translateSymbolBitSetWithTableOffset(this.fullLookaheadAndLayoutSets.getLayout(composedState), extensionSets.getLayout(extState));
            for (int item = 0; item < maxItemCount; ++item) {
                if (this.fullLookaheadAndLayoutSets.getLookahead(composedState, item) != null) {
                    mappingSpec.translateSymbolBitSetWithTableOffset(this.fullLookaheadAndLayoutSets.getLookahead(composedState, item), extensionSets.getLookahead(extState, item));
                }
                if (this.fullLookaheadAndLayoutSets.getItemLASources(composedState, item) == null) continue;
                mappingSpec.translateSymbolBitSetWithTableOffset(this.fullLookaheadAndLayoutSets.getItemLASources(composedState, item), extensionSets.getItemLASources(extState, item));
            }
        }
        data.extensionLookaheadAndLayoutSets = extensionSets;
    }

    private void generateExtensionTransparentPrefixes(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        LRParseTable parseTable = data.appendedExtensionTable;
        int offsetTerminalsLength = mappingSpec.offsetExtensionIndex(mappingSpec.extensionTerminalIndices.length() - 1);
        TransparentPrefixes prefixes = new TransparentPrefixes(offsetTerminalsLength, parseTable.size());
        for (Map.Entry<Integer, Integer> entry : mappingSpec.extensionToComposedStates.entrySet()) {
            int extensionState = entry.getKey();
            int composedState = entry.getValue();
            mappingSpec.translateSymbolBitSetWithTableOffset(this.fullPrefixes.getPrefixes(composedState), prefixes.getPrefixes(extensionState));
            for (int t = 0; t < this.fullSpec.terminals.length(); ++t) {
                BitSet originalFollowingTerminals = this.fullPrefixes.getFollowingTerminals(composedState, t);
                if (originalFollowingTerminals == null) continue;
                int translatedT = mappingSpec.translateAndTableOffsetComposedSymbol(t);
                prefixes.initializePrefixMap(extensionState, translatedT);
                mappingSpec.translateSymbolBitSetWithTableOffset(originalFollowingTerminals, prefixes.getFollowingTerminals(extensionState, translatedT));
            }
        }
        data.transparentPrefixes = prefixes;
    }

    private void generateExtensionParseTables(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        int extensionStateCount = mappingSpec.composedExtensionStates.cardinality();
        int hostColumnCount = mappingSpec.extensionSymbolTableOffset;
        int extensionColumnCount = Math.max(mappingSpec.extensionTerminalIndices.length(), mappingSpec.extensionNonterminalIndices.length());
        MutableLRParseTable appendedExtensionTable = new MutableLRParseTable(extensionStateCount, hostColumnCount + extensionColumnCount);
        for (int i = 0; i < extensionStateCount; ++i) {
            int composedStateNumber = mappingSpec.extensionToComposedStates.get(i);
            BitSet validLA = this.fullParseTable.getValidLA(composedStateNumber);
            int symbol = validLA.nextSetBit(0);
            while (symbol >= 0) {
                int convertedSymbol = mappingSpec.translateAndTableOffsetComposedSymbol(symbol);
                byte actionType = this.fullParseTable.getActionType(composedStateNumber, symbol);
                int composedActionParameter = this.fullParseTable.getActionParameter(composedStateNumber, symbol);
                int extensionActionParameter = this.translateActionParameter(actionType, composedActionParameter);
                appendedExtensionTable.getValidLA(i).set(convertedSymbol);
                appendedExtensionTable.setActionType(i, convertedSymbol, actionType);
                appendedExtensionTable.setActionParameter(i, convertedSymbol, extensionActionParameter);
                symbol = validLA.nextSetBit(symbol + 1);
            }
        }
        data.appendedExtensionTable = appendedExtensionTable;
    }

    private int translateActionParameter(byte actionType, int composedActionParameter) {
        switch (actionType) {
            case 3: {
                return 0;
            }
            case 2: {
                return this.mappingSpec.composedToDecomposedSymbols.get(composedActionParameter);
            }
            case 1: {
                return this.mappingSpec.composedToDecomposedStates.get(composedActionParameter);
            }
        }
        return 0;
    }

    private void generateScannerDFA(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        TreeMap<Integer, Regex> regexes = new TreeMap<Integer, Regex>();
        BitSet appendedTerminals = new BitSet();
        int i = this.fullSpec.terminals.nextSetBit(0);
        while (i >= 0) {
            Regex regex = this.fullSpec.t.getRegex(i);
            int oi = mappingSpec.translateAndTableOffsetComposedSymbol(i);
            appendedTerminals.set(oi);
            regexes.put(oi, regex);
            i = this.fullSpec.terminals.nextSetBit(i + 1);
        }
        int translatedEOF = mappingSpec.translateAndTableOffsetComposedSymbol(this.fullSpec.getEOFTerminal());
        data.scannerDFA = SingleScannerDFABuilder.build(regexes, appendedTerminals, translatedEOF);
    }

    private void generateScannerDFAAnnotations(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        SingleScannerDFAAnnotations annotations;
        int appendedTerminalsLength = mappingSpec.extensionSymbolTableOffset + mappingSpec.extensionTerminalIndices.length();
        PrecedenceGraph precedenceGraph = new PrecedenceGraph(appendedTerminalsLength);
        int composedTerminalsLength = this.fullSpec.terminals.length();
        for (int i = 0; i < composedTerminalsLength; ++i) {
            int oi = mappingSpec.translateAndTableOffsetComposedSymbol(i);
            for (int j = 0; j < composedTerminalsLength; ++j) {
                if (!this.fullSpec.t.precedences.hasEdge(i, j)) continue;
                int oj = mappingSpec.translateAndTableOffsetComposedSymbol(j);
                precedenceGraph.addEdge(oi, oj);
            }
        }
        data.scannerDFAAnnotations = annotations = SingleScannerDFAAnnotationBuilder.build(precedenceGraph, data.scannerDFA);
    }

    private void generateMarkingTerminalMetadata(ExtensionFragmentData data, ExtensionMappingSpec mappingSpec) {
        TreeMap<Integer, Integer> markingTerminalLHS = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> markingTerminalStates = new TreeMap<Integer, Integer>();
        BitSet[] initNTs = new BitSet[this.extensionStateCount];
        TreeMap<Integer, Map<Integer, Set<Integer>>> laSources = new TreeMap<Integer, Map<Integer, Set<Integer>>>();
        BitSet composedBridgeProductions = new BitSet();
        composedBridgeProductions.or(this.fullSpec.bridgeConstructs);
        composedBridgeProductions.and(this.fullSpec.productions);
        int cp = composedBridgeProductions.nextSetBit(0);
        while (cp >= 0) {
            int lhs = mappingSpec.composedToDecomposedSymbols.get(this.fullSpec.pr.getLHS(cp));
            int composedMarkingTerminal = this.fullSpec.pr.getRHSSym(cp, 0);
            int extensionMarkingTerminal = ExtensionMappingSpec.decodeExtensionIndex(mappingSpec.composedToDecomposedSymbols.get(composedMarkingTerminal));
            markingTerminalLHS.put(extensionMarkingTerminal, lhs);
            cp = composedBridgeProductions.nextSetBit(cp + 1);
        }
        for (int state = 0; state < this.fullDFA.size(); ++state) {
            LR0ItemSet itemSet = this.fullDFA.getItemSet(state);
            for (int item = 0; item < itemSet.size(); ++item) {
                if (itemSet.getPosition(item) != 1 || !this.fullSpec.bridgeConstructs.get(itemSet.getProduction(item))) continue;
                int composedMarkingTerminal = this.fullSpec.pr.getRHSSym(itemSet.getProduction(item), 0);
                int extensionMarkingTerminal = ExtensionMappingSpec.decodeExtensionIndex(mappingSpec.composedToDecomposedSymbols.get(composedMarkingTerminal));
                int extensionState = ExtensionMappingSpec.decodeExtensionIndex(mappingSpec.composedToDecomposedStates.get(state));
                markingTerminalStates.put(extensionMarkingTerminal, extensionState);
            }
            if (!mappingSpec.composedExtensionStates.get(state)) continue;
            int extensionState = ExtensionMappingSpec.decodeExtensionIndex(mappingSpec.composedToDecomposedStates.get(state));
            initNTs[extensionState] = mappingSpec.translateSymbolBitSetWithTableOffset(this.fullDFA.getInitNTs(state), new BitSet());
            TreeMap stateLASources = new TreeMap();
            int items = this.fullDFA.getItemSet(state).size();
            for (int item = 0; item < items; ++item) {
                int production = this.fullDFA.getItemSet(state).getProduction(item);
                if (this.fullSpec.pr.getRHSLength(production) != this.fullDFA.getItemSet(state).getPosition(item)) continue;
                int decomposedProduction = mappingSpec.composedToDecomposedSymbols.get(production);
                BitSet sources = this.fullLookaheadAndLayoutSets.getItemLASources(state, item);
                int nt = sources.nextSetBit(0);
                while (nt >= 0) {
                    int toNT = mappingSpec.translateAndTableOffsetComposedSymbol(nt);
                    if (stateLASources.get(toNT) == null) {
                        stateLASources.put(toNT, new HashSet());
                    }
                    ((Set)stateLASources.get(toNT)).add(decomposedProduction);
                    nt = sources.nextSetBit(nt + 1);
                }
            }
            laSources.put(extensionState, stateLASources);
        }
        TreeMap<Integer, Regex> markingTerminalRegexes = new TreeMap<Integer, Regex>();
        BitSet composedMarkingTerminals = new BitSet();
        composedMarkingTerminals.or(this.fullSpec.bridgeConstructs);
        composedMarkingTerminals.and(this.fullSpec.terminals);
        int ct = composedMarkingTerminals.nextSetBit(0);
        while (ct >= 0) {
            int extensionMarkingTerminal = ExtensionMappingSpec.decodeExtensionIndex(mappingSpec.composedToDecomposedSymbols.get(ct));
            markingTerminalRegexes.put(extensionMarkingTerminal, this.fullSpec.t.getRegex(ct));
            ct = composedMarkingTerminals.nextSetBit(ct + 1);
        }
        data.markingTerminalLHS = markingTerminalLHS;
        data.markingTerminalStates = markingTerminalStates;
        data.markingTerminalRegexes = markingTerminalRegexes;
        data.initNTs = initNTs;
        data.laSources = laSources;
    }
}

