/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.zeromq.ZMQ;
import zmq.ZError;

public class ZContext
implements Closeable {
    private volatile ZMQ.Context context;
    private List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private int ioThreads;
    private int linger;
    private int hwm;
    private boolean main;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads_) {
        this.ioThreads = ioThreads_;
        this.linger = 0;
        this.main = true;
    }

    public void destroy() {
        ListIterator<ZMQ.Socket> itr = this.sockets.listIterator();
        while (itr.hasNext()) {
            this.destroySocket(itr.next());
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
        this.context = null;
    }

    public ZMQ.Socket createSocket(int type) {
        ZMQ.Socket socket = this.getContext().socket(type);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        if (this.sockets.contains(s)) {
            try {
                s.setLinger(this.linger);
            }
            catch (ZError.CtxTerminatedException ctxTerminatedException) {
                // empty catch block
            }
            s.close();
            this.sockets.remove(s);
        }
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext shadow = new ZContext();
        shadow.setContext(ctx.getContext());
        shadow.setMain(false);
        return shadow;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getHWM() {
        return this.hwm;
    }

    public void setHWM(int hwm) {
        this.hwm = hwm;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZMQ.Context getContext() {
        ZMQ.Context result = this.context;
        if (result == null) {
            ZContext zContext = this;
            synchronized (zContext) {
                result = this.context;
                if (result == null) {
                    this.context = result = ZMQ.context(this.ioThreads);
                }
            }
        }
        return result;
    }

    public void setContext(ZMQ.Context ctx) {
        this.context = ctx;
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }

    @Override
    public void close() {
        this.destroy();
    }
}

