/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CollectionAttribute;
import common.Decorable;
import common.DecoratedTypeRep;
import common.FunctionNode;
import common.Lazy;
import common.Node;
import common.OriginContext;
import common.Thunk;
import common.TopNode;
import common.Typed;
import common.exceptions.MissingDefinitionException;
import common.exceptions.SilverException;
import common.exceptions.TraceException;
import silver.core.Alocation;
import silver.core.Init;

public class DecoratedNode
implements Decorable,
Typed {
    public OriginContext originCtx;
    protected final Node self;
    protected DecoratedNode forwardParent;
    protected final DecoratedNode parent;
    protected final Object[] childrenValues;
    protected DecoratedNode forwardValue;
    protected final Object[] inheritedValues;
    protected final Object[] synthesizedValues;
    protected Lazy[] inheritedAttributes;
    protected final Object[] localValues;

    DecoratedNode(int cc, int ic, int sc, int lc, Node self, DecoratedNode parent, Lazy[] inhs, DecoratedNode forwardParent) {
        this.self = self;
        this.parent = parent;
        this.originCtx = parent != null ? parent.originCtx : null;
        this.inheritedAttributes = inhs;
        this.forwardParent = forwardParent;
        this.childrenValues = cc > 0 ? new Object[cc] : null;
        this.inheritedValues = ic > 0 ? new Object[ic] : null;
        this.synthesizedValues = sc > 0 ? new Object[sc] : null;
        this.localValues = lc > 0 ? new Object[lc] : null;
    }

    DecoratedNode(int cc, int lc, FunctionNode self) {
        this.self = self;
        this.parent = TopNode.singleton;
        this.inheritedAttributes = null;
        this.forwardParent = null;
        this.childrenValues = new Object[cc];
        this.inheritedValues = null;
        this.synthesizedValues = null;
        this.localValues = lc > 0 ? new Object[lc] : null;
    }

    public final Node undecorate() {
        if (this.self.isUnique) {
            return this.self.undecorate(this);
        }
        return this.self;
    }

    @Override
    public DecoratedNode decorate(DecoratedNode parent, Lazy[] inhs) {
        if (this.forwardParent == null && inhs != null) {
            this.inheritedAttributes = (Lazy[])this.inheritedAttributes.clone();
            for (int i = 0; i < inhs.length; ++i) {
                int attribute = i;
                if (inhs[attribute] == null || this.inheritedAttributes[attribute] != null) continue;
                this.inheritedAttributes[attribute] = context -> inhs[attribute].eval(parent);
            }
        }
        return this;
    }

    @Override
    public DecoratedNode decorate(DecoratedNode parent, DecoratedNode fwdParent) {
        if (this.forwardParent == null) {
            this.forwardParent = fwdParent;
        }
        return this;
    }

    public final Node getNode() {
        return this.self;
    }

    public <T> T childAsIs(int child) {
        return (T)this.self.getChild(child);
    }

    public DecoratedNode childDecorated(int child) {
        Object o = this.childrenValues[child];
        if (o == null) {
            o = this.createDecoratedChild(child);
            assert (o != null);
            this.childrenValues[child] = o;
        }
        return (DecoratedNode)o;
    }

    private final DecoratedNode createDecoratedChild(int child) {
        return ((Decorable)this.self.getChild(child)).decorate(this, this.self.getChildInheritedAttributes(child));
    }

    public <T> T localAsIs(int attribute) {
        Object o = this.localValues[attribute];
        if (o == null) {
            o = this.evalLocalAsIs(attribute);
            assert (o != null);
            this.localValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalLocalAsIs(int attribute) {
        try {
            return this.self.getLocal(attribute).eval(this);
        }
        catch (Throwable t) {
            throw this.handleLocalError(attribute, t);
        }
    }

    private final SilverException handleLocalError(int attribute, Throwable t) {
        if (this.self.getLocal(attribute) == null) {
            return new MissingDefinitionException("Local '" + this.self.getNameOfLocalAttr(attribute) + "' not defined in " + this.getDebugID());
        }
        return new TraceException("While evaling local '" + this.self.getNameOfLocalAttr(attribute) + "' in " + this.getDebugID(), t);
    }

    public DecoratedNode localDecorated(int attribute) {
        Object o = this.localValues[attribute];
        if (o == null) {
            o = this.evalLocalDecorated(attribute);
            assert (o != null);
            this.localValues[attribute] = o;
        }
        return (DecoratedNode)o;
    }

    private final DecoratedNode evalLocalDecorated(int attribute) {
        return ((Decorable)this.evalLocalAsIs(attribute)).decorate(this, this.self.getLocalInheritedAttributes(attribute));
    }

    public <T> T synthesized(int attribute) {
        Object o = this.synthesizedValues[attribute];
        if (o == null) {
            o = this.evalSyn(attribute);
            assert (o != null);
            this.synthesizedValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalSyn(int attribute) {
        Lazy l = this.self.getSynthesized(attribute);
        if (l != null) {
            try {
                if (l instanceof CollectionAttribute) {
                    CollectionAttribute prodAttr = (CollectionAttribute)l;
                    if (!prodAttr.appliedNTFix) {
                        prodAttr.appliedNTFix = true;
                        CollectionAttribute ntAttr = (CollectionAttribute)this.self.getDefaultSynthesized(attribute);
                        if (ntAttr != null) {
                            prodAttr.getPieces().addAll(ntAttr.getPieces());
                        }
                    }
                }
                return l.eval(this);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling syn '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
            }
        }
        if (this.self.hasForward()) {
            try {
                return this.forward().synthesized(attribute);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling syn '" + this.self.getNameOfSynAttr(attribute) + "' via forward in " + this.getDebugID(), t);
            }
        }
        l = this.self.getDefaultSynthesized(attribute);
        if (l != null) {
            try {
                return l.eval(this);
            }
            catch (Throwable t) {
                throw new TraceException("While evaling default for '" + this.self.getNameOfSynAttr(attribute) + "' in " + this.getDebugID(), t);
            }
        }
        throw new MissingDefinitionException("Synthesized attribute '" + this.self.getNameOfSynAttr(attribute) + "' not defined in " + this.getDebugID());
    }

    public DecoratedNode forward() {
        if (this.forwardValue == null) {
            this.forwardValue = this.evalForward();
            assert (this.forwardValue != null);
        }
        return this.forwardValue;
    }

    public DecoratedNode forwardOrThis() {
        return this.self.hasForward() ? this.forward() : this;
    }

    private final DecoratedNode evalForward() {
        try {
            return this.self.evalForward(this).decorate(this.parent, this);
        }
        catch (Throwable t) {
            throw this.handleFwdError(t);
        }
    }

    private final RuntimeException handleFwdError(Throwable t) {
        return new TraceException("While evaling forward equation in " + this.getDebugID(), t);
    }

    public <T> T inherited(int attribute) {
        Object o = this.inheritedValues[attribute];
        if (o == null) {
            o = this.evalInhSomehow(attribute);
            assert (o != null);
            this.inheritedValues[attribute] = o;
        }
        return (T)o;
    }

    private final Object evalInhSomehow(int attribute) {
        if (this.hasExplicitInhEq(attribute)) {
            return this.evalInhHere(attribute);
        }
        return this.evalInhViaFwdP(attribute);
    }

    private final Object evalInhViaFwdP(int attribute) {
        try {
            return this.forwardParent.inheritedForwarded(attribute);
        }
        catch (Throwable t) {
            throw this.handleInhFwdPError(attribute, t);
        }
    }

    private final SilverException handleInhFwdPError(int attribute, Throwable t) {
        if (this.forwardParent == null) {
            return new MissingDefinitionException("Inherited attribute '" + this.self.getNameOfInhAttr(attribute) + "' not provided to " + this.getDebugID() + " by " + this.parent.getDebugID());
        }
        return new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' via forward in " + this.getDebugID(), t);
    }

    private final Object evalInhHere(int attribute) {
        try {
            return this.inheritedAttributes[attribute].eval(this.parent);
        }
        catch (Throwable t) {
            throw this.handleInhHereError(attribute, t);
        }
    }

    private final SilverException handleInhHereError(int attribute, Throwable t) {
        return new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' in " + this.getDebugID(), t);
    }

    private final boolean hasExplicitInhEq(int attribute) {
        return this.inheritedAttributes != null && attribute < this.inheritedAttributes.length && this.inheritedAttributes[attribute] != null;
    }

    protected Object inheritedForwarded(int attribute) {
        Lazy l = this.self.getForwardInheritedAttributes(attribute);
        if (l == null) {
            return this.inherited(attribute);
        }
        try {
            return l.eval(this);
        }
        catch (Throwable t) {
            throw this.handleInhFwdError(attribute, t);
        }
    }

    private final SilverException handleInhFwdError(int attribute, Throwable t) {
        return new TraceException("While evaling inh '" + this.self.getNameOfInhAttr(attribute) + "' for forward in " + this.getDebugID(), t);
    }

    public final Object childDecoratedLazy(int child) {
        if (this.childrenValues[child] != null) {
            return this.childrenValues[child];
        }
        return new Thunk<Object>(() -> this.childDecorated(child));
    }

    public final Object childUndecoratedLazy(int child) {
        return new Thunk<Object>(() -> this.childDecorated(child).undecorate());
    }

    public final Object childAsIsLazy(int child) {
        return this.self.getChildLazy(child);
    }

    public final Object localDecoratedLazy(int index) {
        if (this.localValues[index] != null) {
            return this.localValues[index];
        }
        return new Thunk<Object>(() -> this.localDecorated(index));
    }

    public final Object localAsIsLazy(int index) {
        if (this.localValues[index] != null) {
            return this.localValues[index];
        }
        return new Thunk<Object>(() -> this.localAsIs(index));
    }

    public final Object childDecoratedSynthesizedLazy(int child, int index) {
        Object v = this.childrenValues[child];
        if (v != null) {
            return ((DecoratedNode)v).contextSynthesizedLazy(index);
        }
        return new Thunk<Object>(() -> this.childDecorated(child).synthesized(index));
    }

    public final Object childAsIsSynthesizedLazy(int child, int index) {
        Object v = this.self.getChildLazy(child);
        if (!(v instanceof Thunk)) {
            return ((DecoratedNode)v).contextSynthesizedLazy(index);
        }
        return new Thunk<Object>(() -> ((DecoratedNode)this.childAsIs(child)).synthesized(index));
    }

    public final Object contextSynthesizedLazy(int index) {
        if (this.synthesizedValues[index] != null) {
            return this.synthesizedValues[index];
        }
        return new Thunk<Object>(() -> this.synthesized(index));
    }

    public final Object contextInheritedLazy(int index) {
        if (this.inheritedValues[index] != null) {
            return this.inheritedValues[index];
        }
        return new Thunk<Object>(() -> this.inherited(index));
    }

    @Override
    public final DecoratedTypeRep getType() {
        return new DecoratedTypeRep(this.self.getType());
    }

    public final String getDebugID() {
        String qualifier;
        if (this.self == null) {
            return "<top>";
        }
        if (this.self instanceof Alocation) {
            DecoratedNode loc = ((Alocation)this.self).getAnno_silver_core_location().decorate((DecoratedNode)TopNode.singleton, (Lazy[])null);
            String file = loc.synthesized(Init.silver_core_filename__ON__silver_core_Location).toString();
            int line = (Integer)loc.synthesized(Init.silver_core_line__ON__silver_core_Location);
            int col = (Integer)loc.synthesized(Init.silver_core_column__ON__silver_core_Location);
            qualifier = ", " + file + ":" + Integer.toString(line) + ":" + Integer.toString(col);
        } else {
            qualifier = "";
        }
        return "'" + this.self.getName() + "' (" + Integer.toHexString(System.identityHashCode(this)) + qualifier + ")";
    }

    public final String toString() {
        return this.getDebugID();
    }
}

