/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.FollowSpillageMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.LookaheadSpillageMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.NonILSubsetMessage;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.mda.MDAResults;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class MDAResultChecker {
    private CompilerLogger logger;
    private MDAResults results;
    private PSSymbolTable symbolTable;
    private ParserSpec spec;
    private LR0DFA fullDFA;
    private GrammarStatistics stats;

    public static boolean check(CompilerLogger logger, MDAResults results, PSSymbolTable symbolTable, ParserSpec spec, LR0DFA fullDFA, GrammarStatistics stats) {
        return new MDAResultChecker(logger, results, symbolTable, spec, fullDFA, stats).check();
    }

    private MDAResultChecker(CompilerLogger logger, MDAResults results, PSSymbolTable symbolTable, ParserSpec spec, LR0DFA fullDFA, GrammarStatistics stats) {
        this.logger = logger;
        this.results = results;
        this.symbolTable = symbolTable;
        this.spec = spec;
        this.fullDFA = fullDFA;
        this.stats = stats;
    }

    public boolean check() {
        BitSet followSpilledNTs = new BitSet();
        BitSet hostPartition = new BitSet();
        hostPartition.or(this.results.getHostPartition());
        BitSet extPartition = new BitSet();
        extPartition.or(this.results.getExtPartition());
        BitSet newHostPartition = new BitSet();
        newHostPartition.or(this.results.getNewHostPartition());
        BitSet unpartitionableStates = new BitSet();
        block6: for (int i = 0; i < this.results.size(); ++i) {
            switch (this.results.getErrorType(i)) {
                case 2: {
                    BitSet diff = new BitSet();
                    diff.or(this.results.getFullFollowSet(i));
                    diff.andNot(this.results.getHostFollowSet(i));
                    followSpilledNTs.set(this.results.getNonterminal(i));
                    this.logger.log(new FollowSpillageMessage(this.symbolTable, this.results.getNonterminal(i), diff));
                    continue block6;
                }
                case 0: 
                case 1: {
                    BitSet diff = new BitSet();
                    diff.or(this.results.getFullLookaheadSet(i));
                    diff.andNot(this.results.getHostLookaheadSet(i));
                    hostPartition.clear(this.results.getFullState(i));
                    unpartitionableStates.set(this.results.getFullState(i));
                    int item = this.results.getItems(i).nextSetBit(0);
                    while (item >= 0) {
                        this.logger.log(new LookaheadSpillageMessage(this.symbolTable, this.spec, this.fullDFA, this.results.getFullState(i), item, diff, this.results.getErrorType(i) == 1));
                        item = this.results.getItems(i).nextSetBit(item + 1);
                    }
                    continue block6;
                }
                case 3: {
                    newHostPartition.clear(this.results.getFullState(i));
                    unpartitionableStates.set(this.results.getFullState(i));
                    this.logger.log(new NonILSubsetMessage(this.results.getFullState(i)));
                    continue block6;
                }
                case 4: {
                    newHostPartition.clear(this.results.getFullState(i));
                    unpartitionableStates.set(this.results.getFullState(i));
                    this.logger.log(new NonILSubsetMessage(this.results.getFullState(i), this.results.getISuperset(i)));
                }
            }
        }
        this.stats.mdaRun = true;
        this.stats.mdaPassed = this.results.size() == 0;
        this.stats.followSpilledNTCount = followSpilledNTs.cardinality();
        this.stats.hostStateCount = hostPartition.cardinality();
        this.stats.extStateCount = extPartition.cardinality();
        this.stats.newHostStateCount = newHostPartition.cardinality();
        this.stats.unpartitionableStateCount = unpartitionableStates.cardinality();
        if (this.logger.isLoggable(CompilerLevel.VERBOSE)) {
            this.logger.log(new GenericMessage(CompilerLevel.VERBOSE, this.stats.followSpilledNTCount + " nonterminals with follow spillage: " + PSSymbolTable.bitSetPrettyPrint(followSpilledNTs, this.symbolTable, "   ", 80)));
            this.logger.log(new GenericMessage(CompilerLevel.VERBOSE, this.stats.hostStateCount + " host states: " + hostPartition));
            this.logger.log(new GenericMessage(CompilerLevel.VERBOSE, this.stats.extStateCount + " extension states: " + extPartition));
            this.logger.log(new GenericMessage(CompilerLevel.VERBOSE, this.stats.newHostStateCount + " new-host states: " + newHostPartition));
            this.logger.log(new GenericMessage(CompilerLevel.VERBOSE, this.stats.unpartitionableStateCount + " unpartitionable states: " + unpartitionableStates));
        }
        return this.results.size() == 0;
    }
}

