/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.single;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.LexicalDisambiguationGroup;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.TerminalClass;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.QScannerStateInfo;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.LexicalConflictResolution;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.FullReduceAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1.LexicalAmbiguityChecker;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeSet;

public class SingleDFALexicalAmbiguityChecker
extends LexicalAmbiguityChecker {
    public SingleDFALexicalAmbiguityChecker(CompilerLogger logger) {
        super(logger);
    }

    @Override
    public void checkLexicalAmbiguities(GrammarSource grammarData, QScannerStateInfo[] stateInfo, ParseTable parseTable) throws CopperException {
        HashMap<HashSet<Terminal>, LexicalConflictResolution> ambiguityResolutions = new HashMap<HashSet<Terminal>, LexicalConflictResolution>();
        Hashtable ambiguityLocations = new Hashtable();
        for (int statenum = 0; statenum <= parseTable.getLastState(); ++statenum) {
            if (!parseTable.hasLayout(statenum)) {
                if (!this.logger.isLoggable(CompilerLogMessageSort.WARNING)) continue;
                this.logger.logMessage(CompilerLogMessageSort.WARNING, null, "No layout map listed for state " + statenum + ". Perhaps grammar layout was not specified.");
                continue;
            }
            if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
                this.logger.logTick(16, ".");
            }
            for (int i = 0; i < stateInfo.length; ++i) {
                LexicalConflictResolution resolution;
                HashSet<Terminal> acceptSet;
                QScannerStateInfo info = stateInfo[i];
                if (!parseTable.hasLayout(statenum)) {
                    if (!this.logger.isLoggable(CompilerLogMessageSort.WARNING)) continue;
                    this.logger.logMessage(CompilerLogMessageSort.WARNING, null, "No layout map listed for state " + statenum + ". Perhaps grammar layout was not specified.");
                    continue;
                }
                if (!parseTable.hasShiftable(statenum)) {
                    if (!this.logger.isLoggable(CompilerLogMessageSort.FATAL_ERROR)) continue;
                    this.logger.logErrorMessage(CompilerLogMessageSort.FATAL_ERROR, null, "No actions whatsoever listed for state " + statenum);
                    continue;
                }
                HashSet<Terminal> unifiedShiftable = new HashSet<Terminal>(parseTable.getShiftable(statenum));
                unifiedShiftable.addAll(parseTable.getLayout(statenum));
                if (parseTable.hasPrefixes(statenum)) {
                    unifiedShiftable.addAll(parseTable.getPrefixes(statenum));
                }
                if ((acceptSet = this.disambiguateState(info, grammarData, unifiedShiftable)).size() > 1 && !grammarData.hasDisambiguationGroup(new LexicalDisambiguationGroup(new TerminalClass("dacheck"), acceptSet, ""))) {
                    HashSet<ParseAction> actions = new HashSet<ParseAction>();
                    for (Terminal t : acceptSet) {
                        if (parseTable.hasAction(statenum, t)) {
                            for (ParseAction a : parseTable.getParseActions(statenum, t)) {
                                actions.add(a);
                                if (actions.size() <= 1) continue;
                                break;
                            }
                        }
                        if (actions.size() <= 1) continue;
                        break;
                    }
                    if (actions.size() == 1 && actions.iterator().next() instanceof FullReduceAction) continue;
                    if (!ambiguityLocations.containsKey(acceptSet) || ambiguityResolutions.get(acceptSet) != null) {
                        ambiguityLocations.put(acceptSet, new TreeSet());
                    }
                    ambiguityResolutions.put(acceptSet, null);
                    ((TreeSet)ambiguityLocations.get(acceptSet)).add(statenum);
                    continue;
                }
                if (acceptSet.isEmpty() || info.getAcceptingSyms().size() <= 1) continue;
                LexicalConflictResolution lexicalConflictResolution = resolution = acceptSet.size() == 1 ? LexicalConflictResolution.CONTEXT : LexicalConflictResolution.DISAMBIGUATION_FUNCTION;
                if (!ambiguityResolutions.containsKey(info.getAcceptingSyms())) {
                    ambiguityResolutions.put(info.getAcceptingSyms(), resolution);
                }
                if (ambiguityResolutions.get(info.getAcceptingSyms()) == null) continue;
                if (!ambiguityLocations.containsKey(info.getAcceptingSyms())) {
                    ambiguityLocations.put(info.getAcceptingSyms(), new TreeSet());
                }
                ((TreeSet)ambiguityLocations.get(info.getAcceptingSyms())).add(i);
            }
        }
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "\n");
        }
        for (HashSet ambiguity : ambiguityResolutions.keySet()) {
            LexicalConflictResolution resolution = (LexicalConflictResolution)((Object)ambiguityResolutions.get(ambiguity));
            TreeSet places = (TreeSet)ambiguityLocations.get(ambiguity);
            this.reportAmbiguity(grammarData, ambiguity, places, resolution);
        }
    }
}

