/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.HashMap;
import java.util.Map;

public class Statistics
extends Thread {
    protected static boolean hooked = false;
    protected static final Map<String, Integer> dn_spawn = new HashMap<String, Integer>();
    protected static final Map<String, Integer> dn_final = new HashMap<String, Integer>();
    protected static final Map<String, Integer> n_spawn = new HashMap<String, Integer>();
    protected static final Map<String, Integer> n_final = new HashMap<String, Integer>();
    protected static final Map<String, Integer> t_spawn = new HashMap<String, Integer>();
    protected static final Map<String, Integer> t_final = new HashMap<String, Integer>();

    public static void hook() {
        if (!hooked) {
            hooked = true;
            Runtime rt = Runtime.getRuntime();
            rt.addShutdownHook(new Statistics());
        }
    }

    @Override
    public void run() {
        int tns = 0;
        int tnf = 0;
        int tdns = 0;
        int tdnf = 0;
        int tts = 0;
        int ttf = 0;
        System.out.println("Nodes\t(res)\t\tDNodes\t(res)\t\t% Dec\t%rec(n)\t%rec(dn)\t\tThunks\t(res)\t%");
        for (String key : n_spawn.keySet()) {
            Integer tf;
            Integer ts;
            Integer dnf;
            Integer dns;
            Integer ns = n_spawn.get(key);
            Integer nf = n_final.get(key);
            if (nf == null) {
                nf = 0;
            }
            if ((dns = dn_spawn.get(key)) == null) {
                dns = 0;
            }
            if ((dnf = dn_final.get(key)) == null) {
                dnf = 0;
            }
            if ((ts = t_spawn.get(key)) == null) {
                ts = 0;
            }
            if ((tf = t_final.get(key)) == null) {
                tf = 0;
            }
            System.out.printf("%d\t%d\t\t%d\t%d\t\t%3f\t%3f\t%3f\t\t%d\t%d\t%3f\t", ns, ns - nf, dns, dns - dnf, Float.valueOf((float)dns.intValue() / (float)ns.intValue()), Float.valueOf((float)(ns - nf) / (float)ns.intValue()), Float.valueOf((float)(dns - dnf) / (float)dns.intValue()), ts, ts - tf, Float.valueOf((float)(ts - tf) / (float)ts.intValue()));
            System.out.println(key);
            tns += ns.intValue();
            tnf += nf.intValue();
            tdns += dns.intValue();
            tdnf += dnf.intValue();
            tts += ts.intValue();
            ttf += tf.intValue();
        }
        System.out.println("Total:\tNodes\t(res)\t\tDecN\t(res)\t\tThunk\t(res)");
        System.out.println("\t" + tns + "\t" + (tns - tnf) + "\t\t" + tdns + "\t" + (tdns - tdnf) + "\t\t" + tts + "\t" + (tts - ttf));
    }

    private static void increment(Map<String, Integer> map, Class<?> class1) {
        Integer n = map.get(class1.getName());
        if (n == null) {
            n = 0;
        }
        n = n + 1;
        map.put(class1.getName(), n);
    }

    protected static void dnSpawn(Class<?> class1) {
        Statistics.increment(dn_spawn, class1);
    }

    protected static void dnFinal(Class<?> class1) {
        Statistics.increment(dn_final, class1);
    }

    protected static void nSpawn(Class<?> class1) {
        Statistics.increment(n_spawn, class1);
    }

    protected static void nFinal(Class<?> class1) {
        Statistics.increment(n_final, class1);
    }

    protected static void tSpawn(Class<?> class1) {
        Statistics.increment(t_spawn, class1);
    }

    protected static void tFinal(Class<?> class1) {
        Statistics.increment(t_final, class1);
    }
}

