/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.TopNode;
import common.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    public void runingDebug(DecoratedNode tree) {
        Scanner inp = new Scanner(System.in);
        System.out.println("Enter characters, and 'q' to quit.");
        boolean toggleProdDisplay = true;
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack();
        if (toggleProdDisplay) {
            this.printProduction(this.currentNode);
        }
        block38: while (true) {
            String userInput = inp.nextLine();
            String[] userInputList = userInput.split(" ");
            switch (userInputList[0]) {
                case "up": 
                case "u": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        break;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        break;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = this.currentNode.getParent();
                    if (!toggleProdDisplay) continue block38;
                    this.printProduction(this.currentNode);
                    break;
                }
                case "down": 
                case "d": {
                    int childNum = 0;
                    if (userInputList.length != 2) {
                        System.out.println("Which child?");
                        this.printChildren(this.currentNode);
                        childNum = inp.nextInt();
                        inp.nextLine();
                    } else {
                        childNum = Integer.parseInt(userInputList[1]);
                    }
                    DecoratedNode childNode = this.down(childNum);
                    if (childNode == null) {
                        System.out.println("invalid child number");
                        break;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = childNode;
                    if (!toggleProdDisplay) continue block38;
                    this.printProduction(this.currentNode);
                    break;
                }
                case "undo": {
                    DecoratedNode newNode;
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo<>");
                        break;
                    }
                    if (this.nodeStack.empty()) {
                        System.out.println("invalid no node to undo");
                        break;
                    }
                    this.currentNode = newNode = this.nodeStack.pop();
                    if (!toggleProdDisplay) continue block38;
                    this.printProduction(this.currentNode);
                    break;
                }
                case "forwards": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        break;
                    }
                    DecoratedNode childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        break;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    if (!toggleProdDisplay) continue block38;
                    this.printProduction(this.currentNode);
                    break;
                }
                case "backtrack": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        break;
                    }
                    DecoratedNode childNode = this.backtrack(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        break;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    if (!toggleProdDisplay) continue block38;
                    this.printProduction(this.currentNode);
                    break;
                }
                case "toggle": {
                    if (userInputList.length != 2) {
                        System.out.println("please indicate what you want to toggle ex: 'toggle prodDisplay'");
                        break;
                    }
                    if (userInputList[1].equals("prodDisplay")) {
                        if (toggleProdDisplay) {
                            System.out.println("Production Display off");
                            toggleProdDisplay = false;
                            break;
                        }
                        System.out.println("Production Display on");
                        toggleProdDisplay = true;
                        break;
                    }
                    System.out.println("legal toggles: prodDisplay");
                    System.out.println(userInputList[1]);
                    break;
                }
                case "prod": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        break;
                    }
                    this.printProduction(this.currentNode);
                    break;
                }
                case "eq": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: eq<attr?>");
                        break;
                    }
                    System.out.println("do the eq stuff");
                    break;
                }
                case "listSynth": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        break;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block38;
                    System.out.println("no synthesized attributes");
                    break;
                }
                case "listInher": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher<node?>");
                        break;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block38;
                    System.out.println("no inherited attributes");
                    break;
                }
                case "list": 
                case "l": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        break;
                    }
                    this.printAttributes(this.currentNode);
                    break;
                }
                case "view": 
                case "v": {
                    String attributeName = "";
                    Integer attributeNum = 0;
                    if (userInputList.length != 2) {
                        System.out.println("Which attribute?");
                        this.printAttributes(this.currentNode);
                        attributeNum = inp.nextInt();
                        inp.nextLine();
                        attributeName = this.getAttributeNameFromNum(this.currentNode, attributeNum);
                    } else {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = this.getAttributeNameFromNum(this.currentNode, attributeNum);
                    }
                    this.printAttrFromName(this.currentNode, attributeName);
                    break;
                }
                case "help": {
                    System.out.println("up");
                    System.out.println("down <node>");
                    System.out.println("view <attr>");
                    System.out.println("forwards");
                    System.out.println("backtrack");
                    System.out.println("prod");
                    System.out.println("eq");
                    System.out.println("listSynth");
                    System.out.println("listInher");
                    System.out.println("list");
                    System.out.println("exit");
                    break;
                }
                case "exit": 
                case "q": 
                case "quit": {
                    System.out.println("debugger out");
                    break block38;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                    System.out.println(userInput);
                }
            }
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        if (this.currentNode.getNode().getNumberOfChildren() > child) {
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        return null;
    }

    public void printChildren(DecoratedNode node) {
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + child_productions[i] + " ");
        }
    }

    public DecoratedNode forwards(DecoratedNode node) {
        if (node.getNode().hasForward()) {
            this.currentNode = node.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode node) {
        this.currentNode = node.getForwardParent();
        return this.currentNode;
    }

    public void printProduction(DecoratedNode node) {
        String partent_production = node.undecorate().getProdleton().getName();
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        System.out.print(partent_production + " ");
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.print(child_productions[i] + " ");
        }
        System.out.print("\n");
    }

    public void eqSynth(int attribute) {
    }

    public void eqInher(int attribute) {
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int num_attr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int num_attr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public void printAttributes(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alhpabeticalAttributes();
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public String getAttributeNameFromNum(DecoratedNode node, Integer attributeNum) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alhpabeticalAttributes();
        return attributeList.get(attributeNum);
    }

    public int viewSynth(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        if (!nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
            System.out.println("Bad input, legal inputs:");
            Set<String> synAttrSet = nonterminalton.getAllSynth();
            System.out.println("Keys: " + synAttrSet);
            return -1;
        }
        index = nonterminalton.getSynOccursIndex(attribute);
        Lazy synthAttribute = node.getNode().getSynthesized(index);
        Object o = synthAttribute.eval(node);
        System.out.println(Util.genericShow(o));
        return 1;
    }

    public int viewInher(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        if (!nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
            System.out.println("Bad input, legal inputs:");
            Set<String> inhAttrSet = nonterminalton.getAllInh();
            System.out.println("Keys: " + inhAttrSet);
            return -1;
        }
        index = nonterminalton.getInhOccursIndex(attribute);
        Object o = node.evalInhSomehowButPublic(index);
        System.out.println(Util.genericShow(o));
        return 1;
    }

    public Integer printAttrFromName(DecoratedNode node, String attribute) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        int index = 0;
        boolean isSynth = false;
        if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
            index = nonterminalton.getSynOccursIndex(attribute);
            isSynth = true;
        } else if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
            index = nonterminalton.getInhOccursIndex(attribute);
        } else {
            return -1;
        }
        if (isSynth) {
            Lazy synthAttribute = node.getNode().getSynthesized(index);
            Object o = synthAttribute.eval(node);
            System.out.println(Util.genericShow(o));
        } else {
            Object o = node.evalInhSomehowButPublic(index);
            System.out.println(Util.genericShow(o));
        }
        return 1;
    }

    public void viewLocals(DecoratedNode node, int attribute) {
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

