/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;

public class ParserSpecPlaintextPrinter
implements CopperASTBeanVisitor<Boolean, RuntimeException>,
RegexBeanVisitor<Boolean, RuntimeException> {
    private ParserBean currentParser = null;
    private Grammar currentGrammar = null;
    private StringBuffer out = new StringBuffer();

    public static String specToString(ParserBean spec) {
        ParserSpecPlaintextPrinter printer = new ParserSpecPlaintextPrinter();
        spec.acceptVisitor(printer);
        return printer.out.toString();
    }

    private ParserSpecPlaintextPrinter() {
    }

    @Override
    public Boolean visitDisambiguationFunction(DisambiguationFunction bean) throws RuntimeException {
        this.out.append("      Disambiguation " + (bean.getDisambiguateTo() == null ? "function" : "group") + ": " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        if (bean.getDisambiguateTo() != null) {
            this.out.append("        Disambiguates to: " + this.getName(bean.getDisambiguateTo())).append("\n");
        }
        this.out.append("        Members:");
        for (CopperElementReference member : bean.getMembers()) {
            this.out.append("\n      \t    " + this.getName(member));
        }
        this.out.append("\n");
        return false;
    }

    @Override
    public Boolean visitGrammar(Grammar bean) throws RuntimeException {
        this.currentGrammar = bean;
        this.out.append("  Grammar " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        this.out.append("    Grammar layout:");
        if (bean.getGrammarLayout() == null) {
            this.out.append(" NONE\n");
        } else {
            for (CopperElementReference layout : bean.getGrammarLayout()) {
                this.out.append("\n      " + this.getName(layout));
            }
        }
        this.out.append("\n    Elements:\n");
        boolean hasError = false;
        for (CopperElementName n : bean.getGrammarElements()) {
            hasError |= bean.getGrammarElement(n).acceptVisitor(this).booleanValue();
        }
        return hasError;
    }

    @Override
    public Boolean visitExtensionGrammar(ExtensionGrammar bean) throws RuntimeException {
        this.currentGrammar = bean;
        this.out.append("  Extension grammar " + bean.getName() + "(" + bean.getDisplayName() + ")\n");
        boolean hasError = false;
        this.out.append("    Marking terminals:\n");
        for (CopperElementName n : bean.getMarkingTerminals()) {
            hasError |= bean.getMarkingTerminal(n).acceptVisitor(this).booleanValue();
        }
        this.out.append("\n    Bridge productions:\n");
        for (CopperElementName n : bean.getBridgeProductions()) {
            hasError |= bean.getBridgeProduction(n).acceptVisitor(this).booleanValue();
        }
        this.out.append("\n    Grammar layout:");
        if (bean.getGrammarLayout() == null) {
            this.out.append(" NONE\n");
        } else {
            for (CopperElementReference layout : bean.getGrammarLayout()) {
                this.out.append("\n      " + this.getName(layout));
            }
        }
        this.out.append("\n    Elements:\n");
        for (CopperElementName n : bean.getGrammarElements()) {
            hasError |= bean.getGrammarElement(n).acceptVisitor(this).booleanValue();
        }
        return hasError;
    }

    @Override
    public Boolean visitNonTerminal(NonTerminal bean) throws RuntimeException {
        this.out.append("      Nonterminal " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        return false;
    }

    @Override
    public Boolean visitParserAttribute(ParserAttribute bean) throws RuntimeException {
        this.out.append("      Parser attribute " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        this.out.append("        Type: " + bean.getAttributeType()).append("\n");
        return false;
    }

    @Override
    public Boolean visitParserBean(ParserBean bean) throws RuntimeException {
        this.currentParser = bean;
        this.out.append("Parser " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        this.out.append("  Package declaration: " + bean.getPackageDecl()).append("\n");
        this.out.append("  Class name: " + bean.getClassName()).append("\n");
        this.out.append("  Start symbol: " + this.getName(bean.getStartSymbol())).append("\n");
        this.out.append("  Start layout:");
        if (bean.getStartLayout() == null) {
            this.out.append(" NONE\n");
        } else {
            for (CopperElementReference layout : bean.getStartLayout()) {
                this.out.append("\n    " + this.getName(layout));
            }
        }
        this.out.append("\n  Grammars:");
        for (CopperElementName grammar : bean.getGrammars()) {
            this.out.append("\n    " + grammar);
        }
        this.out.append("\n");
        boolean hasError = false;
        for (CopperElementName n : bean.getGrammars()) {
            hasError |= bean.getGrammar(n).acceptVisitor(this).booleanValue();
        }
        this.currentParser = null;
        return hasError;
    }

    @Override
    public Boolean visitExtendedParserBean(ExtendedParserBean bean) throws RuntimeException {
        return this.visitParserBean(bean);
    }

    @Override
    public Boolean visitProduction(Production bean) throws RuntimeException {
        this.out.append("      Production: " + bean.getName() + " (" + bean.getDisplayName() + "), signature " + this.getName(bean.getLhs()) + " ::=");
        for (int i = 0; i < bean.getRhs().size(); ++i) {
            this.out.append(" ");
            if (bean.getRhsVarNames().get(i) != null) {
                this.out.append(bean.getRhsVarNames().get(i) + "::");
            }
            this.out.append(this.getName(bean.getRhs().get(i)));
        }
        this.out.append("\n");
        if (bean.getOperator() != null) {
            this.out.append("        Operator: " + this.getName(bean.getOperator())).append("\n");
        }
        if (bean.getPrecedenceClass() != null) {
            this.out.append("        Precedence class: " + this.getName(bean.getPrecedenceClass())).append("\n");
        }
        if (bean.getPrecedence() != null) {
            this.out.append("        Precedence: " + bean.getPrecedence()).append("\n");
        }
        return false;
    }

    @Override
    public Boolean visitTerminal(Terminal bean) throws RuntimeException {
        this.out.append("      Terminal: " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        this.out.append("        Regex: ");
        bean.getRegex().acceptVisitor(this);
        this.out.append("\n");
        this.out.append("        Operator precedence class:");
        if (bean.getOperatorClass() == null) {
            this.out.append(" NONE\n");
        } else {
            this.out.append(" " + this.getName(bean.getOperatorClass())).append("\n");
        }
        this.out.append("        Operator precedence:");
        if (bean.getOperatorPrecedence() == null) {
            this.out.append(" NONE\n");
        } else {
            this.out.append(" " + bean.getOperatorPrecedence()).append("\n");
        }
        this.out.append("        Operator associativity:");
        if (bean.getOperatorAssociativity() == null) {
            this.out.append(" NONE\n");
        } else {
            this.out.append(" " + (Object)((Object)bean.getOperatorAssociativity())).append("\n");
        }
        this.out.append("        Transparent prefix:");
        if (bean.getPrefix() == null) {
            this.out.append(" NONE\n");
        } else {
            this.out.append(" " + this.getName(bean.getPrefix())).append("\n");
        }
        this.out.append("        Terminal classes:");
        for (CopperElementReference member : bean.getTerminalClasses()) {
            this.out.append("\n          " + this.getName(member));
        }
        this.out.append("\n        Submit list:");
        for (CopperElementReference member : bean.getSubmitList()) {
            this.out.append("\n          " + this.getName(member));
        }
        this.out.append("\n        Dominate list:");
        for (CopperElementReference member : bean.getDominateList()) {
            this.out.append("\n          " + this.getName(member));
        }
        this.out.append("\n");
        return false;
    }

    @Override
    public Boolean visitTerminalClass(TerminalClass bean) throws RuntimeException {
        this.out.append("      Terminal class: " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        this.out.append("        Members:");
        for (CopperElementReference member : bean.getMembers()) {
            this.out.append("\n          " + this.getName(member));
        }
        this.out.append("\n");
        return false;
    }

    @Override
    public Boolean visitOperatorClass(OperatorClass bean) throws RuntimeException {
        this.out.append("      Operator class: " + bean.getName() + " (" + bean.getDisplayName() + ")\n");
        return false;
    }

    @Override
    public Boolean visitChoiceRegex(ChoiceRegex bean) throws RuntimeException {
        boolean first = true;
        if (bean.getSubexps().size() > 1) {
            this.out.append("(");
        }
        for (Regex subexp : bean.getSubexps()) {
            if (first) {
                first = false;
            } else {
                this.out.append("|");
            }
            subexp.acceptVisitor(this);
        }
        if (bean.getSubexps().size() > 1) {
            this.out.append(")");
        }
        return false;
    }

    @Override
    public Boolean visitConcatenationRegex(ConcatenationRegex bean) throws RuntimeException {
        for (Regex subexp : bean.getSubexps()) {
            subexp.acceptVisitor(this);
        }
        return false;
    }

    @Override
    public Boolean visitKleeneStarRegex(KleeneStarRegex bean) throws RuntimeException {
        if (!(bean.getSubexp() instanceof CharacterSetRegex)) {
            this.out.append("(");
        }
        bean.getSubexp().acceptVisitor(this);
        if (!(bean.getSubexp() instanceof CharacterSetRegex)) {
            this.out.append(")");
        }
        this.out.append("*");
        return false;
    }

    @Override
    public Boolean visitEmptyStringRegex(EmptyStringRegex bean) throws RuntimeException {
        return false;
    }

    @Override
    public Boolean visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws RuntimeException {
        this.out.append("[" + chars.toString() + "]");
        return false;
    }

    @Override
    public Boolean visitMacroHoleRegex(MacroHoleRegex bean) throws RuntimeException {
        this.out.append("[:" + this.getName(bean.getMacroName()) + ":]");
        return false;
    }

    private String getName(CopperElementReference ref) {
        if (this.currentParser.isUnitary()) {
            if (!ref.isFQ()) {
                return ref.getName().toString();
            }
            return ref.getName().toString();
        }
        if (!ref.isFQ()) {
            return this.currentGrammar.getDisplayName() + "$" + ref.getName();
        }
        return this.currentParser.getGrammar(ref.getGrammarName()).getDisplayName() + "$" + ref.getName();
    }
}

