/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.StateItem;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;
import java.util.Hashtable;

public class ProductionStepTables {
    protected Hashtable<StateItem, BitSet> prodTable;
    protected BitSet[][] revProdTable;

    public ProductionStepTables(LR0DFA dfa, ParserSpec spec, LRLookaheadSets lookaheadSets) {
        this.revProdTable = new BitSet[dfa.size()][];
        this.prodTable = new Hashtable();
        this.build(dfa, spec, lookaheadSets);
    }

    private void build(LR0DFA dfa, ParserSpec spec, LRLookaheadSets lookaheads) {
        for (int state = 0; state < dfa.size(); ++state) {
            BitSet[] closures = new BitSet[spec.terminals.size() + spec.nonterminals.size()];
            LR0ItemSet curr = dfa.getItemSet(state);
            for (int j = 0; j < curr.size(); ++j) {
                if (curr.getPosition(j) != 0 || curr.getProduction(j) == spec.getStartProduction()) continue;
                int lhs = spec.pr.getLHS(curr.getProduction(j));
                if (closures[lhs] == null) {
                    closures[lhs] = new BitSet();
                }
                closures[lhs].set(j);
            }
            this.revProdTable[state] = new BitSet[spec.nonterminals.size()];
            for (int item = 0; item < curr.size(); ++item) {
                int symbolAfterDot;
                int production = curr.getProduction(item);
                int dotPosition = curr.getPosition(item);
                if (spec.pr.getRHSLength(production) == dotPosition || spec.terminals.get(symbolAfterDot = spec.pr.getRHSSym(production, dotPosition)) || closures[symbolAfterDot] == null) continue;
                StateItem srcStateItem = new StateItem(state, curr.getProduction(item), curr.getPosition(item), lookaheads.getLookahead(state, item));
                if (this.prodTable.get(srcStateItem) == null) {
                    this.prodTable.put(srcStateItem, new BitSet());
                }
                if (this.revProdTable[state][symbolAfterDot] == null) {
                    this.revProdTable[state][symbolAfterDot] = new BitSet();
                }
                this.prodTable.get(srcStateItem).or(closures[symbolAfterDot]);
                this.revProdTable[state][symbolAfterDot].set(item);
            }
        }
    }

    public BitSet getProdSteps(StateItem stateItem) {
        return this.prodTable.get(stateItem);
    }

    public BitSet getRevProdSteps(int state, int nonTerminal) {
        return this.revProdTable[state][nonTerminal];
    }
}

