/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.FringeSymbols;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import java.util.ArrayList;

class ProductionData {
    private Symbol name;
    private NonTerminal leftSide;
    private ArrayList<GrammarSymbol> rightSide;
    private int precedenceIndex;
    private Terminal operator;

    public ProductionData(Symbol name, Terminal operator, NonTerminal leftSide, ArrayList<GrammarSymbol> rightSide) {
        this.name = name;
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.precedenceIndex = -1;
        if (operator == null) {
            int i = rightSide.size() - 1;
            for (i = rightSide.size() - 1; i >= 0; --i) {
                if (!(rightSide.get(i) instanceof Terminal)) continue;
                this.precedenceIndex = i;
                break;
            }
        }
        this.operator = operator;
    }

    public int length() {
        return this.rightSide.size();
    }

    public Symbol getName() {
        return this.name;
    }

    public NonTerminal getLeft() {
        return this.leftSide;
    }

    public Iterable<GrammarSymbol> getRight() {
        return this.rightSide;
    }

    public Terminal getPrecedenceSymbol() {
        if (this.precedenceIndex == -1) {
            if (this.operator == null) {
                return FringeSymbols.EMPTY;
            }
            return this.operator;
        }
        return (Terminal)this.rightSide.get(this.precedenceIndex);
    }

    public GrammarSymbol getSymbol(int index) {
        return this.rightSide.get(index);
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof ProductionData) {
            return this.leftSide.equals(((ProductionData)rhs).leftSide) && this.rightSide.equals(((ProductionData)rhs).rightSide);
        }
        return false;
    }

    public String toString() {
        String rv = this.leftSide + " ::=";
        for (GrammarSymbol gs : this.rightSide) {
            rv = rv + " " + gs;
        }
        return rv;
    }

    public int hashCode() {
        String rv = this.leftSide.toString();
        for (GrammarSymbol gs : this.rightSide) {
            rv = rv + " " + gs;
        }
        return rv.hashCode();
    }
}

