/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.runtime.io.Location;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;

public abstract class CopperASTBean
implements Serializable {
    private static final long serialVersionUID = -418152045341686348L;
    protected CopperElementType type;
    protected CopperElementName name;
    protected String displayName;
    protected Location location;

    protected CopperASTBean(CopperElementType type) {
        this.type = type;
        this.name = null;
        this.location = null;
        this.displayName = null;
    }

    public CopperElementType getType() {
        return this.type;
    }

    public CopperElementName getName() {
        return this.name;
    }

    public void setName(CopperElementName name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) throws ParseException {
        if (this.name == null) {
            this.name = CopperElementName.newName(name);
        }
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.name != null) {
            return this.name.toString();
        }
        return "null";
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (this.location == null) {
            this.location = location;
        }
    }

    public boolean isComplete() {
        return this.name != null && this.location != null;
    }

    public Set<String> whatIsMissing() {
        HashSet<String> rv = new HashSet<String>();
        if (this.name == null) {
            rv.add("name");
        }
        if (this.location == null) {
            rv.add("location");
        }
        return rv;
    }

    public abstract <RT, E extends Exception> RT acceptVisitor(CopperASTBeanVisitor<RT, E> var1) throws E;
}

