/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanComparator;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.PlaceholderBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public class SymbolTableBuilder
implements CopperASTBeanVisitor<PSSymbolTable, RuntimeException> {
    private SortedSet<CopperASTBean> terminals;
    private SortedSet<CopperASTBean> nonterminals;
    private SortedSet<CopperASTBean> productions;
    private SortedSet<CopperASTBean> disambiguationFunctions;
    private SortedSet<CopperASTBean> terminalClasses;
    private SortedSet<CopperASTBean> operatorClasses;
    private SortedSet<CopperASTBean> parserAttributes;
    private SortedSet<CopperASTBean> grammars;

    public static PSSymbolTable build(ParserBean spec) {
        return spec.acceptVisitor(new SymbolTableBuilder());
    }

    private SymbolTableBuilder() {
    }

    @Override
    public PSSymbolTable visitDisambiguationFunction(DisambiguationFunction bean) throws RuntimeException {
        this.disambiguationFunctions.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitGrammar(Grammar bean) throws RuntimeException {
        for (CopperElementName n : bean.getGrammarElements()) {
            bean.getGrammarElement(n).acceptVisitor(this);
        }
        this.grammars.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitExtensionGrammar(ExtensionGrammar bean) throws RuntimeException {
        this.visitGrammar(bean);
        for (CopperElementName n : bean.getMarkingTerminals()) {
            bean.getMarkingTerminal(n).acceptVisitor(this);
        }
        for (CopperElementName n : bean.getBridgeProductions()) {
            bean.getBridgeProduction(n).acceptVisitor(this);
        }
        return null;
    }

    @Override
    public PSSymbolTable visitNonTerminal(NonTerminal bean) throws RuntimeException {
        this.nonterminals.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitParserAttribute(ParserAttribute bean) throws RuntimeException {
        this.parserAttributes.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitParserBean(ParserBean bean) throws RuntimeException {
        this.terminals = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.nonterminals = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.productions = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.disambiguationFunctions = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.terminalClasses = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.operatorClasses = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.parserAttributes = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        this.grammars = new TreeSet<CopperASTBean>(CopperASTBeanComparator.C);
        for (CopperElementName n : bean.getGrammars()) {
            bean.getGrammar(n).acceptVisitor(this);
        }
        ArrayList<CopperASTBean> symbolList = new ArrayList<CopperASTBean>();
        symbolList.add(PlaceholderBean.EOF);
        symbolList.addAll(this.terminals);
        symbolList.add(PlaceholderBean.STARTPRIME);
        symbolList.addAll(this.nonterminals);
        symbolList.add(PlaceholderBean.STARTPROD);
        symbolList.addAll(this.productions);
        symbolList.addAll(this.disambiguationFunctions);
        symbolList.addAll(this.terminalClasses);
        symbolList.addAll(this.operatorClasses);
        symbolList.addAll(this.parserAttributes);
        symbolList.addAll(this.grammars);
        symbolList.add(bean);
        return new PSSymbolTable((Collection<CopperASTBean>)symbolList);
    }

    @Override
    public PSSymbolTable visitExtendedParserBean(ExtendedParserBean bean) throws RuntimeException {
        return this.visitParserBean(bean);
    }

    @Override
    public PSSymbolTable visitProduction(Production bean) throws RuntimeException {
        this.productions.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitTerminal(Terminal bean) throws RuntimeException {
        this.terminals.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitTerminalClass(TerminalClass bean) throws RuntimeException {
        this.terminalClasses.add(bean);
        return null;
    }

    @Override
    public PSSymbolTable visitOperatorClass(OperatorClass bean) throws RuntimeException {
        this.operatorClasses.add(bean);
        return null;
    }
}

