/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.Lazy;
import common.StringCatter;
import common.TypeRep;
import common.exceptions.SilverError;
import java.util.HashMap;
import java.util.Map;
import silver.core.NAST;
import silver.core.NLocation;

public final class RTTIManager {
    private static final int estimateProductionCount = 4096;
    private static final int estimateNonterminalCount = 512;
    private static final int estimateTerminalCount = 512;
    private static final Map<String, Prodleton<?>> productionsByName = new HashMap(4096, 0.5f);
    private static final Map<String, Nonterminalton<?>> nonterminalsByName = new HashMap(512, 0.5f);
    private static final Map<String, Terminalton<?>> terminalsByName = new HashMap(512, 0.5f);

    public static void registerNonterminal(Nonterminalton<?> nton) {
        nonterminalsByName.put(nton.getName(), nton);
    }

    public static Nonterminalton<?> getNonterminalton(String name) {
        return nonterminalsByName.get(name);
    }

    public static void registerProduction(Prodleton<?> pton) {
        productionsByName.put(pton.getName(), pton);
    }

    public static Prodleton<?> getProdleton(String name) {
        return productionsByName.get(name);
    }

    public static void registerTerminal(Terminalton<?> tton) {
        terminalsByName.put(tton.getName(), tton);
    }

    public static Terminalton<?> getTerminalton(String name) {
        return terminalsByName.get(name);
    }

    public static void registerOccurs(String nt, String attr, boolean isInherited, int index) {
        Nonterminalton<?> ntton = RTTIManager.getNonterminalton(nt);
        if (isInherited) {
            ((Nonterminalton)ntton).inhOccursIndices.put(attr, index);
        } else {
            ((Nonterminalton)ntton).synOccursIndices.put(attr, index);
        }
    }

    public static abstract class Nonterminalton<T> {
        private final Map<String, Integer> inhOccursIndices = new HashMap<String, Integer>(16, 0.5f);
        private final Map<String, Integer> synOccursIndices = new HashMap<String, Integer>(16, 0.5f);

        public abstract String getName();

        public final boolean hasInh(String attrName) {
            return this.inhOccursIndices.containsKey(attrName);
        }

        public final boolean hasSyn(String attrName) {
            return this.synOccursIndices.containsKey(attrName);
        }

        public final int getInhOccursIndex(String attrName) {
            if (!this.hasInh(attrName)) {
                throw new SilverError("Attribute " + attrName + " does not occur on " + this.getName() + ".");
            }
            return this.inhOccursIndices.get(attrName);
        }

        public final int getSynOccursIndex(String attrName) {
            if (!this.hasSyn(attrName)) {
                throw new SilverError("Attribute " + attrName + " does not occur on " + this.getName() + ".");
            }
            return this.synOccursIndices.get(attrName);
        }
    }

    public static abstract class Prodleton<T> {
        public abstract T reify(NAST var1, ConsCell var2, TypeRep var3, NAST[] var4, String[] var5, NAST[] var6);

        public abstract T constructDirect(Object[] var1, Object[] var2);

        public abstract String getName();

        public abstract Nonterminalton<? super T> getNonterminalton();

        public abstract String getTypeUnparse();

        public abstract int getChildCount();

        public abstract int getAnnoCount();

        public abstract String[] getChildNames();

        public abstract String[] getChildTypes();

        public abstract Lazy[][] getChildInheritedAttributes();
    }

    public static abstract class Terminalton<T> {
        public abstract T construct(StringCatter var1, NLocation var2);

        public abstract String getName();
    }
}

