/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AppTypeRep;
import common.BaseTypeRep;
import common.Reflection;
import common.Thunk;
import common.TypeRep;
import common.Typed;
import common.VarTypeRep;
import common.exceptions.SilverError;
import common.exceptions.SilverException;
import common.exceptions.SilverInternalError;
import common.exceptions.TraceException;
import java.util.LinkedList;
import java.util.List;

public class ConsCell
implements Typed {
    public static final ConsCell nil = new NilConsCell();
    protected Object head;
    protected Object tail;

    public ConsCell(Object h, Object t) {
        this.head = h;
        this.tail = t;
    }

    public static <T> ConsCell fromList(List<T> l) {
        ConsCell cons = nil;
        while (l.size() > 0) {
            T val = l.remove(l.size() - 1);
            cons = new ConsCell(val, cons);
        }
        return cons;
    }

    public static <T> List<T> toList(ConsCell cons) {
        LinkedList<Object> lst = new LinkedList<Object>();
        while (!cons.nil()) {
            Object val = cons.head();
            cons = cons.tail();
            lst.add(val);
        }
        return lst;
    }

    public Object head() {
        if (this.head instanceof Thunk) {
            this.head = ((Thunk)this.head).eval();
        }
        return this.head;
    }

    public ConsCell tail() {
        if (this.tail instanceof Thunk) {
            this.tail = ((Thunk)this.tail).eval();
        }
        return (ConsCell)this.tail;
    }

    public boolean nil() {
        return false;
    }

    public int length() {
        return 1 + this.tail().length();
    }

    @Override
    public AppTypeRep getType() {
        try {
            AppTypeRep tailType = this.tail().getType();
            if (!TypeRep.unify(tailType.arg, Reflection.getType(this.head()))) {
                throw new SilverInternalError("Unification failed.");
            }
            return tailType;
        }
        catch (SilverException e) {
            throw new TraceException("While constructing type of list", e);
        }
    }

    protected static class NilConsCell
    extends ConsCell {
        public NilConsCell() {
            super(null, null);
        }

        @Override
        public Object head() {
            throw new SilverError("Requested head of nil.");
        }

        @Override
        public boolean nil() {
            return true;
        }

        @Override
        public ConsCell tail() {
            throw new SilverError("Requested tail of nil.");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public AppTypeRep getType() {
            return new AppTypeRep(new BaseTypeRep("[]"), new VarTypeRep());
        }
    }
}

