/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.wizard;

import common.ConsCell;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import edu.umn.cs.melt.ide.wizard.NewSourceFilePage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewSourceFileWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private String EXT = "." + SVRegistry.get().fileExtension();
    private NewSourceFilePage page1;

    public NewSourceFileWizard() {
        this.setWindowTitle(SVRegistry.get().name());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        IStructuredSelection selection = (IStructuredSelection)service.getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        String name = SVRegistry.get().name();
        this.page1 = new NewSourceFilePage("New " + name + " Source File Wizard", selection);
        this.page1.setTitle(String.valueOf(name) + " Source File");
        this.page1.setDescription("Create new " + name + " source file");
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        if (!this.page1.attemptCompletion()) {
            return false;
        }
        String name = String.valueOf(this.page1.getFileName()) + this.EXT;
        IResource parent = this.page1.getParentFolder();
        IFile file = null;
        file = parent instanceof IProject ? ((IProject)parent).getFile(name) : ((IFolder)parent).getFile(name);
        if (!file.exists()) {
            try {
                ConsCell properties = this.page1.getNIdePerpertyArray();
                String stub = SVRegistry.get().fileStub(properties).toString();
                file.create((InputStream)new ByteArrayInputStream(stub.getBytes()), false, null);
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorDescriptor desc = workbench.getEditorRegistry().getDefaultEditor(file.getName());
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                return true;
            }
            catch (CoreException e) {
                this.page1.setErrorMessage(e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.page1.setErrorMessage("A source file with same name exists already.");
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

