/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class CompilerLogHandler
extends Handler {
    public static final int SORT = 0;
    public static final int LOCATION = 1;
    public static final int FAIL_REQUIRED = 2;
    public static final int MIN_SIZE = 3;
    private Queue<CompilerLogMessage> messageQueue = new LinkedList<CompilerLogMessage>();
    private Queue<CompilerLogMessage> tickQueue = new LinkedList<CompilerLogMessage>();

    public Queue<CompilerLogMessage> getMessageQueue() {
        return this.messageQueue;
    }

    public Queue<CompilerLogMessage> flushMessageQueue() {
        Queue<CompilerLogMessage> rv = this.getMessageQueue();
        this.messageQueue = new LinkedList<CompilerLogMessage>();
        return rv;
    }

    public Queue<CompilerLogMessage> getTickQueue() {
        return this.tickQueue;
    }

    public Queue<CompilerLogMessage> flushTickQueue() {
        Queue<CompilerLogMessage> rv = this.getTickQueue();
        this.tickQueue = new LinkedList<CompilerLogMessage>();
        return rv;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord arg0) {
        String newMessage = arg0.getMessage();
        Object[] newParams = arg0.getParameters();
        if (newParams.length < 3 || !(newParams[0] instanceof CompilerLogMessageSort) || !(newParams[2] instanceof Boolean)) {
            this.messageQueue.offer(new CompilerLogMessage(arg0.getSequenceNumber(), arg0.getMillis(), "Malformed log message\n", new Object[]{CompilerLogMessageSort.ERROR, null, true}));
        } else {
            Queue<CompilerLogMessage> destQueue;
            switch ((CompilerLogMessageSort)((Object)newParams[0])) {
                case TICK: {
                    destQueue = this.tickQueue;
                    break;
                }
                default: {
                    destQueue = this.messageQueue;
                }
            }
            destQueue.offer(new CompilerLogMessage(arg0.getSequenceNumber(), arg0.getMillis(), newMessage, newParams));
        }
    }
}

