/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.main;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.pipeline.AuxiliaryMethods;
import edu.umn.cs.melt.copper.compiletime.pipeline.Pipeline;
import edu.umn.cs.melt.copper.compiletime.pipeline.StandardPipeline;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.ParserSpecProcessor;
import edu.umn.cs.melt.copper.main.CopperDumpControl;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import edu.umn.cs.melt.copper.main.CopperEngineType;
import edu.umn.cs.melt.copper.main.CopperIOType;
import edu.umn.cs.melt.copper.main.CopperPipelineType;
import edu.umn.cs.melt.copper.main.CopperSkinType;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

public class ParserCompiler {
    public static final String VERSION;
    public static final String BUILD;

    private static void versionMessage(ParserCompilerParameters args) {
        System.err.println("Copper version " + VERSION);
        System.exit(0);
    }

    private static String usageMessage(ParserCompilerParameters args) {
        String customs;
        String rv = "";
        rv = rv + "Usage: ParserCompiler [built-in-switches] [custom-switches] spec-file1 spec-file2 ... spec-filen\n";
        rv = rv + "Built-in switches (all optional) are:\n";
        rv = rv + "\t-?\tDisplay this usage information.\n\t\tUse ParserCompiler -pipeline [pipeline] -? to list\n\t\toptions specific to a given pipeline.\n";
        rv = rv + "\t-version\tDisplay version information.\n";
        rv = rv + "\t-package [package]\tThe package of the generated parser.\n\t\tDefaults to the default package or what is set in\n\t\tthe parser specification.\n";
        rv = rv + "\t-parser [class]\tThe class name of the generated parser.\n\t\tDefaults to 'Parser' or what is set in\n\t\tthe parser specification.\n";
        rv = rv + "\t-o [out]\tOutput the generated parser or fragment to the file 'out'.\n\t\tUse '-' to redirect to standard output, or no parameter\n\t\tto suppress output altogether.\n";
        rv = rv + "\t-q\t\tRun the compiler quietly.\n";
        rv = rv + "\t-v\t\tRun the compiler with extra verbosity.\n";
        rv = rv + "\t-vv\t\tRun the compiler with even more extra verbosity.\n";
        rv = rv + "\t-mda\tRun Copper's modular determinism analysis on the input.\n\t\t\tIf this switch is used, the input must comprise exactly\n\t\t\ttwo grammars: the host and an extension to test.\n";
        rv = rv + "\t-avoidRecompile\tRun Copper only if one spec-file has a later\n\t\t\tmodification time than the output file.\n\t\t\tIf this switch is used, an output file must also\n\t\t\tbe specified.\n";
        rv = rv + "\t-logfile [lout]\tPipe all log output to the file 'lout'\n\t\t\t(default standard error).\n";
        rv = rv + "\t-dot [dout]\tOutput dot markup code representing any counterexamples to 'dout'\n\t\t\t(no dot output if not provided).\n";
        rv = rv + "\t-cc\t\tUse ANSI color escape sequences in log output, even when logging to a file\n";
        rv = rv + "\t-nc\t\tSuppress ANSI color in log output, even when logging to the terminal\n";
        rv = rv + "\t-dump\tProduce a detailed report of the grammar and generated parser.\n";
        rv = rv + "\t-errordump\tProduce a detailed report, but only if the parser\n\t\t\tcompiler has generated an error.\n";
        rv = rv + "\t-dumpfile [dout]\tPipe the dumped report to the file 'dout'\n\t\t\t\t(default to log output).\n";
        rv = rv + "\t-dumptype [type]\tGenerate the dumped report in the\n\t\t\t\tspecified format:\n";
        for (String dt : CopperDumpType.strings()) {
            rv = rv + "\t\t" + dt + ": " + CopperDumpType.fromString(dt).usageMessage() + "\n";
        }
        rv = rv + "\t-skin [skin]\tGenerate a parser based on input from the specified\n\t\t\tinput skin:\n";
        for (String st : CopperSkinType.strings()) {
            rv = rv + "\t\t" + st + ": " + CopperSkinType.fromString(st).usageMessage() + "\n";
        }
        rv = rv + "\t-engine [eng]\tGenerate a parser based on the specified parsing engine:\n";
        for (String et : CopperEngineType.strings()) {
            rv = rv + "\t\t" + et + ": " + CopperEngineType.fromString(et).usageMessage() + "\n";
        }
        rv = rv + "\t-pipeline [pipe]\tGenerate a parser using the specified\n\t\t\t\tcompilation \"pipeline\":\n";
        for (String pt : CopperPipelineType.strings()) {
            rv = rv + "\t\t" + pt + ": " + CopperPipelineType.fromString(pt).usageMessage() + "\n";
        }
        if (args != null && args.getPipeline() != null && (customs = args.getPipeline().customSwitchUsage()) != null && !customs.equals("") && !customs.equals("null")) {
            rv = rv + "\nCustom switches specific to the given pipeline configuration are:\n";
            rv = rv + customs;
        }
        return rv;
    }

    private static void usageMessageNoError(ParserCompilerParameters args) {
        System.err.println(ParserCompiler.usageMessage(args));
        System.exit(0);
    }

    private static void usageMessageError(ParserCompilerParameters args) {
        System.err.println(ParserCompiler.usageMessage(args));
        System.exit(1);
    }

    public static CopperEngineType getDefaultEngine() {
        return CopperEngineType.SINGLE;
    }

    public static CopperSkinType getDefaultSkin() {
        return CopperSkinType.CUP;
    }

    public static CopperDumpType getDefaultDumpType() {
        return CopperDumpType.PLAIN;
    }

    public static CompilerLevel getDefaultQuietLevel() {
        return CompilerLevel.REGULAR;
    }

    public static CopperPipelineType getDefaultPipeline() {
        return CopperPipelineType.GRAMMARBEANS;
    }

    public static int compile(ParserBean spec, ParserCompilerParameters args) throws CopperException {
        CompilerLogger logger = AuxiliaryMethods.getOrMakeLogger(args);
        if (args.getInputs() != null) {
            if (logger.isLoggable(CompilerLevel.QUIET)) {
                logger.log(new GenericMessage(CompilerLevel.QUIET, "Input files cannot be specified when compiling a parser from Java objects"));
            }
            return 1;
        }
        ParserSpecProcessor.normalizeParser(spec, logger);
        return ParserCompiler.compileParser(args, spec);
    }

    private static int compileParser(ParserCompilerParameters args, ParserBean spec) throws CopperException {
        if (args.getUsePipeline() != CopperPipelineType.GRAMMARBEANS) {
            return 1;
        }
        return ((StandardPipeline)CopperPipelineType.GRAMMARBEANS.getPipeline(args)).execute(spec, args);
    }

    public static int compile(ParserCompilerParameters args) throws IOException, CopperException {
        return args.getPipeline().execute(args);
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 1) {
            ParserCompiler.usageMessageError(null);
        } else if (args.length == 1 && args[0].equals("-?")) {
            ParserCompiler.usageMessageNoError(null);
        }
        CompilerLevel quietLevel = ParserCompiler.getDefaultQuietLevel();
        boolean colorExample = false;
        boolean noColorExample = false;
        boolean displayHelp = false;
        boolean displayVersion = false;
        boolean runMDA = false;
        boolean avoidRecompile = false;
        CopperDumpControl dumpControl = CopperDumpControl.OFF;
        CopperDumpType.initTable();
        CopperDumpType dumpFormat = ParserCompiler.getDefaultDumpType();
        CopperEngineType.initTable();
        CopperEngineType useEngine = ParserCompiler.getDefaultEngine();
        CopperSkinType.initTable();
        CopperSkinType useSkin = ParserCompiler.getDefaultSkin();
        CopperPipelineType.initTable();
        CopperPipelineType usePipeline = ParserCompiler.getDefaultPipeline();
        String logFile = null;
        String dumpFile = "";
        String packageDecl = null;
        String parserName = null;
        String output = null;
        String dotOutput = null;
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("-?")) {
                displayHelp = true;
                continue;
            }
            if (args[i].equals("-version")) {
                displayVersion = true;
                continue;
            }
            if (args[i].equals("-o")) {
                if (++i == args.length) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                output = args[i];
                continue;
            }
            if (args[i].equals("-nc")) {
                noColorExample = true;
                continue;
            }
            if (args[i].equals("-cc")) {
                colorExample = true;
                continue;
            }
            if (args[i].equals("-dot")) {
                if (++i == args.length) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                dotOutput = args[i];
                continue;
            }
            if (args[i].equals("-q")) {
                quietLevel = CompilerLevel.QUIET;
                continue;
            }
            if (args[i].equals("-v")) {
                quietLevel = CompilerLevel.VERBOSE;
                continue;
            }
            if (args[i].equals("-vv")) {
                quietLevel = CompilerLevel.VERY_VERBOSE;
                continue;
            }
            if (args[i].equals("-dump")) {
                dumpControl = CopperDumpControl.ON;
                continue;
            }
            if (args[i].equals("-errordump")) {
                dumpControl = CopperDumpControl.ERROR_ONLY;
                continue;
            }
            if (args[i].equals("-skin")) {
                if (++i == args.length || !CopperSkinType.contains(args[i])) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                useSkin = CopperSkinType.fromString(args[i]);
                continue;
            }
            if (args[i].equals("-engine")) {
                if (++i == args.length || !CopperEngineType.contains(args[i])) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                useEngine = CopperEngineType.fromString(args[i]);
                continue;
            }
            if (args[i].equals("-pipeline")) {
                if (++i == args.length || !CopperPipelineType.contains(args[i])) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                usePipeline = CopperPipelineType.fromString(args[i]);
                continue;
            }
            if (args[i].equals("-mda")) {
                runMDA = true;
                continue;
            }
            if (args[i].equals("-logfile")) {
                if (++i == args.length) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                logFile = args[i];
                continue;
            }
            if (args[i].equals("-dumpfile")) {
                if (++i == args.length) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                dumpFile = args[i];
                continue;
            }
            if (args[i].equals("-dumptype")) {
                if (++i == args.length || !CopperDumpType.contains(args[i])) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                dumpFormat = CopperDumpType.fromString(args[i]);
                continue;
            }
            if (args[i].equals("-avoidRecompile")) {
                avoidRecompile = true;
                continue;
            }
            if (args[i].equals("-package")) {
                if (++i == args.length) {
                    ParserCompiler.usageMessageError(null);
                    continue;
                }
                packageDecl = args[i];
                continue;
            }
            if (!args[i].equals("-parser")) break;
            if (++i == args.length) {
                ParserCompiler.usageMessageError(null);
                continue;
            }
            parserName = args[i];
        }
        ParserCompilerParameters argTable = new ParserCompilerParameters();
        argTable.setQuietLevel(quietLevel);
        argTable.setRunMDA(runMDA);
        argTable.setAvoidRecompile(avoidRecompile);
        argTable.setDump(dumpControl);
        argTable.setUseEngine(useEngine);
        argTable.setUseSkin(useSkin);
        argTable.setUsePipeline(usePipeline);
        argTable.setDumpFormat(dumpFormat);
        argTable.setPackageName(packageDecl);
        argTable.setParserName(parserName);
        if (logFile != null && !colorExample || noColorExample) {
            argTable.setColorCounterexample(false);
        } else {
            argTable.setColorCounterexample(true);
        }
        if (output == null) {
            argTable.setOutputType(null);
        } else if (!output.equals("-")) {
            argTable.setOutputType(CopperIOType.FILE);
            argTable.setOutputFile(new File(output));
        } else {
            argTable.setOutputType(CopperIOType.STREAM);
            argTable.setOutputStream(System.out);
        }
        if (logFile == null || logFile.equals("-")) {
            argTable.setLogType(CopperIOType.STREAM);
            argTable.setLogStream(System.err);
        } else {
            argTable.setLogType(CopperIOType.FILE);
            argTable.setLogFile(new File(logFile));
        }
        if (dotOutput == null) {
            argTable.setDotOutput(null);
        } else {
            argTable.setDotOutput(new File(dotOutput));
        }
        if (dumpFile == null || dumpFile.equals("")) {
            argTable.setDumpOutputType(argTable.getLogType());
            argTable.setDumpStream(argTable.getLogStream());
            argTable.setDumpFile(argTable.getLogFile());
        } else if (dumpFile.equals("-")) {
            argTable.setDumpOutputType(CopperIOType.STREAM);
            argTable.setDumpStream(System.err);
        } else {
            argTable.setDumpOutputType(CopperIOType.FILE);
            argTable.setDumpFile(new File(dumpFile));
        }
        Pipeline pipeline = argTable.getPipeline();
        if (displayHelp) {
            ParserCompiler.usageMessageNoError(argTable);
        } else if (displayVersion) {
            ParserCompiler.versionMessage(argTable);
        } else if (i >= args.length) {
            ParserCompiler.usageMessageError(null);
        }
        if (args[i].startsWith("-")) {
            while (i >= 0 && i < args.length && args[i].charAt(0) == '-') {
                i = pipeline.processCustomSwitch(argTable, args, i);
            }
        }
        if (i == -1 || i >= args.length) {
            ParserCompiler.usageMessageError(argTable);
        }
        ArrayList<Pair<String, Object>> files = new ArrayList<Pair<String, Object>>();
        while (i < args.length) {
            files.add(Pair.cons(args[i], args[i]));
            ++i;
        }
        argTable.setInputs(files);
        int errorlevel = 1;
        try {
            errorlevel = ParserCompiler.compile(argTable);
            AuxiliaryMethods.getOrMakeLogger(argTable).flush();
        }
        catch (IOException ex) {
            if (quietLevel == CompilerLevel.VERY_VERBOSE) {
                ex.printStackTrace();
            }
            System.err.println("I/O error: " + ex.getMessage());
        }
        catch (Exception ex) {
            if (quietLevel == CompilerLevel.VERY_VERBOSE) {
                ex.printStackTrace();
            }
            System.err.println("An unexpected fatal error has occurred. Run with -vv for debug information.");
        }
        System.exit(errorlevel);
    }

    static {
        Properties p = new Properties();
        try {
            InputStream manifest = ParserCompiler.class.getClassLoader().getResourceAsStream("resources/edu/umn/cs/melt/copper/compiletime/Copper.properties");
            if (manifest == null) {
                manifest = ParserCompiler.class.getClassLoader().getResourceAsStream("Build.properties");
            }
            if (manifest != null) {
                InputStreamReader propertiesReader = new InputStreamReader(manifest);
                p.load(propertiesReader);
            }
        }
        catch (IOException manifest) {
            // empty catch block
        }
        String version = p.getProperty("Version");
        String build = p.getProperty("Build");
        VERSION = version == null || !version.matches("[0-9\\.]+(-[A-Za-z0-9]+)?") ? "unknown" : version;
        BUILD = build == null || !build.matches("[0-9]{8}-[0-9]{4}") ? "unknown" : build;
    }
}

