/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CMDContextVisualization;
import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.RTTIManager;
import common.TopNode;
import common.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Stack;

public class Debug {
    private DecoratedNode root;
    private DecoratedNode currentNode;
    private Stack<DecoratedNode> nodeStack;
    HashMap<Integer, StringObjectPair> currentNodeSynthAttrs;
    HashMap<Integer, StringObjectPair> currentNodeInhAttrs;
    HashMap<Integer, StringObjectPair> currentNodeLocalAttrs;
    private int currentLine;
    private int currentColumn;

    public static DecoratedNode runDebug(DecoratedNode tree) {
        Debug debug = new Debug();
        debug.runingDebug(tree);
        return tree;
    }

    public void runingDebug(DecoratedNode tree) {
        Scanner inp = new Scanner(System.in);
        System.out.println("Enter characters, and 'q' to quit.");
        boolean toggleProdDisplay = true;
        boolean toggleHeadlessAttributes = true;
        this.root = tree;
        this.currentNode = tree;
        this.nodeStack = new Stack();
        if (toggleProdDisplay) {
            this.printProduction(this.currentNode);
        }
        CMDContextVisualization cStack = new CMDContextVisualization("********************************");
        cStack.push(this.currentNode);
        cStack.show();
        block40: while (true) {
            System.out.print(">DEBUGGER-PROMPT$");
            String userInput = inp.nextLine();
            String[] userInputList = userInput.split(" ");
            switch (userInputList[0]) {
                case "up": 
                case "u": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: up<>");
                        continue block40;
                    }
                    if (this.currentNode.getParent().getParent() instanceof TopNode || this.currentNode.getParent() == null) {
                        System.out.println("Root Node has no parent");
                        continue block40;
                    }
                    if (this.currentNode.getParent() == null) {
                        System.out.println("Null parent");
                        continue block40;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = this.currentNode.getParent();
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.pop();
                    cStack.show();
                    continue block40;
                }
                case "down": 
                case "d": {
                    int childNum = 0;
                    if (userInputList.length != 2) {
                        System.out.println("Which child?");
                        this.printChildren(this.currentNode);
                        System.out.print("     $");
                        childNum = inp.nextInt();
                        inp.nextLine();
                    } else {
                        childNum = Integer.parseInt(userInputList[1]);
                    }
                    DecoratedNode childNode = this.down(childNum);
                    if (childNode == null) {
                        System.out.println("invalid child number");
                        continue block40;
                    }
                    this.nodeStack.push(this.currentNode);
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    cStack.show();
                    continue block40;
                }
                case "undo": {
                    DecoratedNode newNode;
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: undo<>");
                        continue block40;
                    }
                    if (this.nodeStack.empty()) {
                        System.out.println("invalid no node to undo");
                        continue block40;
                    }
                    this.currentNode = newNode = this.nodeStack.pop();
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.pop();
                    cStack.show();
                    continue block40;
                }
                case "forwards": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: forwards<>");
                        continue block40;
                    }
                    DecoratedNode childNode = this.forwards(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to forward");
                        continue block40;
                    }
                    System.out.println("going forward");
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    cStack.show();
                    continue block40;
                }
                case "backtrack": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: backtrack<>");
                        continue block40;
                    }
                    DecoratedNode childNode = this.backtrack(this.currentNode);
                    if (childNode == null) {
                        System.out.println("invalid no node to backtrack to");
                        continue block40;
                    }
                    System.out.println("going backwrds");
                    this.currentNode = childNode;
                    if (toggleProdDisplay) {
                        this.printProduction(this.currentNode);
                    }
                    cStack.push(this.currentNode);
                    cStack.show();
                    continue block40;
                }
                case "toggle": {
                    if (userInputList.length != 2) {
                        System.out.println("please indicate what you want to toggle ex: 'toggle prodDisplay'");
                        continue block40;
                    }
                    if (userInputList[1].equals("prodDisplay")) {
                        if (toggleProdDisplay) {
                            System.out.println("Production Display off");
                            toggleProdDisplay = false;
                        } else {
                            System.out.println("Production Display on");
                            toggleProdDisplay = true;
                        }
                    }
                    if (userInputList[1].equals("fullAttributeNames")) {
                        if (toggleHeadlessAttributes) {
                            System.out.println("Headless Attributes off");
                            toggleHeadlessAttributes = false;
                            continue block40;
                        }
                        System.out.println("Headless Attributes on");
                        toggleHeadlessAttributes = true;
                        continue block40;
                    }
                    System.out.println("legal toggles: prodDisplay, fullAttributeNames");
                    continue block40;
                }
                case "prod": {
                    if (userInputList.length != 1) {
                        System.out.println("invalid, correct usage: prod<>");
                        continue block40;
                    }
                    this.printProduction(this.currentNode);
                    continue block40;
                }
                case "eq": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: eq<attr?>");
                        continue block40;
                    }
                    System.out.println("do the eq stuff");
                    continue block40;
                }
                case "listSynth": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listSynth<node?>");
                        continue block40;
                    }
                    if (this.listSynth(this.currentNode) != 0) continue block40;
                    System.out.println("no synthesized attributes");
                    continue block40;
                }
                case "listInher": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: listInher<node?>");
                        continue block40;
                    }
                    if (this.listInher(this.currentNode) != 0) continue block40;
                    System.out.println("no inherited attributes");
                    continue block40;
                }
                case "list": 
                case "l": {
                    if (userInputList.length != 1 && userInputList.length != 2) {
                        System.out.println("invalid, correct usage: list<node?>");
                        continue block40;
                    }
                    this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                    continue block40;
                }
                case "view": 
                case "v": {
                    String attributeName = "";
                    Integer attributeNum = 0;
                    List<String> attributeList = Debug.allAttributesList(this.currentNode);
                    if (userInputList.length != 2) {
                        System.out.println("Which attribute?");
                        this.printAttributes(this.currentNode, toggleHeadlessAttributes);
                        System.out.print("     $");
                        attributeNum = inp.nextInt();
                        inp.nextLine();
                        attributeName = attributeList.get(attributeNum);
                    } else {
                        attributeNum = Integer.parseInt(userInputList[1]);
                        attributeName = attributeList.get(attributeNum);
                    }
                    this.printAttrFromName(this.currentNode, attributeName);
                    continue block40;
                }
                case "local": {
                    Debug.listLocalAttrs(this.currentNode);
                    continue block40;
                }
                case "help": {
                    System.out.println("up");
                    System.out.println("down <node>");
                    System.out.println("view <attr>");
                    System.out.println("forwards");
                    System.out.println("backtrack");
                    System.out.println("prod");
                    System.out.println("eq");
                    System.out.println("listSynth");
                    System.out.println("listInher");
                    System.out.println("list");
                    System.out.println("exit");
                    continue block40;
                }
                case "exit": 
                case "q": 
                case "quit": {
                    System.out.println("debugger out");
                    break block40;
                }
                default: {
                    System.out.println("invalid input call help for legal inputs");
                    System.out.println(userInput);
                    continue block40;
                }
            }
            break;
        }
    }

    public void setCurrentNode(DecoratedNode node) {
        this.currentNodeSynthAttrs = null;
        this.currentNodeInhAttrs = null;
        this.currentNodeLocalAttrs = null;
        this.currentNode = node;
    }

    public DecoratedNode up() {
        if (this.currentNode.getParent() != null) {
            this.currentNode = this.currentNode.getParent();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode down(int child) {
        if (this.currentNode.getNode().getNumberOfChildren() > child) {
            DecoratedNode childNode = this.currentNode.childDecorated(child);
            return childNode;
        }
        return null;
    }

    public void printChildren(DecoratedNode node) {
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.println(Integer.toString(i) + ": " + child_productions[i] + " ");
        }
    }

    public DecoratedNode forwards(DecoratedNode node) {
        if (node.getNode().hasForward()) {
            this.currentNode = node.forward();
            return this.currentNode;
        }
        return null;
    }

    public DecoratedNode backtrack(DecoratedNode node) {
        this.currentNode = node.getForwardParent();
        return this.currentNode;
    }

    public void printProduction(DecoratedNode node) {
        String partent_production = node.undecorate().getProdleton().getName();
        String[] child_productions = node.undecorate().getProdleton().getChildTypes();
        System.out.print(partent_production + " ");
        for (int i = 0; i < child_productions.length; ++i) {
            System.out.print(child_productions[i] + " ");
        }
        System.out.print("\n");
    }

    public void eqSynth(int attribute) {
    }

    public void eqInher(int attribute) {
    }

    public int listSynth(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> synAttrSet = nonterminalton.getAllSynth();
        int num_attr = 0;
        for (String synAttr : synAttrSet) {
            System.out.println("Attribute = " + synAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public int listInher(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        Set<String> inhAttrSet = nonterminalton.getAllInh();
        int num_attr = 0;
        for (String inhAttr : inhAttrSet) {
            System.out.println("Attribute = " + inhAttr);
            ++num_attr;
        }
        return num_attr;
    }

    public void printAttributes(DecoratedNode node, boolean toggleHeadlessAttributes) {
        List<String> attributeList = Debug.allAttributesList(node);
        if (toggleHeadlessAttributes) {
            attributeList = this.removeHeaders(Debug.allAttributesList(node));
        }
        int i = 0;
        for (String attribute : attributeList) {
            System.out.println(Integer.toString(i) + ": " + attribute);
            ++i;
        }
    }

    public List<String> removeHeaders(List<String> stringList) {
        ArrayList<String> headlessList = new ArrayList<String>();
        for (String element : stringList) {
            int lastIndex = element.lastIndexOf(":");
            if (lastIndex == -1) {
                headlessList.add(element);
                continue;
            }
            headlessList.add(element.substring(lastIndex + 1));
        }
        return headlessList;
    }

    public Map<String, Object> attriburteNameObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.listLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public void printAttrFromName(DecoratedNode node, String printAttribute) {
        Map<String, Object> attributeMap = this.attriburteNameObjectMap(node);
        System.out.println(Util.genericShow(attributeMap.get(printAttribute)));
    }

    public static List<String> listLocalAttrs(DecoratedNode node) {
        int count = node.getNode().getNumberOfLocalAttrs();
        ArrayList<String> listLocals = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            Lazy attribute = node.getNode().getLocal(i);
            Object o = attribute.eval(node);
            listLocals.add(node.getNode().getNameOfLocalAttr(i));
        }
        return listLocals;
    }

    public static List<String> allAttributesList(DecoratedNode node) {
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        List<String> attributeList = nonterminalton.alphabeticalAttributes();
        List<String> localAttributeList = Debug.listLocalAttrs(node);
        attributeList.addAll(localAttributeList);
        attributeList.sort(null);
        return attributeList;
    }

    public static Map<String, Object> allAttributesObjectMap(DecoratedNode node) {
        List<String> attributeList = Debug.allAttributesList(node);
        RTTIManager.Prodleton<? extends Node> prodleton = node.getNode().getProdleton();
        RTTIManager.Nonterminalton<? extends Node> nonterminalton = prodleton.getNonterminalton();
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (String attribute : attributeList) {
            Integer index;
            if (nonterminalton.getSynOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getSynOccursIndex(attribute);
                Lazy synthAttribute = node.getNode().getSynthesized(index);
                Object o = synthAttribute.eval(node);
                attributeMap.put(attribute, o);
                continue;
            }
            if (nonterminalton.getInhOccursIndices().keySet().contains(attribute)) {
                index = nonterminalton.getInhOccursIndex(attribute);
                Object o = node.evalInhSomehowButPublic(index);
                attributeMap.put(attribute, o);
                continue;
            }
            List<String> listLocals = Debug.listLocalAttrs(node);
            Integer index2 = listLocals.indexOf(attribute);
            Lazy localAttribute = node.getNode().getLocal(index2);
            Object o = localAttribute.eval(node);
            attributeMap.put(attribute, o);
        }
        return attributeMap;
    }

    public boolean isContractum(DecoratedNode node) {
        return node.getNode().hasForward();
    }

    public static class StringObjectPair {
        private String stringValue;
        private Object objectValue;

        public StringObjectPair(String stringValue, Object objectValue) {
            this.stringValue = stringValue;
            this.objectValue = objectValue;
        }

        public String getString() {
            return this.stringValue;
        }

        public Object getObject() {
            return this.objectValue;
        }
    }
}

