/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.Node;
import common.exceptions.MissingDefinitionException;
import common.exceptions.TraceException;
import java.util.ArrayList;

public abstract class CollectionAttribute
implements Lazy {
    private ArrayList<Lazy> pieces = new ArrayList();
    private Lazy base;
    public boolean appliedNTFix;

    public CollectionAttribute() {
    }

    public CollectionAttribute(int index) {
        this();
        this.base = new BaseDefault(index);
    }

    public final Lazy getBase() {
        return this.base;
    }

    public final void setBase(Lazy base) {
        this.base = base;
    }

    public final ArrayList<Lazy> getPieces() {
        return this.pieces;
    }

    public final void addPiece(Lazy attribute) {
        this.pieces.add(attribute);
    }

    @Override
    public abstract Object eval(DecoratedNode var1);

    private static class BaseDefault
    implements Lazy {
        private final int index;

        BaseDefault(int index) {
            this.index = index;
        }

        @Override
        public Object eval(DecoratedNode context) {
            Node un = context.undecorate();
            if (un.hasForward()) {
                try {
                    return context.forward().synthesized(this.index);
                }
                catch (Throwable t) {
                    throw new TraceException("Error evaluating base of collection attribute " + un.getNameOfSynAttr(this.index) + " via forward of " + un.getName(), t);
                }
            }
            throw new MissingDefinitionException("No base defined for collection attribute " + un.getNameOfSynAttr(this.index) + " in " + un.getName());
        }
    }
}

