/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ContextStack;
import common.Feature;
import common.NodeContextMessage;
import common.ProductionName;
import common.SimplifiedContextBox;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class SimplifiedContextStack {
    private ContextStack fullStack;
    private String filename;
    private String filenameHTML;
    private Stack<SimplifiedContextBox> simpleStack = new Stack();
    private boolean needSetAllProds = true;
    private ProductionName[] productions;
    private int[] partition;

    public SimplifiedContextStack(ContextStack fullStack) {
        this.fullStack = fullStack;
        this.partition = new int[fullStack.getHeight()];
        this.filename = "simpleDebugContext.txt";
        this.filenameHTML = "simpleDebugContext.html";
    }

    public SimplifiedContextStack(ContextStack fullStack, String fn) {
        this.fullStack = fullStack;
        this.partition = new int[fullStack.getHeight()];
        this.filename = fn;
        this.filenameHTML = "simpleDebugContext.html";
    }

    public SimplifiedContextStack(ContextStack fullStack, String fn, String fnHTML) {
        this.fullStack = fullStack;
        this.partition = new int[fullStack.getHeight()];
        this.filename = fn;
        this.filenameHTML = fnHTML;
    }

    private void updateSimplifiedStack() {
        this.needSetAllProds = true;
        this.makeSimplifiedStack();
    }

    public void show() {
        this.updateSimplifiedStack();
        String border = "*******************";
        try {
            FileWriter myWriter = new FileWriter(this.filename);
            for (int i = this.simpleStack.size() - 1; i >= 0; --i) {
                SimplifiedContextBox sbox = (SimplifiedContextBox)this.simpleStack.get(i);
                myWriter.write(border + "\n" + sbox.toString() + "\n" + border);
            }
            myWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void generateHTMLFile() {
        this.updateSimplifiedStack();
        try (FileWriter myWriter = new FileWriter(this.filenameHTML);){
            myWriter.write("<html><head><title>Simplified Context Stack</title></head><body>\n");
            for (int i = this.simpleStack.size() - 1; i >= 0; --i) {
                SimplifiedContextBox sbox = (SimplifiedContextBox)this.simpleStack.get(i);
                myWriter.write(sbox.getHTMLBox());
                myWriter.write("<hr>");
            }
            myWriter.write("</body></html>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeSimplifiedStack() {
        this.simpleStack = new Stack();
        this.fillInPartition();
        int prevPartitionIndex = 0;
        int start = 0;
        int end = -1;
        for (int i = 0; i < this.partition.length; ++i) {
            if (this.partition[i] > prevPartitionIndex) {
                SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
                this.simpleStack.push(sbox);
                end = start = i;
                ++prevPartitionIndex;
                continue;
            }
            ++end;
        }
        SimplifiedContextBox sbox = this.makeSimplifiedBox(start, end);
        this.simpleStack.push(sbox);
    }

    private SimplifiedContextBox makeSimplifiedBox(int i, int j) {
        if (i > j) {
            System.out.println("Invalid Partition Indices: " + i + ", " + j);
            return null;
        }
        SimplifiedContextBox sbox = new SimplifiedContextBox();
        NodeContextMessage first = this.fullStack.get(i);
        NodeContextMessage last = this.fullStack.get(j);
        sbox.translationX = first.getTranslationX();
        sbox.higherOrderY = first.getHigherOrderY();
        sbox.textSyntax = first.getTextRepr();
        sbox.syntaxToHighlight = last.getTextRepr();
        this.SetAllProds();
        sbox.prodsVisited = Arrays.copyOfRange(this.productions, i, j + 1);
        sbox.features = new ArrayList<Feature>();
        this.fillInFeaturesList(sbox, i, j);
        return sbox;
    }

    private void fillInFeaturesList(SimplifiedContextBox sbox, int i, int j) {
        for (int k = i; k <= j; ++k) {
            Feature f;
            String targetName;
            String nodeName;
            NodeContextMessage node = this.fullStack.get(k);
            if (node.isRedex()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k < j) {
                    targetName = this.productions[k + 1].toString();
                }
                f = new Feature(nodeName, "redex", targetName);
                sbox.features.add(f);
            }
            if (node.isContractum()) {
                nodeName = this.productions[k].toString();
                targetName = "";
                if (k > 0) {
                    targetName = this.productions[k - 1].toString();
                }
                f = new Feature(nodeName, "contractum", targetName);
                sbox.features.add(f);
            }
            if (!node.isAttributeRoot()) continue;
            nodeName = this.productions[k].toString();
            targetName = "";
            if (k > 0) {
                targetName = this.productions[k - 1].toString();
            }
            f = new Feature(nodeName, "attribute root", targetName);
            sbox.features.add(f);
        }
    }

    private void SetAllProds() {
        int prodIndex;
        if (!this.needSetAllProds) {
            return;
        }
        ProductionName[] allProds = new ProductionName[this.fullStack.getHeight()];
        for (int index = 0; index < this.fullStack.getHeight(); ++index) {
            ProductionName pn;
            allProds[index] = pn = new ProductionName(this.fullStack.get(index).getProdName(), -1);
        }
        for (prodIndex = 0; prodIndex < allProds.length; ++prodIndex) {
            int seqNum = 1;
            String name = allProds[prodIndex].name;
            for (int visitIndex = 0; visitIndex < prodIndex; ++visitIndex) {
                String curName = allProds[visitIndex].name;
                if (curName.compareTo(name) != 0) continue;
                ++seqNum;
            }
            allProds[prodIndex].index = seqNum;
        }
        for (prodIndex = 0; prodIndex < allProds.length; ++prodIndex) {
            if (allProds[prodIndex].index != 1) continue;
            boolean isUnique = true;
            for (int k = 0; k < allProds.length; ++k) {
                if (k == prodIndex || allProds[k].name.compareTo(allProds[prodIndex].name) != 0) continue;
                isUnique = false;
                break;
            }
            if (!isUnique) continue;
            allProds[prodIndex].index = 0;
        }
        this.productions = allProds;
        this.needSetAllProds = false;
    }

    private void fillInPartition() {
        this.partition = new int[this.fullStack.getHeight()];
        int previousX = 0;
        int previousY = 0;
        int partitionIndex = 0;
        for (int i = 0; i < this.fullStack.getHeight(); ++i) {
            NodeContextMessage node = this.fullStack.get(i);
            int curX = node.getTranslationX();
            int curY = node.getHigherOrderY();
            if (curX == previousX && curY == previousY) {
                this.partition[i] = partitionIndex;
                continue;
            }
            previousX = curX;
            previousY = curY;
            this.partition[i] = ++partitionIndex;
        }
    }
}

