/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogHandler;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;

public class CompilerLogger {
    private CompilerLevel level = CompilerLevel.REGULAR;
    private CompilerLogHandler handler;

    public CompilerLogger(CompilerLogHandler handler) {
        this(handler, CompilerLevel.REGULAR);
    }

    public CompilerLogger(CompilerLogHandler handler, CompilerLevel level) {
        this.handler = handler;
    }

    public void log(CompilerLogMessage message) {
        if (this.isLoggable(message.getLevel())) {
            this.handler.handleMessage(message);
        }
    }

    public void logError(CompilerLogMessage message) throws CopperException {
        if (this.isLoggable(message.getLevel())) {
            this.handler.handleErrorMessage(message);
        }
    }

    public CompilerLevel getLevel() {
        return this.level;
    }

    public void setLevel(CompilerLevel level) {
        this.level = level;
    }

    public CompilerLogHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CompilerLogHandler handler) {
        this.handler = handler;
    }

    public boolean isLoggable(CompilerLevel level) {
        return level.ordinal() >= this.level.ordinal();
    }

    public void flush() throws CopperException {
        this.handler.flush();
    }
}

