/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.io;

import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.Location;

class InputPositionFull
extends InputPosition {
    private static final long serialVersionUID = 487378816987742808L;
    private String fileName;
    private int line;
    private long pos;
    private int posSinceNewline;

    protected InputPositionFull() {
        this.fileName = "";
        this.pos = 0L;
        this.posSinceNewline = 0;
        this.line = 1;
    }

    protected InputPositionFull(InputPosition ref, int offset, Pair<Integer, Integer> nlCount) {
        this.fileName = ref.getFileName();
        this.pos = ref.getPos() + (long)offset;
        this.line = ref.getLine() + nlCount.first();
        this.posSinceNewline = nlCount.second() == -1 ? ref.getColumn() + offset : nlCount.second();
    }

    protected InputPositionFull(InputPosition ref, String fileName) {
        this(ref);
        this.fileName = fileName;
    }

    protected InputPositionFull(InputPosition p) {
        this.fileName = p.getFileName();
        this.pos = p.getPos();
        this.line = p.getLine();
        this.posSinceNewline = p.getColumn();
    }

    @Override
    public boolean isBefore(InputPosition rhs) {
        return this.compareTo(rhs) < 0;
    }

    @Override
    public boolean isAfter(InputPosition rhs) {
        return this.compareTo(rhs) > 0;
    }

    @Override
    public int diff(InputPosition ref) {
        return (int)(this.pos - ref.getPos());
    }

    @Override
    public int compareTo(Location ref) {
        int discriminant = (int)(this.pos - ref.getPos());
        return Integer.signum(discriminant);
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs instanceof InputPosition) {
            return this.compareTo((InputPosition)rhs) == 0;
        }
        return false;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.posSinceNewline;
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    public String toString() {
        return this.getFileName() + ":" + this.getLine() + "." + this.getColumn();
    }

    @Override
    public int hashCode() {
        return (int)(this.pos % 0x80000000L);
    }
}

