/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.NodeContextMessage;
import java.util.Iterator;
import java.util.Stack;

public class ContextStack {
    private Stack<NodeContextMessage> stack = new Stack();
    private int height = 0;
    private int nextIndex = 1;

    public void push(DecoratedNode n) {
        ++this.height;
        NodeContextMessage ncm = new NodeContextMessage(n, this.nextIndex++);
        this.stack.push(ncm);
    }

    public NodeContextMessage pop() {
        --this.height;
        --this.nextIndex;
        return this.stack.pop();
    }

    public NodeContextMessage peak() {
        return this.stack.peek();
    }

    public int getHeight() {
        return this.height;
    }

    public Iterator<NodeContextMessage> iterator() {
        return this.stack.iterator();
    }

    public NodeContextMessage get(int stackIndex) {
        if (stackIndex >= 0 && stackIndex < this.stack.size()) {
            return (NodeContextMessage)this.stack.get(stackIndex);
        }
        throw new IndexOutOfBoundsException("Index " + stackIndex + " is out of bounds.");
    }
}

