/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.util;

import common.ConsCell;
import common.IOToken;
import common.StringCatter;
import common.javainterop.ConsCellCollection;
import edu.umn.cs.melt.ide.imp.services.Console;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import silver.core.NIOVal;
import silver.core.Pioval;
import silver.core.Pjust;
import silver.core.Pnothing;

public final class Util {
    public static IOToken info(String msg) {
        Console.getConsoleLoggingStream().info(msg);
        return IOToken.singleton;
    }

    public static IOToken error(String msg) {
        Console.getConsoleLoggingStream().error(msg);
        return IOToken.singleton;
    }

    public static IOToken ant(StringCatter buildFile, StringCatter arguments, StringCatter target) {
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(buildFile.toString());
        runner.setArguments(arguments.toString());
        if (!"".equals(target.toString().trim())) {
            runner.setExecutionTargets(new String[]{target.toString()});
        }
        try {
            runner.run();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return IOToken.singleton;
    }

    public static IOToken refresh(StringCatter projectName) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.toString()).refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return IOToken.singleton;
    }

    public static NIOVal getProjectName(Object _project, Object ioin) {
        IProject project = (IProject)_project;
        return new Pioval(ioin, (Object)new StringCatter(project.getName()));
    }

    public static IOToken refreshProject(Object _project, Object ioin) {
        IProject project = (IProject)_project;
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return IOToken.singleton;
    }

    public static NIOVal getAbsoluteProjectPath(Object _project, Object ioin) {
        IProject project = (IProject)_project;
        return new Pioval(ioin, (Object)new StringCatter(project.getLocation().toOSString()));
    }

    public static NIOVal getGeneratedProjectPath(Object _project, Object ioin) {
        IProject project = (IProject)_project;
        return new Pioval(ioin, (Object)new StringCatter(String.valueOf(project.getLocation().toOSString()) + '/' + "bin"));
    }

    public static NIOVal getProjectMembers(Object _project, Object ioin) {
        Pjust result;
        IProject project = (IProject)_project;
        try {
            result = new Pjust((Object)ConsCellCollection.fromList(Arrays.asList(project.members())));
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = new Pnothing();
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal deleteResource(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = true;
        try {
            resource.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = false;
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal copyResource(Object _resource, StringCatter dest, Object ioin) {
        IResource resource = (IResource)_resource;
        IPath path = resource.getProject().getFullPath().append(dest.toString());
        boolean result = true;
        try {
            resource.copy(path, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = false;
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal moveResource(Object _resource, StringCatter dest, Object ioin) {
        IResource resource = (IResource)_resource;
        IPath path = resource.getProject().getFullPath().append(dest.toString());
        boolean result = true;
        try {
            resource.move(path, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = false;
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal createResource(Object _project, StringCatter file, StringCatter contents, Object ioin) {
        Pnothing result;
        IProject project = (IProject)_project;
        IFile f = project.getFile(file.toString());
        try {
            f.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), true, null);
            result = new Pjust((Object)f);
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = new Pnothing();
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal createFolderResource(Object _project, StringCatter file, Object ioin) {
        Pnothing result;
        IProject project = (IProject)_project;
        IFolder f = project.getFolder(file.toString());
        try {
            f.create(true, true, null);
            result = new Pjust((Object)f);
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = new Pnothing();
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal getRelativePath(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        return new Pioval(ioin, (Object)new StringCatter(resource.getProjectRelativePath().toOSString()));
    }

    public static NIOVal getAbsolutePath(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        return new Pioval(ioin, (Object)new StringCatter(resource.getLocation().toOSString()));
    }

    public static NIOVal getResourceMembers(Object _resource, Object ioin) {
        ConsCell result;
        IResource resource = (IResource)_resource;
        try {
            if (resource instanceof IFolder) {
                IFolder f = (IFolder)resource;
                result = ConsCellCollection.fromList(Arrays.asList(f.members()));
            } else {
                result = ConsCell.nil;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = ConsCell.nil;
        }
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceIsFolder(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource instanceof IFolder;
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceIsFile(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource instanceof IFile;
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceIsLinked(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource.isLinked();
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceIsHidden(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource.isHidden();
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceIsDerived(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource.isDerived();
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal resourceExists(Object _resource, Object ioin) {
        IResource resource = (IResource)_resource;
        boolean result = resource.exists();
        return new Pioval(ioin, (Object)result);
    }

    public static NIOVal getIdeResource(StringCatter id, Object ioin) {
        URL url = Platform.getBundle((String)SVRegistry.get().pluginId()).getEntry("resource/" + id.toString());
        String fileurl = "";
        try {
            fileurl = FileLocator.toFileURL((URL)url).getFile().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Pioval(ioin, (Object)new StringCatter(fileurl));
    }
}

