/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.parsetable.MutableLRParseTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class LRParseTableBuilder {
    private ParserSpec spec;
    private LR0DFA dfa;
    private LRLookaheadSets lookaheadSets;
    private int transitionArraySize;
    private BitSet reduceActions;

    private LRParseTableBuilder(ParserSpec spec, LR0DFA dfa, LRLookaheadSets lookaheadSets) {
        this.spec = spec;
        this.dfa = dfa;
        this.lookaheadSets = lookaheadSets;
        this.transitionArraySize = Math.max(spec.terminals.length(), spec.nonterminals.length());
        this.reduceActions = new BitSet();
    }

    public static LRParseTable build(ParserSpec spec, LR0DFA dfa, LRLookaheadSets lookaheadSets) {
        return new LRParseTableBuilder(spec, dfa, lookaheadSets).buildParseTable();
    }

    public LRParseTable buildParseTable() {
        MutableLRParseTable parseTable = new MutableLRParseTable(this.dfa.size(), this.transitionArraySize);
        for (int state = 0; state < this.dfa.size(); ++state) {
            LR0ItemSet I = this.dfa.getItemSet(state);
            for (int item = 0; item < I.size(); ++item) {
                if (I.getPosition(item) == this.spec.pr.getRHSLength(I.getProduction(item))) {
                    int LA = this.lookaheadSets.getLookahead(state, item).nextSetBit(0);
                    while (LA >= 0) {
                        this.addAction(parseTable, state, LA, (byte)2, I.getProduction(item));
                        LA = this.lookaheadSets.getLookahead(state, item).nextSetBit(LA + 1);
                    }
                }
                if (I.getProduction(item) != this.spec.getStartProduction() || I.getPosition(item) != 1) continue;
                this.addAction(parseTable, state, this.spec.getEOFTerminal(), (byte)1, 0);
            }
            int X = this.dfa.getTransitionLabels(state).nextSetBit(0);
            while (X >= 0) {
                this.addAction(parseTable, state, X, (byte)1, this.dfa.getTransition(state, X));
                X = this.dfa.getTransitionLabels(state).nextSetBit(X + 1);
            }
        }
        for (int i = 0; i < parseTable.getConflictCount(); ++i) {
            LRParseTableConflict conflict = parseTable.getConflict(i);
            int shiftAction = conflict.shift;
            if (conflict.reduce.cardinality() > 1) {
                int encounteredOperatorClass = Integer.MIN_VALUE;
                int maxPrecedence = Integer.MIN_VALUE;
                boolean allOneClass = true;
                int p = conflict.reduce.nextSetBit(0);
                while (allOneClass && p >= 0) {
                    if (this.spec.pr.getPrecedence(p) > maxPrecedence) {
                        maxPrecedence = this.spec.pr.getPrecedence(p);
                        this.reduceActions.clear();
                    }
                    if (this.spec.pr.getPrecedence(p) == maxPrecedence) {
                        this.reduceActions.set(p);
                    }
                    int opClass = this.spec.pr.getPrecedenceClass(p);
                    if (encounteredOperatorClass == Integer.MIN_VALUE) {
                        encounteredOperatorClass = opClass;
                    } else {
                        allOneClass &= opClass == encounteredOperatorClass;
                    }
                    p = conflict.reduce.nextSetBit(p + 1);
                }
                if (!allOneClass || this.reduceActions.cardinality() > 1) {
                    continue;
                }
            } else {
                this.reduceActions.clear();
                this.reduceActions.or(conflict.reduce);
            }
            if (shiftAction != -1 && this.reduceActions.cardinality() == 1) {
                int shiftOperator = conflict.getSymbol();
                int reduceOperator = this.spec.pr.getOperator(this.reduceActions.nextSetBit(0));
                if (reduceOperator != -1) {
                    if (shiftOperator != reduceOperator && this.spec.t.getOperatorClass(shiftOperator) == this.spec.t.getOperatorClass(reduceOperator) && this.spec.t.hasOperatorPrecedence(shiftOperator) && this.spec.t.hasOperatorPrecedence(reduceOperator)) {
                        if (this.spec.t.getOperatorPrecedence(shiftOperator) > this.spec.t.getOperatorPrecedence(reduceOperator)) {
                            this.reduceActions.clear();
                        } else if (this.spec.t.getOperatorPrecedence(reduceOperator) > this.spec.t.getOperatorPrecedence(shiftOperator)) {
                            shiftAction = -1;
                        }
                    }
                    if (shiftOperator == reduceOperator || this.spec.t.getOperatorClass(shiftOperator) == this.spec.t.getOperatorClass(reduceOperator) && this.spec.t.getOperatorPrecedence(shiftOperator) == this.spec.t.getOperatorPrecedence(reduceOperator) && this.spec.t.getOperatorAssociativity(shiftOperator) == this.spec.t.getOperatorAssociativity(reduceOperator)) {
                        switch (this.spec.t.getOperatorAssociativity(shiftOperator)) {
                            case LEFT: {
                                shiftAction = -1;
                                break;
                            }
                            case RIGHT: {
                                this.reduceActions.clear();
                                break;
                            }
                            case NONASSOC: {
                                shiftAction = -1;
                                this.reduceActions.clear();
                                break;
                            }
                        }
                    }
                }
            }
            if (shiftAction == -1 && this.reduceActions.isEmpty()) {
                parseTable.setActionType(conflict.getState(), conflict.getSymbol(), (byte)0);
                parseTable.setActionParameter(conflict.getState(), conflict.getSymbol(), 0);
                continue;
            }
            if (shiftAction != -1 && this.reduceActions.isEmpty()) {
                parseTable.setActionType(conflict.getState(), conflict.getSymbol(), (byte)1);
                parseTable.setActionParameter(conflict.getState(), conflict.getSymbol(), shiftAction);
                continue;
            }
            if (shiftAction != -1 || this.reduceActions.cardinality() != 1) continue;
            parseTable.setActionType(conflict.getState(), conflict.getSymbol(), (byte)2);
            parseTable.setActionParameter(conflict.getState(), conflict.getSymbol(), this.reduceActions.nextSetBit(0));
        }
        return parseTable;
    }

    private void addAction(MutableLRParseTable parseTable, int state, int symbol, byte type, int parameter) {
        if (parseTable.getValidLA(state).get(symbol)) {
            LRParseTableConflict conflict;
            if (parseTable.getActionType(state, symbol) == 3) {
                conflict = parseTable.getConflict(parseTable.getActionParameter(state, symbol));
            } else {
                conflict = new LRParseTableConflict(state, symbol);
                switch (parseTable.getActionType(state, symbol)) {
                    case 1: {
                        conflict.shift = parseTable.getActionParameter(state, symbol);
                        break;
                    }
                    case 2: {
                        conflict.reduce.set(parseTable.getActionParameter(state, symbol));
                    }
                }
                parseTable.setActionType(state, symbol, (byte)3);
                parseTable.setActionParameter(state, symbol, parseTable.addConflict(conflict));
            }
            switch (type) {
                case 1: {
                    conflict.shift = parameter;
                    break;
                }
                case 2: {
                    conflict.reduce.set(parameter);
                }
            }
        } else {
            parseTable.getValidLA(state).set(symbol);
            parseTable.setActionType(state, symbol, type);
            parseTable.setActionParameter(state, symbol, parameter);
        }
    }
}

