/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.lalr;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.LexicalAttributes;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.PrecedenceRelationGraph;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegex;
import edu.umn.cs.melt.copper.legacy.compiletime.auxiliary.CharacterRange;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.QScannerStateInfo;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScanner;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatch;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatchData;
import edu.umn.cs.melt.copper.legacy.compiletime.engines.lalr.scanner.QScannerMatchLongest;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFA2DFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFAState;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.srcbuilders.enginebuilders.RegexInfo;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.QuotedStringFormatter;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class QScannerGenerator {
    public static int STATE_BATCH_SIZE = 512;
    private Hashtable<Symbol, RegexInfo> regexes = new Hashtable();
    private CompilerLogger logger;

    public QScannerGenerator(CompilerLogger logger) {
        this.logger = logger;
    }

    public boolean addRegex(Symbol newSym, ParsedRegex newRegex, LexicalAttributes attributes, String newSemAction) {
        if (this.regexes.contains(newSym)) {
            return false;
        }
        this.regexes.put(newSym, new RegexInfo(newRegex, newSemAction));
        return true;
    }

    public QScannerStateInfo[] compile(GrammarSource grammarData, PrintStream out, String packageDecl, String importDecls, String accessLevel, String className, String ancillaries, String linePrefix) throws CopperException {
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "    NFA generation/DFA conversion...\n");
        }
        HashSet<Object> nfas = new HashSet<Object>();
        for (Symbol forRegex : this.regexes.keySet()) {
            NFA newNFA = this.regexes.get(forRegex).getRegex().generateAutomaton(forRegex);
            if (this.logger.isLoggable(CompilerLogMessageSort.DEBUG)) {
                this.logger.logMessage(CompilerLogMessageSort.DEBUG, null, "NFA for " + forRegex + ": " + newNFA.toString());
            }
            nfas.add(newNFA);
        }
        HashSet<NFAState> allStates = new HashSet<NFAState>();
        NFAState newStartState = new NFAState(Symbol.symbol("START"), null);
        allStates.add(newStartState);
        for (NFA nFA : nfas) {
            newStartState.addTransition(new Character(NFAState.EmptyChar), nFA.getStartState());
            allStates.addAll(nFA.getStates());
        }
        NFA mergedNFA = new NFA(allStates, newStartState);
        NFA nFA = new NFA2DFA().determinizeNFA(mergedNFA);
        Hashtable<NFAState, Integer> numericalMapping = new Hashtable<NFAState, Integer>();
        int startState = -1;
        QScannerStateInfo[] stateInfo = new QScannerStateInfo[nFA.getStates().size() + 1];
        for (int i = 0; i < stateInfo.length; ++i) {
            stateInfo[i] = new QScannerStateInfo();
        }
        int nextStateNum = 1;
        for (NFAState state : nFA.getStates()) {
            numericalMapping.put(state, nextStateNum);
            if (state.equals(nFA.getStartState())) {
                startState = nextStateNum;
            }
            for (Symbol sym : state.getAccepts()) {
                stateInfo[nextStateNum].addAcceptingSyms(new Terminal(sym));
            }
            state.compressTransitions();
            ++nextStateNum;
        }
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "    Static lexical disambiguation...\n");
        }
        if (grammarData != null) {
            for (NFAState state : nFA.getStates()) {
                HashSet<Terminal> accF = stateInfo[(Integer)numericalMapping.get(state)].getAcceptingSyms();
                PrecedenceRelationGraph accFG = grammarData.getPrecedenceRelationsGraph().makeCut(accF);
                HashSet<Terminal> rej = accFG.partitionAcceptSet(this.logger, "static precedence disambiguator, scanner state " + numericalMapping.get(state));
                Iterator iterator = rej.iterator();
                while (iterator.hasNext()) {
                    Terminal terminal = (Terminal)iterator.next();
                    stateInfo[(Integer)numericalMapping.get(state)].removeAcceptingSyms(terminal);
                    stateInfo[(Integer)numericalMapping.get(state)].addRejectingSyms(terminal);
                }
            }
        }
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "    Transitive closure...\n");
        }
        int numStates = nFA.getStates().size() + 1;
        boolean[][] transClosure = new boolean[numStates][numStates];
        for (int i = 0; i < numStates; ++i) {
            transClosure[i][i] = true;
        }
        for (NFAState i : nFA.getStates()) {
            for (Pair<CharacterRange, NFAState> pair : i) {
                transClosure[((Integer)numericalMapping.get((Object)i)).intValue()][((Integer)numericalMapping.get((Object)pair.second())).intValue()] = true;
            }
        }
        for (int k = 0; k < numStates; ++k) {
            for (int i = 0; i < numStates; ++i) {
                for (int j = 0; j < numStates; ++j) {
                    transClosure[i][j] = transClosure[i][j] || transClosure[i][k] && transClosure[k][j];
                }
            }
        }
        for (int i = 0; i < numStates; ++i) {
            for (int j = 0; j < numStates; ++j) {
                if (!transClosure[i][j]) continue;
                for (Terminal terminal : stateInfo[j].getAcceptingSyms()) {
                    stateInfo[i].addPossibleSyms(terminal);
                }
                for (Terminal terminal : stateInfo[j].getRejectingSyms()) {
                    stateInfo[i].addPossibleSyms(terminal);
                }
            }
        }
        out.print(linePrefix + packageDecl + "\n");
        out.print(linePrefix + importDecls + "\n");
        out.print(linePrefix + accessLevel + " class " + className + " extends " + QScanner.class.getName() + "\n");
        out.print(linePrefix + "{\n");
        out.print(linePrefix + "    public " + className + "(" + Reader.class.getName() + " reader," + CompilerLogger.class.getName() + " logger)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        super(logger.isLoggable(" + CompilerLogMessageSort.class.getName() + ".TICK));\n");
        out.print(linePrefix + "        this.buffer = " + ScannerBuffer.class.getName() + ".instantiate(reader);\n");
        out.print(linePrefix + "        this.logger = logger;\n");
        out.print(linePrefix + "        startState = " + startState + ";\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "\n");
        out.print(linePrefix + "    /** Create a symbol. */\n");
        out.print(linePrefix + "    protected static " + Symbol.class.getName() + " s(String sym)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return " + Symbol.class.getName() + ".symbol(sym);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Create a terminal from a symbol. */\n");
        out.print(linePrefix + "    protected static " + Terminal.class.getName() + " t(String sym)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return new " + Terminal.class.getName() + "(sym);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Setup accepting symbols for a state. */\n");
        out.print(linePrefix + "    protected static void sas(int index," + Terminal.class.getName() + "... aSyms)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        staticStateInfo[index].addAcceptingSyms(aSyms);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Setup possible symbols for a state. */\n");
        out.print(linePrefix + "    protected static void sps(int index," + Terminal.class.getName() + "... pSyms)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        staticStateInfo[index].addPossibleSyms(pSyms);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Setup rejecting symbols for a state. */\n");
        out.print(linePrefix + "    protected static void srs(int index," + Terminal.class.getName() + "... rSyms)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        staticStateInfo[index].addRejectingSyms(rSyms);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Return maximal-munch match objects. */\n");
        out.print(linePrefix + "    protected static " + QScannerMatchLongest.class.getName() + " newlong(" + Terminal.class.getName() + " t," + InputPosition.class.getName() + " positionPreceding," + InputPosition.class.getName() + " positionFollowing," + ArrayList.class.getName() + "<" + QScannerMatchData.class.getName() + "> layouts)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return new " + QScannerMatchLongest.class.getName() + "(t,positionPreceding,positionFollowing,layouts);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    /** Functions for determining character ranges. */\n");
        out.print(linePrefix + "    protected static boolean cheq(char input,char single)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return (input == single);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    protected static boolean chin(char input,char min,char max)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return (input >= min && input <= max);\n");
        out.print(linePrefix + "    }\n");
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "    Accept/possible info...\n");
        }
        Hashtable<Symbol, Integer> symbolTransTable = new Hashtable<Symbol, Integer>();
        int regexNum = 1;
        out.print(linePrefix + "    private static " + Terminal.class.getName() + " ");
        for (Symbol symbol : this.regexes.keySet()) {
            out.print("t_" + regexNum);
            if (regexNum == this.regexes.keySet().size()) {
                out.print(";\n");
            } else {
                out.print(",");
            }
            symbolTransTable.put(symbol, regexNum++);
        }
        out.print(";\n");
        for (int i = 0; i < stateInfo.length; ++i) {
            if (i % STATE_BATCH_SIZE == 0) {
                if (i != 0) {
                    out.print(linePrefix + "    }\n\n");
                }
                out.print(linePrefix + "    private static void symAdd_" + i / STATE_BATCH_SIZE + "()\n");
                out.print(linePrefix + "    {\n");
            }
            if (!stateInfo[i].getAcceptingSyms().isEmpty()) {
                out.print(linePrefix + "        sas(" + i);
                for (Terminal terminal : stateInfo[i].getAcceptingSyms()) {
                    out.print(",t_" + symbolTransTable.get(terminal.getId()));
                }
                out.print(");\n");
            }
            if (!stateInfo[i].getPossibleSyms().isEmpty()) {
                out.print(linePrefix + "        sps(" + i);
                for (Terminal terminal : stateInfo[i].getPossibleSyms()) {
                    out.print(",t_" + symbolTransTable.get(terminal.getId()));
                }
                out.print(");\n");
            }
            if (stateInfo[i].getRejectingSyms().isEmpty()) continue;
            out.print(linePrefix + "        srs(" + i);
            for (Terminal terminal : stateInfo[i].getRejectingSyms()) {
                out.print(",t_" + symbolTransTable.get(terminal.getId()));
            }
            out.print(");\n");
        }
        out.print(linePrefix + "    }\n\n");
        out.print(linePrefix + "    private static " + QScannerStateInfo.class.getName() + "[] staticStateInfo;\n");
        out.print(linePrefix + "    static\n");
        out.print(linePrefix + "    {\n");
        for (Symbol symbol : this.regexes.keySet()) {
            out.print(linePrefix + "        t_" + symbolTransTable.get(symbol) + " = t(\"" + symbol.toString() + "\");\n");
        }
        out.print(linePrefix + "        staticStateInfo = new " + QScannerStateInfo.class.getName() + "[" + (numericalMapping.size() + 1) + "];\n");
        out.print(linePrefix + "        for(int i = 0;i < " + (numericalMapping.size() + 1) + ";i++) staticStateInfo[i] = new " + QScannerStateInfo.class.getName() + "();\n");
        int i = 0;
        while (i * STATE_BATCH_SIZE < stateInfo.length) {
            out.print(linePrefix + "        symAdd_" + i + "();\n");
            ++i;
        }
        out.print(linePrefix + "    }\n");
        if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
            this.logger.logTick(1, "    Transition table...\n");
        }
        out.print(linePrefix + "    protected int transition(int state,char ch)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        switch(state)\n");
        out.print(linePrefix + "        {\n");
        for (NFAState nFAState : nFA.getStates()) {
            out.print(linePrefix + "            case " + numericalMapping.get(nFAState) + ":\n");
            out.print(linePrefix + "                return tr_" + numericalMapping.get(nFAState) + "(ch);\n");
        }
        out.print(linePrefix + "        default: return 0;\n");
        out.print(linePrefix + "        }\n");
        out.print(linePrefix + "    }\n");
        for (NFAState nFAState : nFA.getStates()) {
            out.print(linePrefix + "    private int tr_" + numericalMapping.get(nFAState) + "(char ch)\n");
            out.print(linePrefix + "    {\n");
            for (Pair<CharacterRange, NFAState> transition : nFAState) {
                if (transition.first().isSingleChar()) {
                    out.print(linePrefix + "        if(cheq(ch,'" + QuotedStringFormatter.quoteChar(transition.first().charValue()) + "')) ");
                } else {
                    out.print(linePrefix + "        if(chin(ch,'" + QuotedStringFormatter.quoteChar(transition.first().firstChar()) + "','" + QuotedStringFormatter.quoteChar(transition.first().lastChar()) + "')) ");
                }
                out.print("return " + numericalMapping.get(transition.second()) + ";\n");
            }
            out.print(linePrefix + "        return 0;\n");
            out.print(linePrefix + "    }\n");
        }
        out.print(linePrefix + "    protected " + QScannerMatch.class.getName() + " getMatch(" + Terminal.class.getName() + " t," + InputPosition.class.getName() + " pp," + InputPosition.class.getName() + " pf," + ArrayList.class.getName() + "<" + QScannerMatchData.class.getName() + "> l)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return newlong(t,pp,pf,l);\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    protected " + QScannerStateInfo.class.getName() + " getStateInfo(int state)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        return staticStateInfo[state];\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "    protected String runSemanticAction(" + Terminal.class.getName() + " token)\n");
        out.print(linePrefix + "    {\n");
        out.print(linePrefix + "        String yytext = token.getLexeme();\n");
        out.print(linePrefix + "        if(yytext == null) return \"\";\n");
        for (Symbol symbol : this.regexes.keySet()) {
            String string = this.regexes.get(symbol).getSemanticAction();
            if (string == null) continue;
            out.print(linePrefix + "        else if(token.getId().equals(" + Symbol.class.getName() + ".symbol(\"" + symbol + "\")))\n");
            out.print(linePrefix + "        {\n");
            out.print(linePrefix + string + "\n");
            out.print(linePrefix + "        }\n");
        }
        out.print(linePrefix + "        return yytext;\n");
        out.print(linePrefix + "    }\n");
        out.print(linePrefix + "\n");
        out.print(ancillaries);
        out.print(linePrefix + "\n");
        out.print(linePrefix + "}\n");
        return stateInfo;
    }
}

