grammar silver:compiler:modification:copper_mda;

imports silver:compiler:definition:core;
imports silver:compiler:definition:env;
imports silver:compiler:definition:concrete_syntax;
imports silver:compiler:definition:concrete_syntax:ast;
imports silver:compiler:definition:flow:env;
imports silver:compiler:modification:copper;

import silver:compiler:driver:util only computeDependencies, RootSpec;


terminal CopperMDA 'copper_mda' lexer classes {KEYWORD};

concrete production copperMdaDcl
top::AGDcl ::= 'copper_mda' testname::Name '(' orig::QName ')' '{' m::ParserComponents '}'
{
  top.unparse = "";
  
  propagate config, grammarName, compiledGrammars, grammarDependencies, env, flowEnv, errors, moduleNames;
  
  top.errors <- orig.lookupValue.errors;
  
  local spec :: [ParserSpec] = 
    if !orig.lookupValue.found then []
    else findSpec(orig.lookupValue.fullName, 
      head(searchEnvTree(orig.lookupValue.dcl.sourceGrammar, top.compiledGrammars)).parserSpecs);
  
  top.errors <- if !orig.lookupValue.found || !null(spec) then []
                else [err(orig.location, orig.name ++ " is not a parser.")];

  -- Ignoring prefixes and any SyntaxDcls generated by the ParserComponents for now...
  top.mdaSpecs =
    case spec of
    | parserSpec(fn,snt,hg,csl,_,_,_) :: _ -> [mdaSpec(top.grammarName ++":"++ testname.name, snt,
        hg, m.moduleNames, csl, location=top.location, sourceGrammar=top.grammarName)]
    | _ -> []
    end;
}

function findSpec
[ParserSpec] ::= n::String s::[ParserSpec]
{
  return if null(s) then []
         else if n == head(s).fullName then [head(s)]
         else findSpec(n, tail(s));
}

nonterminal MdaSpec with location, sourceGrammar, fullName, compiledGrammars,cstAst;

abstract production mdaSpec
top::MdaSpec ::= fn::String  snt::String  hostgrams::[String]  extgrams::[String]  customStartLayout::Maybe<[String]>
{
  top.fullName = fn;
  
  -- TODO: see TODO s in ParserSpec
  production hostmed :: ModuleExportedDefs =
    moduleExportedDefs(error("no sl"), top.compiledGrammars,
      computeDependencies(hostgrams ++ extgrams, top.compiledGrammars), hostgrams, []);

  production extmed :: ModuleExportedDefs =
    moduleExportedDefs(error("no sl"), top.compiledGrammars,
      computeDependencies(hostgrams ++ extgrams, top.compiledGrammars), extgrams, []);

  top.cstAst = 
    cstCopperMdaRoot(fn, snt,
      foldr(consSyntax, nilSyntax(), hostmed.syntaxAst),
      foldr(consSyntax, nilSyntax(), extmed.syntaxAst),
      customStartLayout, location=top.location,
      sourceGrammar=top.sourceGrammar);
}

