/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.imp.builders;

import common.ConsCell;
import common.DecoratedNode;
import common.IOToken;
import common.OriginContext;
import common.javainterop.ConsCellCollection;
import edu.umn.cs.melt.ide.silver.misc.Problem;
import edu.umn.cs.melt.ide.silver.property.ProjectProperties;
import edu.umn.cs.melt.ide.util.ReflectedCall;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import silver.core.Init;
import silver.core.NIOVal;
import silver.langutil.NMessage;

public class Builder
extends IncrementalProjectBuilder
implements IExecutableExtension {
    private ReflectedCall<NIOVal> sv_build;
    private ReflectedCall<NIOVal> sv_postbuild;
    private String markerName;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String postbuild;
        if (!(data instanceof Hashtable)) {
            return;
        }
        Hashtable d = (Hashtable)data;
        this.markerName = (String)d.get("markerName");
        String build = (String)d.get("silver_build");
        if (build != null) {
            this.sv_build = new ReflectedCall(build, 3);
        }
        if ((postbuild = (String)d.get("silver_postbuild")) != null) {
            this.sv_postbuild = new ReflectedCall(postbuild, 3);
        }
    }

    protected synchronized IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        final IProject project = this.getProject();
        IFolder gen_folder = project.getFolder("bin");
        if (!gen_folder.exists()) {
            gen_folder.create(5121, true, null);
        }
        final ProjectProperties properties = ProjectProperties.getPropertyPersister(project.getLocation().toString());
        NIOVal undecorated_build_result = this.sv_build.invoke(new Object[]{OriginContext.FFI_CONTEXT, project, properties.serializeToSilverType(), IOToken.singleton});
        DecoratedNode build_result = undecorated_build_result.decorate();
        build_result.synthesized(Init.silver_core_io__ON__silver_core_IOVal);
        ConsCell errors = (ConsCell)build_result.synthesized(Init.silver_core_iovalue__ON__silver_core_IOVal);
        project.deleteMarkers(this.markerName, true, 2);
        boolean stopBuild = Builder.renderMessages(errors, project, this.markerName);
        if (stopBuild || this.sv_postbuild == null) {
            return new IProject[0];
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        final Builder lock = this;
        Runnable thread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Builder builder = lock;
                synchronized (builder) {
                    NIOVal undecorate_post_result = (NIOVal)Builder.this.sv_postbuild.invoke(new Object[]{OriginContext.FFI_CONTEXT, project, properties.serializeToSilverType(), IOToken.singleton});
                    DecoratedNode post_result = undecorate_post_result.decorate();
                    post_result.synthesized(Init.silver_core_io__ON__silver_core_IOVal);
                    ConsCell post_errors = (ConsCell)post_result.synthesized(Init.silver_core_iovalue__ON__silver_core_IOVal);
                    try {
                        Builder.renderMessages(post_errors, project, Builder.this.markerName);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        new Thread(thread).start();
        return new IProject[0];
    }

    public static boolean renderMessages(ConsCell errors, IProject project, String markerName) throws CoreException {
        boolean stopBuild = false;
        for (NMessage msg : new ConsCellCollection(errors)) {
            Problem p = Problem.extractProblem(msg);
            p.createMarker(project, markerName);
            boolean bl = stopBuild = stopBuild || p.buildBlocker();
        }
        return stopBuild;
    }
}

