/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.ide.wizard;

import common.ConsCell;
import common.StringCatter;
import edu.umn.cs.melt.ide.impl.SVRegistry;
import edu.umn.cs.melt.ide.silver.property.Property;
import edu.umn.cs.melt.ide.silver.property.ui.IPropertyControlsProvider;
import edu.umn.cs.melt.ide.silver.property.ui.PropertyControl;
import ide.PmakeIdeProperty;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.runtime.PluginBase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewSourceFilePage
extends WizardPage {
    private IResource parentResource;
    private Composite panel;
    private Text parentFolderText;
    private Text fileNameText;
    private StructuredViewer tv;
    private IPropertyControlsProvider provider = SVRegistry.get().getNewFileProperties();
    private IStructuredSelection initialSelection;
    private List<PropertyControl> propertyControls;
    private boolean hasTriedFinishing = false;

    public NewSourceFilePage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.initialSelection = selection;
    }

    public void createControl(Composite parent) {
        GridLayout gdLayoutC1 = new GridLayout();
        gdLayoutC1.numColumns = 1;
        GridLayout gdLayoutC2 = new GridLayout();
        gdLayoutC2.numColumns = 2;
        FillLayout fillLayout = new FillLayout();
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)gdLayoutC1);
        this.panel.setLayoutData((Object)new GridData(1808));
        Label r1_label = new Label(this.panel, 0);
        r1_label.setText("Enter or select the parent folder:");
        this.parentFolderText = new Text(this.panel, 2048);
        this.parentFolderText.setLayoutData((Object)new GridData(768));
        this.parentFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSourceFilePage.this.updatePageComplete();
            }
        });
        Composite sub_panel_projs = new Composite(this.panel, 0);
        sub_panel_projs.setLayout((Layout)gdLayoutC1);
        sub_panel_projs.setLayoutData((Object)new GridData(1808));
        Composite panel_3 = new Composite(sub_panel_projs, 0);
        panel_3.setLayoutData((Object)new GridData(1808));
        panel_3.setLayout((Layout)fillLayout);
        this.tv = new TreeViewer(panel_3, 2052);
        this.tv.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.tv.setContentProvider((IContentProvider)new ResourceTreeProvider());
        this.tv.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        this.tv.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProject project;
                return element instanceof IProject ? NewSourceFilePage.this.hasValidNature(project = (IProject)element) : element instanceof IFolder;
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                IResource resource = (IResource)sel.getFirstElement();
                NewSourceFilePage.this.parentResource = resource;
                NewSourceFilePage.this.updateParentFolderText();
            }
        });
        this.updateParentFolderText();
        Composite sub_panel_file = new Composite(this.panel, 0);
        sub_panel_file.setLayout((Layout)gdLayoutC2);
        sub_panel_file.setLayoutData((Object)new GridData(1808));
        Label r2_label = new Label(sub_panel_file, 0);
        r2_label.setText("File name:");
        this.fileNameText = new Text(sub_panel_file, 2048);
        this.fileNameText.setLayoutData((Object)new GridData(768));
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSourceFilePage.this.updatePageComplete();
            }
        });
        Composite sub_panel_properties = new Composite(this.panel, 0);
        sub_panel_properties.setLayout((Layout)gdLayoutC2);
        sub_panel_properties.setLayoutData((Object)new GridData(1808));
        this.propertyControls = this.provider.getPropertyControls(sub_panel_properties);
        if (this.propertyControls != null) {
            for (PropertyControl control : this.propertyControls) {
                Control info = control.getInfoControl();
                Control input = control.getInputControl();
                info.setLayoutData((Object)new GridData());
                input.setLayoutData((Object)new GridData(768));
                if (!(input instanceof Text)) continue;
                Text text = (Text)input;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        NewSourceFilePage.this.updatePageComplete();
                    }
                });
            }
        }
        this.setControl((Control)this.panel);
        this.setPageComplete(false);
        this.initialize();
    }

    IResource getParentFolder() {
        return this.parentResource;
    }

    String getFileName() {
        return this.fileNameText.getText();
    }

    ConsCell getNIdePerpertyArray() {
        ConsCell list = ConsCell.nil;
        for (PropertyControl control : this.propertyControls) {
            Property prop = control.getProperty();
            PmakeIdeProperty item = new PmakeIdeProperty((Object)new StringCatter(prop.getName()), (Object)new StringCatter(prop.getType().name()), (Object)new StringCatter(prop.getSValue()));
            list = new ConsCell((Object)item, (Object)list);
        }
        return list;
    }

    private void updateParentFolderText() {
        if (this.parentResource != null) {
            if (this.parentResource instanceof IProject) {
                this.parentFolderText.setText(this.parentResource.getName());
            } else {
                this.parentFolderText.setText(String.valueOf(this.parentResource.getProject().getName()) + '/' + this.parentResource.getProjectRelativePath());
            }
        }
    }

    boolean attemptCompletion() {
        this.hasTriedFinishing = true;
        return this.updatePageComplete();
    }

    private boolean updatePageComplete() {
        if (!this.hasTriedFinishing) {
            this.setPageComplete(true);
            return true;
        }
        if (this.parentFolderText == null || this.fileNameText == null) {
            this.setPageComplete(false);
            return false;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String parentRelPath = this.parentFolderText.getText();
        if (parentRelPath == null || "".equals(parentRelPath)) {
            this.setPageComplete(false);
            this.setErrorMessage("the parent folder is not set");
            return false;
        }
        String parentAbsPath = root.getFullPath().append(parentRelPath).toPortableString();
        IPath parentResPath = Path.fromPortableString((String)parentAbsPath);
        if (this.isProject(parentRelPath)) {
            IProject[] projects = root.getProjects();
            boolean found = false;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                if (proj.getName().equals(parentRelPath)) {
                    found = true;
                    this.parentResource = proj;
                    break;
                }
                ++n2;
            }
            if (!found) {
                this.setPageComplete(false);
                this.setErrorMessage("the project '" + parentResPath + "' doesn't exist");
                return false;
            }
            if (!this.hasValidNature((IProject)this.parentResource)) {
                this.setPageComplete(false);
                this.setErrorMessage("the project '" + parentResPath + "' is not a " + SVRegistry.get().name() + " project");
                return false;
            }
        } else {
            IFolder folder = null;
            try {
                folder = root.getFolder(parentResPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (folder == null) {
                this.setPageComplete(false);
                this.setErrorMessage("the parent folder '" + parentResPath + "' is invalid");
                return false;
            }
            if (!folder.exists()) {
                this.setPageComplete(false);
                this.setErrorMessage("the parent folder '" + parentResPath + "' doesn't exist");
                return false;
            }
        }
        if (this.fileNameText.getText() == null || "".equals(this.fileNameText.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("the file name is not set");
            return false;
        }
        if (!this.provider.validateAll()) {
            this.setErrorMessage("Invalid properties");
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    private boolean isProject(String parentRelPath) {
        int firstSplitter = parentRelPath.indexOf(47);
        if (firstSplitter == -1) {
            return true;
        }
        char[] chars = parentRelPath.substring(firstSplitter).toCharArray();
        boolean hasOnlySeparater = true;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '/') {
                hasOnlySeparater = false;
                break;
            }
            ++n2;
        }
        return hasOnlySeparater;
    }

    private boolean hasValidNature(IProject project) {
        try {
            if (project.hasNature(SVRegistry.get().getNatureId())) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private void initialize() {
        if (this.initialSelection != null) {
            Object element = this.initialSelection.getFirstElement();
            if (element instanceof IProject) {
                this.parentResource = (IProject)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                Object adapter = adaptable.getAdapter(IResource.class);
                this.parentResource = (IResource)adapter;
            }
        }
        if (this.parentResource != null) {
            this.updateParentFolderText();
        }
    }

    private static class ResourceLabelProvider
    extends LabelProvider {
        private static final ImageDescriptor FLDR = PluginBase.imageDescriptorFromPlugin((String)SVRegistry.get().pluginId(), (String)"icons/fldr_obj.gif");
        private static Image FLDR_IMG;

        private ResourceLabelProvider() {
        }

        public Image getImage(Object resource) {
            if (FLDR_IMG == null) {
                FLDR_IMG = FLDR.createImage();
            }
            return FLDR_IMG;
        }

        public String getText(Object resource) {
            IResource res = (IResource)resource;
            return res.getName();
        }
    }

    private static class ResourceTreeProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private ResourceTreeProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                try {
                    return project.members();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (parentElement instanceof IFolder) {
                IFolder folder = (IFolder)parentElement;
                try {
                    return folder.members();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                return folder.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IProject || element instanceof IFolder;
        }
    }
}

