/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.pipeline;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.InterfaceErrorMessage;
import edu.umn.cs.melt.copper.compiletime.pipeline.AuxiliaryMethods;
import edu.umn.cs.melt.copper.compiletime.pipeline.Pipeline;
import edu.umn.cs.melt.copper.compiletime.pipeline.SourceBuilder;
import edu.umn.cs.melt.copper.compiletime.pipeline.SourceBuilderParameters;
import edu.umn.cs.melt.copper.compiletime.pipeline.SpecCompiler;
import edu.umn.cs.melt.copper.compiletime.pipeline.SpecCompilerParameters;
import edu.umn.cs.melt.copper.compiletime.pipeline.SpecParser;
import edu.umn.cs.melt.copper.compiletime.pipeline.SpecParserParameters;
import edu.umn.cs.melt.copper.main.CopperIOType;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;

public class StandardPipeline<SCIN, SCOUT>
implements Pipeline,
SpecParser<SCIN>,
SpecCompiler<SCIN, SCOUT>,
SourceBuilder<SCOUT> {
    private HashSet<String> customSwitches;
    private SpecParser<SCIN> specParser;
    private SpecCompiler<SCIN, SCOUT> specCompiler;
    private SourceBuilder<SCOUT> sourceBuilder;

    public StandardPipeline(SpecParser<SCIN> specParser, SpecCompiler<SCIN, SCOUT> specCompiler, SourceBuilder<SCOUT> sourceBuilder) {
        this.specParser = specParser;
        this.specCompiler = specCompiler;
        this.sourceBuilder = sourceBuilder;
        this.customSwitches = new HashSet();
        Set<String> buf = specParser.getCustomSwitches();
        if (buf != null) {
            this.customSwitches.addAll(buf);
        }
        if ((buf = specCompiler.getCustomSwitches()) != null) {
            this.customSwitches.addAll(buf);
        }
        if ((buf = sourceBuilder.getCustomSwitches()) != null) {
            this.customSwitches.addAll(buf);
        }
    }

    @Override
    public int execute(ParserCompilerParameters args) throws IOException, CopperException {
        Object spec = null;
        Object constructs = null;
        int errorlevel = 1;
        if (args.isAvoidRecompile()) {
            CompilerLogger logger = AuxiliaryMethods.getOrMakeLogger(args);
            int result = this.checkIsRecompilation(args);
            if (result == -1) {
                logger.log(new GenericMessage(CompilerLevel.REGULAR, "Parser '" + args.getOutputFile() + "' is up-to-date"));
                return 0;
            }
            if (result != 0) {
                return 1;
            }
        }
        if ((spec = (Object)this.specParser.parseSpec(args)) != null) {
            constructs = this.specCompiler.compileParser(spec, args);
        }
        if (constructs != null) {
            errorlevel = this.sourceBuilder.buildSource(constructs, args);
        }
        return errorlevel;
    }

    public int execute(SCIN spec, ParserCompilerParameters args) throws CopperException {
        Object constructs = null;
        int errorlevel = 1;
        constructs = this.specCompiler.compileParser(spec, args);
        if (constructs != null) {
            errorlevel = this.sourceBuilder.buildSource(constructs, args);
        }
        return errorlevel;
    }

    private int checkIsRecompilation(ParserCompilerParameters args) {
        long latestInputModification = 1L;
        for (Pair<String, Object> input : args.getInputs()) {
            if (input.second() instanceof Reader) {
                args.getLogger().log(new InterfaceErrorMessage("When the 'avoidRecompile' option is set, all inputs must be files"));
                return 1;
            }
            File f = new File(input.second().toString());
            if (!f.exists()) {
                args.getLogger().log(new InterfaceErrorMessage("Grammar file not found: '" + input.second() + "'"));
                continue;
            }
            if (f.lastModified() == 0L) {
                args.getLogger().log(new InterfaceErrorMessage("Error reading modification time for input file '" + input.second() + "'"));
                continue;
            }
            latestInputModification = Math.max(latestInputModification, f.lastModified());
        }
        if (args.getOutputType() != CopperIOType.FILE || args.getOutputFile() == null) {
            args.getLogger().log(new InterfaceErrorMessage("When the 'avoidRecompile' option is set, the output must be a file"));
            return 1;
        }
        if (!args.getOutputFile().exists()) {
            return 0;
        }
        if (args.getOutputFile().lastModified() == 0L) {
            args.getLogger().log(new InterfaceErrorMessage("Error reading modification time for output file '" + args.getOutputFile() + "'"));
            return 1;
        }
        if (latestInputModification < args.getOutputFile().lastModified()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int buildSource(SCOUT constructs, SourceBuilderParameters args) throws CopperException {
        return this.sourceBuilder.buildSource(constructs, args);
    }

    @Override
    public SCOUT compileParser(SCIN spec, SpecCompilerParameters args) throws CopperException {
        return this.specCompiler.compileParser(spec, args);
    }

    @Override
    public SCIN parseSpec(SpecParserParameters args) throws IOException, CopperException {
        return this.specParser.parseSpec(args);
    }

    @Override
    public Set<String> getCustomSwitches() {
        return this.customSwitches;
    }

    @Override
    public String customSwitchUsage() {
        String rv = "";
        if (this.specParser != null) {
            rv = rv + this.specParser.customSwitchUsage();
        }
        if (this.specCompiler != null) {
            rv = rv + this.specCompiler.customSwitchUsage();
        }
        if (this.sourceBuilder != null) {
            rv = rv + this.sourceBuilder.customSwitchUsage();
        }
        return rv;
    }

    @Override
    public int processCustomSwitch(ParserCompilerParameters args, String[] cmdline, int index) {
        int rv = this.specParser.processCustomSwitch(args, cmdline, index);
        if (rv != -1) {
            return rv;
        }
        rv = this.specCompiler.processCustomSwitch(args, cmdline, index);
        if (rv != -1) {
            return rv;
        }
        rv = this.sourceBuilder.processCustomSwitch(args, cmdline, index);
        if (rv != -1) {
            return rv;
        }
        return -1;
    }
}

