/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.auxiliary;

import edu.umn.cs.melt.copper.legacy.compiletime.auxiliary.Mergable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DynHashSet<E extends Mergable<? super E>>
implements Iterable<E>,
Mergable<DynHashSet<E>> {
    private HashSet<E> elements = new HashSet();
    private Hashtable<E, E> accessibleElements = new Hashtable();
    private boolean intersectP;

    public DynHashSet() {
        this.intersectP = false;
    }

    public boolean addAll(Iterable<? extends E> coll) {
        boolean rv = false;
        for (Mergable elem : coll) {
            rv = this.put(elem) || rv;
        }
        return rv;
    }

    public DynHashSet(DynHashSet<E> hs) {
        this.intersectP = hs.intersectP;
        for (Mergable element : hs.elements) {
            this.put(element);
        }
    }

    public boolean put(E o) {
        if (!this.elements.contains(o)) {
            this.elements.add(o);
            this.accessibleElements.put(o, o);
            return true;
        }
        Mergable alreadyIn = (Mergable)this.accessibleElements.get(o);
        this.elements.remove(o);
        this.accessibleElements.remove(o);
        boolean rv = this.intersectP ? alreadyIn.intersect(o) : alreadyIn.union(o);
        this.elements.add(alreadyIn);
        this.accessibleElements.put(alreadyIn, alreadyIn);
        return rv;
    }

    public boolean remove(E o) {
        if (this.elements.contains(o)) {
            this.elements.remove(o);
            this.accessibleElements.remove(o);
            return true;
        }
        return false;
    }

    public E get(E o) {
        return (E)((Mergable)this.accessibleElements.get(o));
    }

    public boolean contains(E o) {
        return this.elements.contains(o);
    }

    public int size() {
        return this.elements.size();
    }

    public void clear() {
        this.elements.clear();
        this.accessibleElements.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new DynIterator(this);
    }

    @Override
    public boolean union(DynHashSet<E> rhs) {
        int oldSize = this.size();
        for (Mergable element : rhs.elements) {
            this.put(element);
        }
        return oldSize != this.size();
    }

    @Override
    public boolean intersect(DynHashSet<E> rhs) {
        int oldSize = this.size();
        HashSet<Mergable> newElements = new HashSet<Mergable>();
        for (Mergable cur : this.elements) {
            if (rhs.contains(cur)) {
                newElements.add(cur);
                continue;
            }
            this.accessibleElements.remove(cur);
        }
        this.elements = newElements;
        return oldSize != this.size();
    }

    public boolean equals(Object o) {
        DynHashSet drhs = null;
        try {
            drhs = (DynHashSet)o;
        }
        catch (ClassCastException ex) {
            System.err.println("Cast Exception");
            return false;
        }
        return this.safe_equals(drhs);
    }

    private boolean safe_equals(DynHashSet<E> rhs) {
        if (this.size() != rhs.size()) {
            return false;
        }
        return this.elements.equals(rhs.elements);
    }

    public String toString() {
        return this.elements.toString();
    }

    private class DynIterator
    implements Iterator<E> {
        public Iterator<E> underIterator;
        E lastReturned;

        public DynIterator(DynHashSet<E> newSet) {
            this.underIterator = DynHashSet.this.elements.iterator();
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            return this.underIterator.hasNext();
        }

        @Override
        public E next() throws NoSuchElementException {
            this.lastReturned = (Mergable)this.underIterator.next();
            return this.lastReturned;
        }

        @Override
        public void remove() throws IllegalStateException {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Invalid context");
            }
            DynHashSet.this.accessibleElements.remove(this.lastReturned);
            this.underIterator.remove();
            this.lastReturned = null;
        }
    }
}

