/*
 * Decompiled with CFR 0.152.
 */
package common.rawlib;

import common.ConsCell;
import common.StringCatter;
import common.exceptions.SilverError;
import common.exceptions.SilverInternalError;
import common.exceptions.TraceException;
import common.javainterop.ConsCellCollection;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import silver.core.NPair;
import silver.core.NParseResult;
import silver.core.PparseFailed;
import silver.core.PparseSucceeded;
import silver.xml.ast.NXMLAttribute;
import silver.xml.ast.NXMLDocument;
import silver.xml.ast.NXMLDocumentType;
import silver.xml.ast.NXMLNode;
import silver.xml.ast.NXMLNodeList;
import silver.xml.ast.PxmlAttribute;
import silver.xml.ast.PxmlDocument;
import silver.xml.ast.PxmlDocumentType;
import silver.xml.ast.PxmlNoDocumentType;
import silver.xml.ast.PxmlNodeElement;
import silver.xml.ast.PxmlNodeListCons;
import silver.xml.ast.PxmlNodeListNil;
import silver.xml.ast.PxmlNodeText;

public final class RawXML {
    private static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder parser;

    private static final void ensureParserSetup() {
        if (parser == null) {
            try {
                dbFactory.setCoalescing(true);
                dbFactory.setIgnoringComments(true);
                dbFactory.setValidating(false);
                dbFactory.setNamespaceAware(true);
                dbFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                parser = dbFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new SilverInternalError("Unexpected error initializing XML parser", pce);
            }
        }
    }

    public static final NParseResult parseXMLFileN(StringCatter fn) {
        Document d;
        RawXML.ensureParserSetup();
        try {
            d = parser.parse(new File(fn.toString()));
        }
        catch (IOException e) {
            throw new TraceException("IO error while parsing xml file " + fn.toString(), e);
        }
        catch (SAXException e) {
            return new PparseFailed((Object)new StringCatter(e.toString()), null);
        }
        return new PparseSucceeded((Object)RawXML.documentF2N(d), null);
    }

    public static final NParseResult parseXMLFileF(StringCatter fn) {
        Document d;
        RawXML.ensureParserSetup();
        try {
            d = parser.parse(new File(fn.toString()));
        }
        catch (IOException e) {
            throw new TraceException("IO error while parsing xml file " + fn.toString(), e);
        }
        catch (SAXException e) {
            return new PparseFailed((Object)new StringCatter(e.toString()), null);
        }
        return new PparseSucceeded((Object)d, null);
    }

    public static final NXMLDocument documentF2N(Document d) {
        DocumentType dt = d.getDoctype();
        NodeList nl = d.getChildNodes();
        Object sdt = dt != null ? new PxmlDocumentType((Object)new StringCatter(dt.getName()), (Object)RawXML.nodeListF2N(dt.getChildNodes())) : new PxmlNoDocumentType();
        return new PxmlDocument(sdt, (Object)RawXML.nodeListF2N(nl));
    }

    public static final Document documentN2F(NXMLDocument docAst) {
        RawXML.ensureParserSetup();
        Document docContext = parser.newDocument();
        RawXML.deconvertXmlAstDocument(docAst, docContext);
        return docContext;
    }

    public static final StringCatter documentF2String(Document document) {
        Transformer transformer;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            throw new RuntimeException(e1);
        }
        StringWriter sw = new StringWriter();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return new StringCatter(sw.toString());
    }

    public static final NodeList xpathQueryNodeSet(Object document, String querystring, ConsCell namespace) {
        try {
            XPathFactory xpfactory = XPathFactory.newInstance();
            XPath xp = xpfactory.newXPath();
            if (namespace != null && !namespace.nil()) {
                xp.setNamespaceContext(new PairListNSContext(namespace));
            }
            XPathExpression xpe = xp.compile(querystring);
            return (NodeList)xpe.evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new TraceException("While evaluating XPath expression", e);
        }
    }

    public static final StringCatter xpathQueryString(Object document, String querystring, ConsCell namespace) {
        try {
            XPathFactory xpfactory = XPathFactory.newInstance();
            XPath xp = xpfactory.newXPath();
            if (namespace != null && !namespace.nil()) {
                xp.setNamespaceContext(new PairListNSContext(namespace));
            }
            XPathExpression xpe = xp.compile(querystring);
            return new StringCatter((String)xpe.evaluate(document, XPathConstants.STRING));
        }
        catch (XPathExpressionException e) {
            throw new TraceException("While evaluating XPath expression", e);
        }
    }

    public static final NXMLNodeList nodeListF2N(NodeList nl) {
        PxmlNodeListNil l = new PxmlNodeListNil();
        block5: for (int i = nl.getLength() - 1; i >= 0; --i) {
            Node n = nl.item(i);
            switch (n.getNodeType()) {
                case 3: 
                case 4: {
                    StringCatter val = new StringCatter(n.getNodeValue());
                    l = new PxmlNodeListCons((Object)new PxmlNodeText((Object)val), (Object)l);
                    continue block5;
                }
                case 1: 
                case 6: {
                    StringCatter name = new StringCatter(n.getNodeName());
                    ConsCell attrs = RawXML.attributesF2N(n.getAttributes());
                    NXMLNodeList children = RawXML.nodeListF2N(n.getChildNodes());
                    l = new PxmlNodeListCons((Object)new PxmlNodeElement((Object)name, (Object)attrs, (Object)children), (Object)l);
                    continue block5;
                }
                case 8: 
                case 10: {
                    continue block5;
                }
                default: {
                    throw new SilverError("Unexpected type of XML node! " + n.getNodeType() + n.getNodeName() + n.toString());
                }
            }
        }
        return l;
    }

    public static final ConsCell nodeListF2NPartial(NodeList nl) {
        ConsCell l = ConsCell.nil;
        for (int i = nl.getLength() - 1; i >= 0; --i) {
            l = new ConsCell(nl.item(i), l);
        }
        return l;
    }

    private static final ConsCell attributesF2N(NamedNodeMap al) {
        ConsCell l = ConsCell.nil;
        for (int i = 0; i < al.getLength(); ++i) {
            Node n = al.item(i);
            StringCatter key = new StringCatter(n.getNodeName());
            StringCatter value = new StringCatter(n.getNodeValue());
            l = new ConsCell(new PxmlAttribute((Object)key, (Object)value), l);
        }
        return l;
    }

    private static final void deconvertXmlAstDocument(NXMLDocument docAst, Document docContext) {
        NXMLDocumentType dt = (NXMLDocumentType)docAst.getChild(0);
        NXMLNodeList nl = (NXMLNodeList)docAst.getChild(1);
        RawXML.mutateDocumentType(dt, docContext);
        RawXML.mutateXmlAstNodeList(nl, docContext, docContext);
    }

    private static final void mutateDocumentType(NXMLDocumentType docTypeAst, Document docContext) {
        if (!(docTypeAst instanceof PxmlNoDocumentType) && !(docTypeAst instanceof PxmlDocumentType)) {
            throw new SilverInternalError("Unknown type in XML AST during unparse of doctype...");
        }
    }

    private static final void mutateXmlAstNodeList(NXMLNodeList docNLAst, Node nodeContext, Document docContext) {
        NXMLNodeList current = docNLAst;
        while (current instanceof PxmlNodeListCons) {
            Node n = RawXML.deconvertXmlAstNode((NXMLNode)current.getChild(0), docContext);
            nodeContext.appendChild(n);
            current = (NXMLNodeList)current.getChild(1);
        }
    }

    private static final Node deconvertXmlAstNode(NXMLNode docNodeAst, Document docContext) {
        if (docNodeAst instanceof PxmlNodeElement) {
            StringCatter sc = (StringCatter)docNodeAst.getChild(0);
            ConsCell at = (ConsCell)docNodeAst.getChild(1);
            NXMLNodeList nl = (NXMLNodeList)docNodeAst.getChild(2);
            Element n = docContext.createElement(sc.toString());
            RawXML.mutateAttributes(at, n, docContext);
            RawXML.mutateXmlAstNodeList(nl, n, docContext);
            return n;
        }
        if (docNodeAst instanceof PxmlNodeText) {
            StringCatter sc = (StringCatter)docNodeAst.getChild(0);
            Text t = docContext.createTextNode(sc.toString());
            return t;
        }
        throw new SilverInternalError("Unknown type in XML AST during unparse of node...");
    }

    private static final void mutateAttributes(ConsCell docAttrsAst, Element elem, Document docContext) {
        ConsCell current = docAttrsAst;
        while (!current.nil()) {
            NXMLAttribute at = (NXMLAttribute)current.head();
            elem.setAttribute(at.getChild(0).toString(), at.getChild(1).toString());
            current = current.tail();
        }
    }

    public static class PairListNSContext
    implements NamespaceContext {
        private final Map<String, String> resolver = new TreeMap<String, String>();

        public PairListNSContext(ConsCell current) {
            for (NPair elem : new ConsCellCollection(current)) {
                String fst = elem.getAnno_silver_core_fst().toString();
                String snd = elem.getAnno_silver_core_snd().toString();
                this.resolver.put(fst, snd);
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            String result = this.resolver.get(prefix);
            if (result != null) {
                return result;
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

