/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.semantics.lalr1;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarName;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1DFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1State;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1StateItem;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.HashSet;

public class ComposabilityChecker {
    public CompilerLogger logger;

    public static boolean isWanted(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, GrammarSymbol gs) {
        if (gs instanceof Terminal) {
            return wantedGrammars.contains(grammar.getOwner((Terminal)gs));
        }
        if (gs instanceof NonTerminal) {
            return wantedGrammars.contains(grammar.getOwner((NonTerminal)gs));
        }
        return false;
    }

    public static boolean isWanted(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, Terminal t) {
        return wantedGrammars.contains(grammar.getOwner(t));
    }

    public static boolean isWanted(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, NonTerminal nt) {
        return wantedGrammars.contains(grammar.getOwner(nt));
    }

    public static boolean isWanted(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, Production p) {
        return wantedGrammars.contains(grammar.getOwner(p));
    }

    public static boolean isWanted(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, LALR1StateItem item) {
        return ComposabilityChecker.isWanted(grammar, wantedGrammars, item.getProd()) || ComposabilityChecker.isValidBridgeItem(grammar, wantedGrammars, item);
    }

    public static boolean isBridgeProd(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, Production p) {
        return !ComposabilityChecker.isWanted(grammar, wantedGrammars, p) && ComposabilityChecker.isWanted(grammar, wantedGrammars, p.getLeft());
    }

    public static boolean isValidBridgeProd(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, Production p) {
        return ComposabilityChecker.isBridgeProd(grammar, wantedGrammars, p) && !ComposabilityChecker.isWanted(grammar, wantedGrammars, p.getSymbol(0)) && p.length() >= 1 && p.getSymbol(0) instanceof Terminal;
    }

    public static boolean isBridgeItem(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, LALR1StateItem item) {
        return ComposabilityChecker.isBridgeProd(grammar, wantedGrammars, item.getProd()) && item.isBeginning();
    }

    public static boolean isValidBridgeItem(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, LALR1StateItem item) {
        return ComposabilityChecker.isValidBridgeProd(grammar, wantedGrammars, item.getProd()) && item.isBeginning();
    }

    public static boolean isInvalidBridgeItem(GrammarSource grammar, HashSet<GrammarName> wantedGrammars, LALR1StateItem item) {
        return ComposabilityChecker.isBridgeItem(grammar, wantedGrammars, item) && !ComposabilityChecker.isValidBridgeItem(grammar, wantedGrammars, item);
    }

    public static GrammarSource extractWantedGrammars(GrammarSource grammar, HashSet<GrammarName> wantedGrammars) {
        GrammarSource newGS = new GrammarSource();
        for (NonTerminal nt : grammar.getNT()) {
            if (!ComposabilityChecker.isWanted(grammar, wantedGrammars, nt)) continue;
            newGS.addToNT(nt);
            if (grammar.hasNTAttributes(nt)) {
                newGS.addNTAttributes(nt, grammar.getNTAttributes(nt));
            }
            if (!grammar.pContains(nt)) continue;
            for (Production p : grammar.getP(nt)) {
                if (ComposabilityChecker.isWanted(grammar, wantedGrammars, p)) {
                    newGS.addToP(p);
                    if (grammar.hasProductionAttributes(p)) {
                        newGS.addProductionAttributes(p, grammar.getProductionAttributes(p));
                    }
                }
                if (!ComposabilityChecker.isValidBridgeProd(grammar, wantedGrammars, p)) continue;
                newGS.addToT((Terminal)p.getSymbol(0));
                newGS.addToP(p);
                if (!grammar.hasProductionAttributes(p)) continue;
                newGS.addProductionAttributes(p, grammar.getProductionAttributes(p));
            }
        }
        for (Terminal t : grammar.getT()) {
            if (!ComposabilityChecker.isWanted(grammar, wantedGrammars, t)) continue;
            newGS.addToT(t);
            if (grammar.hasRegex(t)) {
                newGS.addRegex(t, grammar.getRegex(t));
            }
            if (grammar.hasLexicalAttributes(t)) {
                newGS.addLexicalAttributes(t, grammar.getLexicalAttributes(t));
            }
            if (!grammar.hasOperatorAttributes(t)) continue;
            newGS.addOperatorAttributes(t, grammar.getOperatorAttributes(t));
        }
        newGS.constructPrecedenceRelationsGraph();
        for (Terminal t : grammar.getT()) {
            for (Terminal u : grammar.getT()) {
                if (!grammar.getPrecedenceRelationsGraph().hasEdge(t, u)) continue;
                newGS.addStaticPrecedenceRelation(t, u);
            }
        }
        if (ComposabilityChecker.isWanted(grammar, wantedGrammars, grammar.getStartSym())) {
            newGS.setStartSym(grammar.getStartSym());
        }
        for (GrammarName n : wantedGrammars) {
            newGS.addContainedGrammar(n);
        }
        return newGS;
    }

    public ComposabilityChecker(CompilerLogger logger) {
        this.logger = logger;
    }

    public boolean checkComposability(GrammarSource grammarHost, GrammarSource grammarHostAndExt, LALR1DFA host, LALR1DFA hostAndExt) throws CopperException {
        boolean passed = true;
        for (NonTerminal nt : grammarHost.getNT()) {
            if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
                this.logger.logTick(16, ".");
            }
            HashSet<Terminal> hostAndExtFollow = new HashSet<Terminal>(grammarHostAndExt.getContextSets().getFollow(nt));
            hostAndExtFollow.removeAll(grammarHost.getContextSets().getFollow(nt));
            if (grammarHost.getContextSets().getFollow(nt).containsAll(grammarHostAndExt.getContextSets().getFollow(nt))) continue;
            passed = false;
            this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "Nonterminal " + nt + " has follow spillage of\n" + PrettyPrinter.iterablePrettyPrint(hostAndExtFollow, "   ", 1) + "\n   from\n" + PrettyPrinter.iterablePrettyPrint(grammarHost.getContextSets().getFollow(nt), "   ", 1) + "\n   to\n" + PrettyPrinter.iterablePrettyPrint(grammarHostAndExt.getContextSets().getFollow(nt), "   ", 1));
        }
        for (LALR1State state : hostAndExt.getStates()) {
            if (this.logger.isLoggable(CompilerLogMessageSort.TICK)) {
                this.logger.logTick(16, ".");
            }
            if (host.getLabel(state) != -1) {
                for (LALR1StateItem item : state.getItems()) {
                    if (host.getLookahead(state, item).containsAll(hostAndExt.getLookahead(state, item))) continue;
                    passed = false;
                    if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) continue;
                    HashSet<Terminal> hostAndExtLA = new HashSet<Terminal>(hostAndExt.getLookahead(state, item));
                    hostAndExtLA.removeAll(host.getLookahead(state, item));
                    this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "DFA state " + hostAndExt.getLabel(state) + ", item " + item + " has lookahead spillage of\n" + PrettyPrinter.iterablePrettyPrint(hostAndExtLA, "   ", 1) + "\n   from\n" + PrettyPrinter.iterablePrettyPrint(host.getLookahead(state, item), "   ", 1) + "\n   to\n" + PrettyPrinter.iterablePrettyPrint(hostAndExt.getLookahead(state, item), "   ", 1));
                }
                continue;
            }
            boolean hasExtItem = false;
            GrammarName hostname = grammarHost.getHostGrammarName();
            HashSet<GrammarName> hostnameS = new HashSet<GrammarName>();
            hostnameS.add(hostname);
            for (LALR1StateItem item : state.getItems()) {
                if (!ComposabilityChecker.isWanted(grammarHostAndExt, hostnameS, item)) {
                    hasExtItem = true;
                }
                if (!ComposabilityChecker.isInvalidBridgeItem(grammarHostAndExt, hostnameS, item)) continue;
                passed = false;
                if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) continue;
                this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "DFA state " + hostAndExt.getLabel(state) + " has invalid bridge item " + item);
            }
            if (hasExtItem) continue;
            boolean isILSubset = false;
            for (LALR1State hstate : host.getStates()) {
                if (!state.isISubset(hstate)) continue;
                if (!LALR1DFA.isILSubset(state, hostAndExt.getLookaheadTables(state), hstate, hostAndExt.getLookaheadTables(state))) {
                    passed = false;
                    if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) break;
                    this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "DFA state " + hostAndExt.getLabel(state) + " is a new-host state and is an I-subset but not an IL-subset of state " + hostAndExt.getLabel(hstate));
                    break;
                }
                isILSubset = true;
            }
            if (isILSubset) continue;
            passed = false;
            if (!this.logger.isLoggable(CompilerLogMessageSort.ERROR)) continue;
            this.logger.logMessage(CompilerLogMessageSort.ERROR, null, "DFA state " + hostAndExt.getLabel(state) + " is a new-host state and not an IL-subset");
        }
        return passed;
    }
}

