/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.main;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericMessage;
import edu.umn.cs.melt.copper.compiletime.pipeline.AuxiliaryMethods;
import edu.umn.cs.melt.copper.compiletime.pipeline.FragmentGenerator;
import edu.umn.cs.melt.copper.compiletime.pipeline.FragmentGeneratorReturnData;
import edu.umn.cs.melt.copper.compiletime.pipeline.ParserFragments;
import edu.umn.cs.melt.copper.compiletime.pipeline.ParserFragmentsDeserializer;
import edu.umn.cs.melt.copper.compiletime.pipeline.ParserFragmentsPasser;
import edu.umn.cs.melt.copper.compiletime.pipeline.Pipeline;
import edu.umn.cs.melt.copper.compiletime.pipeline.StandardPipeline;
import edu.umn.cs.melt.copper.compiletime.pipeline.StandardSpecCompiler;
import edu.umn.cs.melt.copper.compiletime.pipeline.StandardSpecCompilerReturnData;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.srcbuilders.fragment.FragmentSerializationProcess;
import edu.umn.cs.melt.copper.compiletime.srcbuilders.fragment.ParserFragmentCompositionProcess;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

public enum CopperPipelineType {
    GRAMMARBEANS{

        @Override
        StandardPipeline<ParserBean, StandardSpecCompilerReturnData> getPipeline(ParserCompilerParameters args) {
            return new StandardPipeline<ParserBean, StandardSpecCompilerReturnData>(args.getUseSkin().getStandardSpecParser(args), new StandardSpecCompiler(), args.getUseEngine().getStandardSourceBuilder(args));
        }

        @Override
        boolean isAvailable() {
            return true;
        }

        @Override
        String usageMessage() {
            return "The default pipeline.";
        }

        @Override
        String stringName() {
            return "default";
        }
    }
    ,
    FRAGMENT{

        @Override
        StandardPipeline<ParserBean, FragmentGeneratorReturnData> getPipeline(ParserCompilerParameters args) {
            return new StandardPipeline<ParserBean, FragmentGeneratorReturnData>(args.getUseSkin().getStandardSpecParser(args), new FragmentGenerator(), new FragmentSerializationProcess());
        }

        @Override
        boolean isAvailable() {
            return true;
        }

        @Override
        String usageMessage() {
            return "Generates parser and scanner fragments to be composed later.";
        }

        @Override
        String stringName() {
            return "fragment";
        }
    }
    ,
    FRAGMENT_COMPOSE{

        @Override
        StandardPipeline<ParserFragments, ParserFragments> getPipeline(ParserCompilerParameters args) {
            return new StandardPipeline<ParserFragments, ParserFragments>(new ParserFragmentsDeserializer(args), new ParserFragmentsPasser(args), new ParserFragmentCompositionProcess(args));
        }

        @Override
        boolean isAvailable() {
            return true;
        }

        @Override
        String usageMessage() {
            return "Compose parser and scanner fragments generated in the 'compose' pipeline.";
        }

        @Override
        String stringName() {
            return "fragmentCompose";
        }
    }
    ,
    LEGACY{

        @Override
        Pipeline getPipeline(ParserCompilerParameters args) {
            try {
                Class<?> c = Pipeline.class.getClassLoader().loadClass("edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.LegacyPipeline");
                return (Pipeline)c.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return new ErrorPipeline();
        }

        @Override
        boolean isAvailable() {
            return !(this.getPipeline(null) instanceof ErrorPipeline);
        }

        @Override
        String usageMessage() {
            return "The pipeline used in Copper 0.5 and 0.6.";
        }

        @Override
        String stringName() {
            return "legacy";
        }
    };

    private static Hashtable<String, CopperPipelineType> fromStringTable;

    static void initTable() {
        if (fromStringTable != null) {
            return;
        }
        fromStringTable = new Hashtable();
        for (CopperPipelineType pt : CopperPipelineType.values()) {
            if (!pt.isAvailable()) continue;
            fromStringTable.put(pt.stringName(), pt);
        }
    }

    static boolean contains(String s) {
        return fromStringTable.containsKey(s);
    }

    static Set<String> strings() {
        CopperPipelineType.initTable();
        return new TreeSet<String>(fromStringTable.keySet());
    }

    static CopperPipelineType fromString(String s) {
        return fromStringTable.get(s);
    }

    abstract String stringName();

    abstract String usageMessage();

    abstract boolean isAvailable();

    abstract Pipeline getPipeline(ParserCompilerParameters var1);

    static {
        fromStringTable = null;
    }

    private static class ErrorPipeline
    implements Pipeline {
        private ErrorPipeline() {
        }

        @Override
        public int execute(ParserCompilerParameters args) throws IOException, CopperException {
            CompilerLogger logger = AuxiliaryMethods.getOrMakeLogger(args);
            if (logger.isLoggable(CompilerLevel.QUIET)) {
                logger.log(new GenericMessage(CompilerLevel.QUIET, "This pipeline is not available"));
            }
            return 1;
        }

        @Override
        public Set<String> getCustomSwitches() {
            return new HashSet<String>();
        }

        @Override
        public String customSwitchUsage() {
            return "";
        }

        @Override
        public int processCustomSwitch(ParserCompilerParameters args, String[] cmdline, int index) {
            return index;
        }
    }
}

