/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogHandler;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.LexicalConflictResolution;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CompilerLogger {
    protected Logger logger;
    protected CompilerLogHandler handler;
    protected PrintStream out;
    private int tickCounter = -1;
    private int parseTableConflictCounter = 0;
    private int resolvedParseTableConflictCounter = 0;
    private int lexicalConflictCounter = 0;
    private int resolvedLexicalConflictByContextCounter = 0;
    private int resolvedLexicalConflictByGroupCounter = 0;
    private boolean hasErrors = false;

    protected CompilerLogger() {
    }

    public void logMessage(CompilerLogMessageSort sort, InputPosition location, String message) {
        Object[] parameters = new Object[]{sort, location, false};
        this.hasErrors |= sort.isErrorLevel();
        this.logger.log(sort.getLevel(), message, parameters);
    }

    public void logTick(int modulo, String message) {
        this.tickCounter = (this.tickCounter + 1) % modulo;
        if (this.tickCounter != 0) {
            return;
        }
        Object[] parameters = new Object[]{CompilerLogMessageSort.TICK, null, false};
        this.logger.log(CompilerLogMessageSort.TICK.getLevel(), message, parameters);
        this.flushTicks();
    }

    public void logErrorMessage(CompilerLogMessageSort sort, InputPosition location, String message) throws CopperException {
        Object[] parameters = new Object[]{sort, location, true};
        this.hasErrors |= sort.isErrorLevel();
        this.logger.log(sort.getLevel(), message, parameters);
        this.flushMessages();
    }

    public void logParseTableConflict(CompilerLogMessageSort sort, boolean resolved, int statenum, String cell, String message) {
        ++this.parseTableConflictCounter;
        if (resolved) {
            ++this.resolvedParseTableConflictCounter;
        }
        Object[] parameters = new Object[]{sort, statenum, false, cell};
        this.hasErrors |= sort.isErrorLevel();
        this.logger.log(sort.getLevel(), message, parameters);
    }

    public void logLexicalConflict(CompilerLogMessageSort sort, LexicalConflictResolution howResolved, TreeSet<Integer> states, HashSet<Terminal> ambiguity, String message) {
        ++this.lexicalConflictCounter;
        if (howResolved != null) {
            switch (howResolved) {
                case CONTEXT: {
                    ++this.resolvedLexicalConflictByContextCounter;
                    break;
                }
                case DISAMBIGUATION_FUNCTION: {
                    ++this.resolvedLexicalConflictByGroupCounter;
                    break;
                }
            }
        }
        Object[] parameters = new Object[]{sort, states, howResolved == null, ambiguity};
        this.hasErrors |= sort.isErrorLevel();
        this.logger.log(sort.getLevel(), message, parameters);
    }

    public void logParsingErrorMessage(VirtualLocation virtualLocation, int statenum, long realCharIndex, String message) throws CopperException {
        Object[] parameters = new Object[]{CompilerLogMessageSort.PARSING_ERROR, virtualLocation, true, statenum, realCharIndex};
        this.logger.log(CompilerLogMessageSort.PARSING_ERROR.getLevel(), message, parameters);
        this.flushMessages();
    }

    public abstract void flushMessages() throws CopperException;

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public abstract void flushTicks();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public CompilerLogHandler getHandler() {
        return this.handler;
    }

    public void setHandler(CompilerLogHandler handler) {
        this.handler = handler;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public int getParseTableConflictCounter() {
        return this.parseTableConflictCounter;
    }

    public void setParseTableConflictCounter(int conflictCounter) {
        this.parseTableConflictCounter = conflictCounter;
    }

    public int getResolvedParseTableConflictCounter() {
        return this.resolvedParseTableConflictCounter;
    }

    public void setResolvedParseTableConflictCounter(int resolvedConflictCounter) {
        this.resolvedParseTableConflictCounter = resolvedConflictCounter;
    }

    public int getLexicalConflictCounter() {
        return this.lexicalConflictCounter;
    }

    public void setLexicalConflictCounter(int lexicalConflictCounter) {
        this.lexicalConflictCounter = lexicalConflictCounter;
    }

    public int getResolvedLexicalConflictByContextCounter() {
        return this.resolvedLexicalConflictByContextCounter;
    }

    public void setResolvedLexicalConflictByContextCounter(int resolvedLexicalConflictByContextCounter) {
        this.resolvedLexicalConflictByContextCounter = resolvedLexicalConflictByContextCounter;
    }

    public int getResolvedLexicalConflictByGroupCounter() {
        return this.resolvedLexicalConflictByGroupCounter;
    }

    public void setResolvedLexicalConflictByGroupCounter(int resolvedLexicalConflictByGroupCounter) {
        this.resolvedLexicalConflictByGroupCounter = resolvedLexicalConflictByGroupCounter;
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public boolean isLoggable(CompilerLogMessageSort sort) {
        return this.logger.isLoggable(sort.getLevel());
    }
}

