/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.DecoratedNode;
import common.Lazy;
import common.exceptions.SilverInternalError;
import java.util.Arrays;
import java.util.List;

public abstract class Decorator {
    public abstract void decorate(Class<?> var1);

    public static void applyDecorators(List<Decorator> nonterminal, Class<?> production) {
        for (Decorator decorator : nonterminal) {
            decorator.decorate(production);
        }
    }

    protected static void decorateAutoCopy(Class<?> production, String attribute) {
        Lazy[][] inheritedAttributes;
        Class[] childTypes;
        int attrindex;
        try {
            String[] oi = (String[])production.getField("occurs_inh").get(null);
            attrindex = Arrays.asList(oi).indexOf(attribute);
            if (attrindex == -1) {
                throw new SilverInternalError("Attribute doesn't occur on NT it is supposed to?");
            }
        }
        catch (Throwable t) {
            throw new SilverInternalError("Error while applying autocopy decorators.", t);
        }
        acLazy eq = new acLazy(attrindex);
        try {
            childTypes = (Class[])production.getField("childTypes").get(null);
            inheritedAttributes = (Lazy[][])production.getField("childInheritedAttributes").get(null);
        }
        catch (Throwable t) {
            throw new SilverInternalError("Attempting to decorate a nonproduction?", t);
        }
        for (int i = 0; i < childTypes.length; ++i) {
            String[] occurs;
            try {
                occurs = (String[])childTypes[i].getField("occurs_inh").get(null);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Throwable t) {
                throw new SilverInternalError("Problem fetching class information through reflection.", t);
            }
            int loc = Arrays.asList(occurs).indexOf(attribute);
            if (loc == -1 || inheritedAttributes[i][loc] != null) continue;
            inheritedAttributes[i][loc] = eq;
        }
    }

    private static class acLazy
    implements Lazy {
        private final int attr;

        acLazy(int s) {
            this.attr = s;
        }

        @Override
        public Object eval(DecoratedNode context) {
            return context.inherited(this.attr);
        }
    }
}

