/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.Counterexample;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.Derivation;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.LookaheadSensitiveGraphVertex;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.ProductionStepTables;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.ShiftConflictSearchNode;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.StateItem;
import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.TransitionFunctionTables;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class CounterexampleSearch {
    private LookaheadSensitiveGraphVertex startVertex;
    private int conflictState;
    private StateItem conflictItem1;
    private StateItem conflictItem2;
    private int conflictTerminal;
    private boolean isShiftReduce;
    private ParserSpec spec;
    private PSSymbolTable symbolTable;
    private ContextSets contextSets;
    private LR0DFA dfa;
    private LRLookaheadSets lookaheadSets;
    private TransitionFunctionTables transitionTables;
    private ProductionStepTables productionStepTables;
    ArrayList<StateItem> shortestLookaheadSensitivePath;
    private BitSet shortestLookaheadSensitiveSet = new BitSet();
    private BitSet reduceProductionSet = new BitSet();

    public CounterexampleSearch(LRParseTableConflict conflict, ParserSpec spec, PSSymbolTable symbolTable, ContextSets contextSets, LRLookaheadSets lookaheadSets, LR0DFA dfa) {
        int i;
        this.conflictState = conflict.getState();
        this.conflictTerminal = conflict.getSymbol();
        this.spec = spec;
        this.symbolTable = symbolTable;
        this.contextSets = contextSets;
        this.dfa = dfa;
        this.lookaheadSets = lookaheadSets;
        int conflictItem1Production = -1;
        int conflictItem1Position = -1;
        BitSet conflictItem1Lookahead = null;
        int conflictItem2Production = -1;
        int conflictItem2Position = -1;
        BitSet conflictItem2Lookahead = null;
        this.isShiftReduce = conflict.shift != -1;
        LR0ItemSet conflictStateItems = dfa.getItemSet(this.conflictState);
        if (this.isShiftReduce) {
            conflictItem1Production = conflict.reduce.nextSetBit(0);
            conflictItem1Position = spec.pr.getRHSLength(conflictItem1Production);
            for (i = 0; i < conflictStateItems.size(); ++i) {
                if (conflictStateItems.getProduction(i) != conflictItem1Production || conflictStateItems.getPosition(i) != conflictItem1Position) continue;
                conflictItem1Lookahead = lookaheadSets.getLookahead(this.conflictState, i);
                break;
            }
            if (conflictItem1Position == -1) {
                System.out.println("conflictItem1Production: " + conflictItem1Production);
                throw new Error("Failed to find reduce conflict item");
            }
            for (i = 0; i < conflictStateItems.size(); ++i) {
                int prod = conflictStateItems.getProduction(i);
                int pos = conflictStateItems.getPosition(i);
                if (spec.pr.getRHSLength(prod) <= pos || spec.pr.getRHSSym(prod, pos) != this.conflictTerminal) continue;
                conflictItem2Position = pos;
                conflictItem2Production = prod;
                conflictItem2Lookahead = lookaheadSets.getLookahead(this.conflictState, i);
                break;
            }
            if (conflictItem2Position == -1 || conflictItem2Production == -1) {
                throw new Error("Failed to find shift conflict item");
            }
        } else {
            conflictItem1Production = conflict.reduce.nextSetBit(0);
            for (i = 0; i < conflictStateItems.size(); ++i) {
                if (conflictStateItems.getProduction(i) != conflictItem1Production) continue;
                conflictItem1Position = conflictStateItems.getPosition(i);
                conflictItem1Lookahead = lookaheadSets.getLookahead(this.conflictState, i);
                break;
            }
            if (conflictItem1Position == -1) {
                System.out.println("conflictItem1Production: " + conflictItem1Production);
                throw new Error("Failed to find first reduce conflict item");
            }
            conflictItem2Production = conflict.reduce.nextSetBit(conflictItem1Production + 1);
            for (i = 0; i < conflictStateItems.size(); ++i) {
                if (conflictStateItems.getProduction(i) != conflictItem2Production) continue;
                conflictItem2Position = conflictStateItems.getPosition(i);
                conflictItem2Lookahead = lookaheadSets.getLookahead(this.conflictState, i);
                break;
            }
            if (conflictItem2Position == -1) {
                System.out.println("conflictItem2Production: " + conflictItem2Production);
                throw new Error("Failed to find reduce conflict item");
            }
        }
        this.conflictItem1 = new StateItem(this.conflictState, conflictItem1Production, conflictItem1Position, conflictItem1Lookahead);
        this.conflictItem2 = new StateItem(this.conflictState, conflictItem2Production, conflictItem2Position, conflictItem2Lookahead);
        BitSet initLookaheadSet = new BitSet();
        initLookaheadSet.set(spec.getEOFTerminal());
        this.startVertex = new LookaheadSensitiveGraphVertex(1, spec.getStartProduction(), 0, initLookaheadSet);
        this.transitionTables = new TransitionFunctionTables(dfa, spec, lookaheadSets);
        this.productionStepTables = new ProductionStepTables(dfa, spec, lookaheadSets);
        this.shortestLookaheadSensitivePath = this.findShortestLookaheadSensitivePath(this.conflictItem1);
        boolean reduceProdReached = false;
        for (StateItem si : this.shortestLookaheadSensitivePath) {
            this.shortestLookaheadSensitiveSet.set(si.getState());
            if (!(reduceProdReached = reduceProdReached || si.getProduction() == conflictItem1Production)) continue;
            this.reduceProductionSet.set(si.getState());
        }
    }

    public Counterexample getExample() {
        return this.counterexampleFromShortestPath();
    }

    private ArrayList<StateItem> findShortestLookaheadSensitivePath(StateItem target) {
        Set<StateItem> possibleStateItems = this.eligibleStateItems(target);
        LinkedList queue = new LinkedList();
        HashSet<LookaheadSensitiveGraphVertex> visited = new HashSet<LookaheadSensitiveGraphVertex>();
        LinkedList<LookaheadSensitiveGraphVertex> init = new LinkedList<LookaheadSensitiveGraphVertex>();
        init.add(this.startVertex);
        queue.add(init);
        while (!queue.isEmpty()) {
            LinkedList path = (LinkedList)queue.remove();
            LookaheadSensitiveGraphVertex last = (LookaheadSensitiveGraphVertex)path.getLast();
            if (visited.contains(last)) continue;
            visited.add(last);
            if (target.equals(last.stateItem) && last.lookahead.get(this.conflictTerminal)) {
                StateItem[] shortestConflictPath = new ArrayList(path.size());
                for (LookaheadSensitiveGraphVertex v : path) {
                    shortestConflictPath.add(v.stateItem);
                }
                return shortestConflictPath;
            }
            if (this.transitionTables.trans.get(last.stateItem) != null) {
                for (StateItem tranDst : this.transitionTables.trans.get(last.stateItem)) {
                    if (tranDst == null || !possibleStateItems.contains(tranDst)) continue;
                    LookaheadSensitiveGraphVertex next = new LookaheadSensitiveGraphVertex(tranDst, last.lookahead);
                    LinkedList<LookaheadSensitiveGraphVertex> nextPath = new LinkedList<LookaheadSensitiveGraphVertex>(path);
                    nextPath.add(next);
                    queue.add(nextPath);
                }
            }
            if (this.productionStepTables.getProdSteps(last.stateItem) == null) continue;
            BitSet newLookahead = this.followL(last.getProduction(), last.getDotPosition(), last.lookahead);
            BitSet productionSteps = this.productionStepTables.getProdSteps(last.stateItem);
            LR0ItemSet stateItems = this.dfa.getItemSet(last.getState());
            int i = productionSteps.nextSetBit(0);
            while (i >= 0) {
                BitSet l = this.lookaheadSets.getLookahead(last.getState(), i);
                StateItem pStateItem = new StateItem(last.getState(), stateItems.getProduction(i), stateItems.getPosition(i), l);
                if (possibleStateItems.contains(pStateItem)) {
                    LookaheadSensitiveGraphVertex next = new LookaheadSensitiveGraphVertex(pStateItem, newLookahead);
                    LinkedList<LookaheadSensitiveGraphVertex> nextPath = new LinkedList<LookaheadSensitiveGraphVertex>(path);
                    nextPath.add(next);
                    queue.add(nextPath);
                }
                i = productionSteps.nextSetBit(i + 1);
            }
        }
        throw new Error("Cannot find shortest path along lookahead sensitive graph");
    }

    private Set<StateItem> eligibleStateItems(StateItem target) {
        HashSet<StateItem> result = new HashSet<StateItem>();
        LinkedList<StateItem> queue = new LinkedList<StateItem>();
        queue.add(target);
        while (!queue.isEmpty()) {
            StateItem s = (StateItem)queue.remove();
            if (result.contains(s)) continue;
            result.add(s);
            if (this.transitionTables.revTrans.containsKey(s)) {
                queue.addAll((Collection)this.transitionTables.revTrans.get(s));
            }
            if (s.getDotPosition() != 0) continue;
            int lhs = this.spec.pr.getLHS(s.getProduction());
            BitSet revProd = this.productionStepTables.getRevProdSteps(s.getState(), lhs);
            if (revProd == null) continue;
            int i = revProd.nextSetBit(0);
            while (i >= 0) {
                LR0ItemSet itemSet = this.dfa.getItemSet(s.getState());
                BitSet l = this.lookaheadSets.getLookahead(s.getState(), i);
                queue.add(new StateItem(s.getState(), itemSet.getProduction(i), itemSet.getPosition(i), l));
                i = revProd.nextSetBit(i + 1);
            }
        }
        return result;
    }

    private BitSet followL(int production, int dotPosition, BitSet lookaheadSet) {
        int rhsLength = this.spec.pr.getRHSLength(production);
        if (dotPosition == rhsLength - 1) {
            return lookaheadSet;
        }
        int sym = this.spec.pr.getRHSSym(production, dotPosition + 1);
        if (this.spec.terminals.get(sym)) {
            BitSet preciseLookaheadSet = new BitSet();
            preciseLookaheadSet.set(sym);
            return preciseLookaheadSet;
        }
        if (!this.contextSets.isNullable(sym)) {
            return this.contextSets.getFirst(sym);
        }
        BitSet bs = this.contextSets.getFirst(sym);
        BitSet bsp = this.followL(production, dotPosition + 1, lookaheadSet);
        bs.or(bsp);
        return bs;
    }

    private Counterexample counterexampleFromShortestPath() {
        return this.counterexampleFromShortestPath(this.shortestLookaheadSensitivePath, null, null);
    }

    private Counterexample counterexampleFromShortestPath(ArrayList<StateItem> shortestPath, LinkedList<Derivation> derivs1, LinkedList<Derivation> derivs2) {
        if (derivs1 == null || derivs2 == null) {
            derivs1 = new LinkedList();
            derivs2 = new LinkedList();
        }
        if (!this.isShiftReduce) {
            StateItem si = new StateItem(this.conflictState, this.conflictItem2.getProduction(), this.conflictItem2.getDotPosition(), this.conflictItem2.getLookahead());
            ArrayList<StateItem> shortestPath2 = this.findShortestLookaheadSensitivePath(si);
            Derivation deriv1 = this.completeNonUnifyingExample(shortestPath, derivs1);
            Derivation deriv2 = this.completeNonUnifyingExample(shortestPath2, derivs2);
            return new Counterexample(deriv1, deriv2, this.isShiftReduce);
        }
        ArrayList<StateItem> shiftConflictPath = this.findShiftConflictPath(shortestPath);
        Derivation deriv1 = this.completeNonUnifyingExample(shortestPath, derivs1);
        Derivation deriv2 = this.completeNonUnifyingExample(shiftConflictPath, derivs2);
        return new Counterexample(deriv1, deriv2, this.isShiftReduce);
    }

    private ArrayList<StateItem> findShiftConflictPath(ArrayList<StateItem> shortestPath) {
        ArrayList<Integer> shortestPathStates = new ArrayList<Integer>();
        shortestPathStates.add(shortestPath.get(0).getState());
        for (StateItem s : shortestPath) {
            if (s.getState() == ((Integer)shortestPathStates.get(shortestPathStates.size() - 1)).intValue()) continue;
            shortestPathStates.add(s.getState());
        }
        LinkedList queue = new LinkedList();
        LinkedList<ShiftConflictSearchNode> startPath = new LinkedList<ShiftConflictSearchNode>();
        startPath.addFirst(new ShiftConflictSearchNode(shortestPathStates.size() - 2, this.conflictItem2));
        queue.add(startPath);
        while (!queue.isEmpty()) {
            LinkedList path = (LinkedList)queue.remove();
            ShiftConflictSearchNode head = (ShiftConflictSearchNode)path.getFirst();
            if (head.getStateItem().equals(this.startVertex.stateItem) || head.getStateItem().getState() == 0) {
                ArrayList<StateItem> result = new ArrayList<StateItem>(path.size());
                for (ShiftConflictSearchNode n : path) {
                    result.add(n.getStateItem());
                }
                return result;
            }
            if (head.isProductionItem()) {
                BitSet revProd = this.productionStepTables.getRevProdSteps(head.getStateItem().getState(), this.spec.pr.getLHS(head.getStateItem().getProduction()));
                if (revProd == null) continue;
                LR0ItemSet itemSet = this.dfa.getItemSet(head.getStateItem().getState());
                int i = revProd.nextSetBit(0);
                while (i >= 0) {
                    int newState = head.getStateItem().getState();
                    BitSet l = this.lookaheadSets.getLookahead(newState, i);
                    StateItem newStateItem = new StateItem(newState, itemSet.getProduction(i), itemSet.getPosition(i), l);
                    LinkedList<ShiftConflictSearchNode> newPath = new LinkedList<ShiftConflictSearchNode>();
                    newPath.addAll(path);
                    newPath.addFirst(new ShiftConflictSearchNode(head.getValidStateIndex(), newStateItem));
                    queue.add(newPath);
                    i = revProd.nextSetBit(i + 1);
                }
                continue;
            }
            Set<StateItem> revTran = this.transitionTables.revTrans.get(head.getStateItem());
            for (StateItem s : revTran) {
                if (s.getState() != ((Integer)shortestPathStates.get(head.getValidStateIndex())).intValue()) continue;
                LinkedList<ShiftConflictSearchNode> newPath = new LinkedList<ShiftConflictSearchNode>(path);
                newPath.addFirst(new ShiftConflictSearchNode(head.getValidStateIndex() - 1, s));
                queue.add(newPath);
            }
        }
        throw new Error("failed to find shift conflict path");
    }

    private Derivation completeNonUnifyingExample(ArrayList<StateItem> states, LinkedList<Derivation> derivations) {
        LinkedList<Derivation> result = new LinkedList<Derivation>();
        for (int i = states.size() - 1; i >= 0; --i) {
            boolean lookaheadRequired = false;
            StateItem stateItem = states.get(i);
            int pos = stateItem.getDotPosition();
            int prod = stateItem.getProduction();
            int len = this.spec.pr.getRHSLength(prod);
            if (result.isEmpty()) {
                if (derivations.isEmpty()) {
                    result.add(Derivation.dot);
                    lookaheadRequired = true;
                }
                if (pos != len) {
                    result.add(new Derivation(this.symbolTable.getSymbolString(this.spec.pr.getRHSSym(prod, pos))));
                    lookaheadRequired = false;
                }
            }
            for (int j = pos + 1; j < len; ++j) {
                int symbol = this.spec.pr.getRHSSym(prod, j);
                if (lookaheadRequired) {
                    if (symbol != this.conflictTerminal) {
                        if (!this.spec.nonterminals.get(symbol)) continue;
                        if (!this.contextSets.isNullable(symbol) || this.contextSets.getFirst(symbol).get(this.conflictTerminal)) {
                            LinkedList<Derivation> nextDerivations = this.expandFirst(this.transitionTables.getTransition(stateItem, this.spec.pr.getRHSSym(prod, pos)));
                            result.addAll(nextDerivations);
                            j += nextDerivations.size() - 1;
                            lookaheadRequired = false;
                            continue;
                        }
                        result.add(new Derivation(this.symbolTable.getSymbolString(symbol)));
                        continue;
                    }
                    result.add(new Derivation(this.symbolTable.getSymbolString(symbol)));
                    lookaheadRequired = false;
                    continue;
                }
                result.add(new Derivation(this.symbolTable.getSymbolString(symbol)));
            }
            Iterator<Derivation> derivationItr = derivations.descendingIterator();
            for (int j = pos - 1; j >= 0; --j) {
                if (i > 0) {
                    --i;
                }
                result.addFirst(derivationItr.hasNext() ? derivationItr.next() : new Derivation(this.symbolTable.getSymbolString(this.spec.pr.getRHSSym(prod, j))));
            }
            Derivation deriv = new Derivation(this.symbolTable.getSymbolString(this.spec.pr.getLHS(prod)), result);
            result = new LinkedList();
            result.add(deriv);
        }
        return (Derivation)result.getFirst();
    }

    private LinkedList<Derivation> expandFirst(StateItem start) {
        LinkedList queue = new LinkedList();
        LinkedList<StateItem> init = new LinkedList<StateItem>();
        init.add(start);
        queue.add(init);
        while (!queue.isEmpty()) {
            LinkedList states = (LinkedList)queue.remove();
            StateItem lastSI = (StateItem)states.getLast();
            int symbolAfterDot = this.spec.pr.getRHSSym(lastSI.getProduction(), lastSI.getDotPosition());
            if (symbolAfterDot == this.conflictTerminal) {
                LinkedList<Derivation> result = new LinkedList<Derivation>();
                result.add(new Derivation(this.symbolTable.getSymbolString(this.conflictTerminal)));
                for (int i = states.size() - 1; i >= 0; --i) {
                    StateItem si = (StateItem)states.get(i);
                    int pos = si.getDotPosition();
                    int prod = si.getProduction();
                    if (pos == 0) {
                        int len = this.spec.pr.getRHSLength(prod);
                        for (int j = pos + 1; j < len; ++j) {
                            result.add(new Derivation(this.symbolTable.getSymbolString(this.spec.pr.getRHSSym(prod, j))));
                        }
                        int lhs = this.spec.pr.getLHS(prod);
                        Derivation deriv = new Derivation(this.symbolTable.getSymbolString(lhs), result);
                        result = new LinkedList();
                        result.add(deriv);
                        continue;
                    }
                    Derivation deriv = new Derivation(this.symbolTable.getSymbolString(this.spec.pr.getRHSSym(prod, pos - 1)));
                    result.addFirst(deriv);
                }
                result.removeFirst();
                return result;
            }
            if (!this.spec.nonterminals.get(symbolAfterDot)) continue;
            BitSet prodSteps = this.productionStepTables.getProdSteps(lastSI);
            int i = prodSteps.nextSetBit(0);
            while (i >= 0) {
                LR0ItemSet itemSet = this.dfa.getItemSet(lastSI.getState());
                BitSet lookahead = this.lookaheadSets.getLookahead(lastSI.getState(), i);
                StateItem nextSI = new StateItem(lastSI.getState(), itemSet.getProduction(i), itemSet.getPosition(i), lookahead);
                if (!states.contains(nextSI)) {
                    LinkedList<StateItem> next = new LinkedList<StateItem>(states);
                    next.add(nextSI);
                    queue.add(next);
                }
                i = prodSteps.nextSetBit(i + 1);
            }
            if (!this.contextSets.isNullable(symbolAfterDot)) continue;
            StateItem nextSI = this.transitionTables.getTransition(lastSI, symbolAfterDot);
            LinkedList<StateItem> next = new LinkedList<StateItem>(states);
            next.add(nextSI);
            queue.add(next);
        }
        throw new Error("Invalid state reached in expandFirst");
    }
}

